# Title: 
# Creator: Calvin He
# Date Created: 09 December 2019
# Description:
# Outputs: 

# Step 0: Set options -----------------------------------------------

set_options <- function(figure){
  
  if (figure == 2 | figure == 7){
    
    opts <- list()
    # Data construction
    opts$metric_dependent <- "hedonic_index" # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994)# years to determine price groups i.e median sales price from which years
    
    # Number of groupsTRUE
    opts$group_no <- 1 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group"  # "investor_density_working_age_pop" # "price_group" 
    
    # Monetary policy shock options
    opts$mp_shock_type <-  "cash_rate_change_qtr" # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 16 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- FALSE # Asymmetry between positive and negative shocks 
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <- c("gdp", "tot", "unemp") # c("gdp")
    opts$agg_control_lags <- 0
    opts$agg_control_interaction <- TRUE
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
  }
  
  if (figure == 3){
    
    opts <- list()
    # Data construction
    opts$metric_dependent <- "hedonic_index"  # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994)# years to determine price groups i.e median sales price from which years
    
    # Number of groupsTRUE
    opts$group_no <- 1 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group"   # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <-  "cash_rate_change_qtr" # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 16 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- FALSE # Asymmetry between positive and negative shocks 
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <- c("gdp", "tot", "unemp") # c("gdp")
    opts$agg_control_lags <- 0
    opts$agg_control_interaction <- TRUE
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
  }
  
  if (figure == 4){
    
    opts <- list()
    
    # Data construction
    opts$metric_dependent <-  "hedonic_index" # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994) # years to determine price groups i.e median sales price from which years
    
    # Number of groups
    opts$group_no <- 10 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group"  # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <- "cash_rate_change_qtr"  # "cash_rate_change_qtr" #"rr_final_qtr"  # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30"# end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 16 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- F # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <-  c("gdp", "tot", "unemp") # gdp, tot
    opts$agg_control_interaction <- TRUE
    opts$agg_control_lags <- 0
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
    
    
  }
  
  
  if (figure == 5){
    
    # Step 0: Set options -----------------------------------------------
    opts <- list()
    
    # Data construction
    opts$metric_dependent <-"hedonic_index"  # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "H"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994) # years to determine price groups i.e median sales price from which years
    
    # Number of groups
    opts$group_no <- 10 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group"   # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <-  "cash_rate_change_qtr" # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 12 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- F # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <- c("gdp", "tot", "unemp") # gdp, tot
    opts$agg_control_interaction <- TRUE
    opts$agg_control_lags <- 0
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
    
    
  }
  
  if (figure == 6 ){
    
    opts <- list()
    
    # Data construction
    opts$metric_dependent <-  "hedonic_index" # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994) # years to determine price groups i.e median sales price from which years
    
    # Number of groups
    opts$group_no <- 10 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "prop_physical"  # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <- "cash_rate_change_qtr"  # "cash_rate_change_qtr" #"rr_final_qtr"  # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 16 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- F # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <-  c("gdp", "tot", "unemp") # gdp, tot
    opts$agg_control_interaction <- TRUE
    opts$agg_control_lags <- 0
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
    
  }
  
  
  if(figure == 8){
    
    # Step 0: Set options -----------------------------------------------
    opts <- list()
    
    # Data construction
    opts$metric_dependent <-  "hedonic_index" # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- T
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994) # years to determine price groups i.e median sales price from which years
    
    # Number of groups
    opts$group_no <- 5 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group" # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <- "cash_rate_change_qtr"  # "cash_rate_change_qtr" #"rr_final_qtr"  # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 16 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- F # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <-  c("gdp", "tot", "unemp") # gdp, tot
    opts$agg_control_interaction <- TRUE
    opts$agg_control_lags <- 0
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
    
  }
  
  if (figure == 9){
    
    opts <- list()
    
    # Data construction
    opts$metric_dependent <-"hedonic_index"  # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994) # years to determine price groups i.e median sales price from which years
    
    # Number of groups
    opts$group_no <- 10 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group"  # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <-  "cash_rate_change_qtr" # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 12 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- F # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <-  c("gdp", "tot", "unemp") # gdp, tot
    opts$agg_control_lags <- 0
    opts$agg_control_interaction <- TRUE
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
  }
  
  if (figure == 11){
    # Step 0: Set options -----------------------------------------------
    opts <- list()
    
    # Data construction
    opts$metric_dependent <-  "median_sales_price" # dependent variable: unique(core_logic_data_raw$metric_name)
    opts$metric_deflate <- T
    opts$metric_diff <- T
    opts$metric_log_diff <- T
    opts$prop_type <- "D"
    opts$metro_only <- F
    
    # Price group definition
    opts$price_group_defn <- c(1991, 1992, 1993, 1994) # years to determine price groups i.e median sales price from which years
    
    # Number of groups
    opts$group_no <- 10 # how many price groups? 10 = deciles, 5 =quintiles etc
    opts$group_var <- "price_group"  # grouping variable
    
    # Monetary policy shock options
    opts$mp_shock_type <- "cash_rate_change_qtr"  # "cash_rate_change_qtr" #"rr_final_qtr"  # names(monetary_policy_shocks_raw) will show you your options
    opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
    opts$start_date <- "1990-01-01" # start date
    opts$end_date <- "2019-06-30" # end date
    
    # Regression/data options
    opts$frequency <- 3 #1= months # 3 = quarters
    opts$horizon <- 16 # projection horizon in quarters
    opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
    opts$shock_lag <- 4 # Include how many lags of the shock series
    opts$asymmetry <- F # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]
    
    # Regression equation
    opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
    opts$controls <- c()  #local controls
    opts$agg_controls <-  c("gdp", "tot", "unemp") # gdp, tot
    opts$agg_control_interaction <- TRUE
    opts$agg_control_lags <- 0
    opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
    opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
    opts$ar_lag <- 0
    
  }

  return(opts)
  
}

model_selection_options <- function(){

opts <- list()
# Data construction
opts$metric_dependent <- "hedonic_index" # dependent variable: unique(core_logic_data_raw$metric_name)
opts$metric_deflate <- T
opts$metric_diff <- T
opts$metric_log_diff <- T
opts$prop_type <- "D"
opts$metro_only <- F

# Price group definition
opts$price_group_defn <- c(1991, 1992, 1993, 1994)# years to determine price groups i.e median sales price from which years

# Number of groups
opts$group_no <- 10 # how many price groups? 10 = deciles, 5 =quintiles etc
opts$group_var <- "price_group"  # grouping variable

# Monetary policy shock options
opts$mp_shock_type <-  "cash_rate_change_qtr" # names(monetary_policy_shocks_raw) will show you your options
opts$mp_shocks_accumulate <- TRUE # do you want to accumulate your shocks over the quarter?
opts$start_date <- "1990-01-01" # start date
opts$end_date <-  "2019-06-30" # end date

# Regression/data options
opts$frequency <- 3 #1= months # 3 = quarters
opts$horizon <- 12 # projection horizon in quarters
opts$remove_gfc <- FALSE # if TRUE, will remove the GFC period
opts$shock_lag <- 4 # Include how many lags of the shock series
opts$asymmetry <- FALSE # Asymmetry between positive and negative shocks [don't put this as TRUE yet, not sure if this code is robust to it]

# Regression equation
opts$mp_interaction_var <- "group" #  price group defined in price_group options; or group to be interacted with group_var
opts$controls <- c() #local controls
opts$agg_controls <- c("gdp", "tot", "unemp")# gdp, tot
opts$agg_control_interaction <- TRUE
opts$agg_control_lags <- 0
opts$fixed_effect_vars <- c("region_code", "Date") # fixed effect variables see columns via colnames(cl_raw_data)
opts$cluster_vars <- c("Date", "STATE_NAME_2016") # variables to cluster on see variable names via colnames(cl_raw_data)
opts$ar_lag <- 0
return(opts)

}
