# Function to run all projections on all horizons for one sa3
individual_reg <- function(reg_data_pre, m){
  
  map_dfr(1:m , function(z){
    # Take pre-treated data and create y  variable by region_name
    reg_data_mod <- reg_data_pre %>% 
      arrange(Date) %>%
      mutate(calculation_value = case_when(calculation_value == 0 ~ calculation_value +1,
                                           TRUE ~ calculation_value)) %>% 
      mutate(y = 100*( log(dplyr::lead(calculation_value, z)) - log(calculation_value))) %>% # calculate y variable
      ungroup  %>%
      filter(!is.na(y)) 
    
    # Select Decile Interaction; controls; turn into panel data
    reg_data_final <- reg_data_mod %>%   
      select(  y, contains("mp_shock"), contains("control") )
    
    # add in city interactions +  city fixed effects
    reg_output  <- lm(expand_formula(form = "y ~. ", varNames = names(reg_data_final)), data = reg_data_final)
    
    # Construct output
    # https://stats.stackexchange.com/questions/117052/replicating-statas-robust-option-in-r
    output <- reg_output %>% 
      {lmtest::coeftest(., vcov= sandwich::vcovHC(., "HC1") )} %>% tidy() %>%
      mutate( horizon = z,
              lower_bound= estimate-1.96*std.error, 
              upper_bound=estimate+1.96*std.error ) %>% 
      select(term, horizon, everything()) 
    
    
    return(output)
  }
  )
}


# Expand formula 
expand_formula <- function(form="A ~.",varNames=c("A","B","C")){
  has_dot <- any(grepl('.',form,fixed=TRUE))
  if(has_dot){
    ii <- intersect(as.character(as.formula(form)),
                    varNames)
    varNames <- varNames[!varNames %in% ii]
    
    exp <- paste0(varNames,collapse='+')
    as.formula(gsub('.',exp,form,fixed=TRUE))
    
  }
  else as.formula(form)
}
