# Title: Generic function to crate graphs for restricted model 
# Creator: Calvin He


differentials_graphs <- function(reg_output_tidy){
  # 1. Plot ------------------------------------------------------------------------------------
  graph_data <- reg_output_tidy %>% 
    mutate(significant = case_when(p.value > 0.05 & p.value <= 0.1 ~ "10% level", 
                                   p.value > 0.01 & p.value <= 0.05 ~ "5% level",
                                   p.value <= 0.01 ~ "1% level", 
                                   TRUE ~ "Insignificant"),
           ci_lower = estimate - 1.645* std.error,
           ci_upper = estimate + 1.645 * std.error,
           ci_lower_onestd = estimate -  std.error,
           ci_upper_onestd = estimate +   std.error) %>% 
    filter(mp_shock_lag == 0, str_detect(term, "_mp_")) %>% 
    filter(horizon %in% c(1, 3 , 6 , 12)) %>% 
    mutate(horizon = factor(glue::glue("{horizon} quarter horizon"), 
                            levels = c("1 quarter horizon", "3 quarter horizon", "6 quarter horizon", "12 quarter horizon")))
  
  # Map colours 
  colour_map <- tibble(significant = c("1% level", "10% level", "5% level",  "Insignificant" ),
                       colour = c(   "dodgerblue", alpha("dodgerblue", 0.45),  alpha("dodgerblue", 0.75),   "orange"))
  colours <- colour_map %>% filter(significant %in% c(graph_data$significant %>% unique)) %>% .$colour
  
  # Determine y_units and x_units
  y_units <- graph_y_units(graph_data,  y_name = "estimate", increments = 3, epsilon = 0.001 )
  x_units <- graph_x_units(graph_data, x_name = "interaction_var_level")
  
  
  j <- ggplot(graph_data ,
              aes(x = interaction_var_level, y = estimate, fill = significant)) +
    geom_bar(stat = "identity") + 
    scale_fill_manual(values = colours)+
    facet_wrap(~horizon) +
    rba_theme(multipanel = T) +
    labs( caption =  "Sources: ABS; Authors' calculations; CoreLogic data; RBA") +
    scale_x_continuous(name = "Group", breaks = x_units$increments) +
    scale_y_continuous(name = "%", sec.axis = dup_axis(), limits = c(y_units$min_point, y_units$max_point ))+
    coord_cartesian(xlim = c(x_units$min_point, x_units$max_point), expand = FALSE) +
    guides(fill=guide_legend(reverse=FALSE , title=element_blank(), override.aes=list(size=5))) 
  
  
  return(j)
}