# Title: Apartments vs houses
# Creator: Calvin He
# Date Created: 07 February 2020


library(lfe)
library(rGertrude) # RBA package to access internal database
library(data.table)
library(zoo)
library(dummies)
library(rlang)
library(ggplot2)
library(broom)
library(lubridate)
library(tidyverse)


# Step 0: Import functions and data ---------------------------------------
# Import Functions
user.defined.functions<- c(list.files(path = "./R", pattern = ".R",  full.names= T) )
if (length(user.defined.functions)>0){invisible(lapply(user.defined.functions, source))}

# Import Data
corelogic_data_raw <- readRDS("./data/corelogic_data_raw.RDS")
monetary_policy_shocks_raw <- readRDS("./data/monetary_policy_shocks.RDS")
grouping_variables <- readRDS("./data/grouping_variables.RDS")


# Step 1:  Set options and calculate response for houses --------------------------------------------
opts <- set_options(figure = 5)
output_houses <-  differential_response_run(corelogic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts)

# Step 2: Set options and calculate repsonse for units ----------------------------------------------
opts$prop_type <- "U"
output_units <- response_differentials(corelogic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts)

# Plot-----------------------------------------------------------------------------

# create graph data - combine house and apartment data
graph_data <- bind_rows(output_houses$reg_output_tidy %>% filter(horizon == 6, mp_shock_lag ==0) %>% mutate(type = "Houses"),
                        output_units$reg_output_tidy %>% filter(horizon == 6, mp_shock_lag ==0) %>% mutate(type = "Apartments"), 
                        output_units$reg_output_tidy %>% filter(horizon == 6, mp_shock_lag ==0, interaction_var_level == 2) %>% 
                          mutate(type = "Apartments", interaction_var_level = 5 , estimate = 0),
                        output_units$reg_output_tidy %>% filter(horizon == 6, mp_shock_lag ==0, interaction_var_level == 2) %>% 
                          mutate(type = "Houses", interaction_var_level = 5 , estimate = 0) ) %>% 
  filter(!str_detect(term, "agg")) %>% 
  mutate(significance = case_when(p.value > 0.05 & p.value <= 0.1 ~ "10% level", 
                                  p.value > 0.01 & p.value <= 0.05 ~ "5% level",
                                  p.value <= 0.01 ~ "1% level", 
                                  TRUE ~ "Insignificant") ) 

# Read in actual graph data
graph_data <- readRDS("./data/figure-data/figure-5.RDS") # read in actual graph data

# create colour map for significance
colour_map <- tibble(significant = c("1% level", "10% level", "5% level",  "Insignificant" ),
                     colour = c(   "dodgerblue", alpha("dodgerblue", 0.45),  alpha("dodgerblue", 0.75),   "orange")) %>% 
                filter(significant %in% unique(graph_data$significance))

# ggplot
ggplot(graph_data, aes(x=interaction_var_level, y = estimate, fill = significance))+
  facet_wrap(~ type) +
  geom_col() +
  scale_fill_manual(values = colour_map$colour) +
  rba_theme(multipanel = T) +
  scale_y_continuous(name = "%", limits = c(-2.5, 2.499))+
  scale_x_continuous("Price Group", breaks = seq(1, 10, by = 1))
  
