
# Rolling join
rolling_join <- function(df_master ,  df_join, roll_type = T ){ # must be joining by column 'Date'
  # Convert to data table
  df_master <- data.table(df_master)
  df_join <- data.table(df_join)
  
  # Set keys
  setkey(df_master, Date)
  setkey(df_join, Date)
  
  # rolling join
  output <- df_join[df_master, roll= roll_type]
  
  return(output)
  
}

# last day in quarter
last_day_quarter <- function(date) {
  return(ceiling_date(date, unit = 'quarters') - 1)
}

# last day of month
last_day_month <- function(date) {
  return(ceiling_date(date, unit = 'months') - 1)
}