# Deflate a series using trimmed cpi

deflate_series <- function(df,  series2deflate , index_date= "2011-12-31"){
  # Create trimmed mean index ------------------------------------------------------------
  # import series
  trimmed_cpi <- aus_cpi()
  
  # supplement series pre-1982 with all groups cpi
  trimmed_cpi$inf <- ifelse(is.na(trimmed_cpi$inf), trimmed_cpi$Quarterlyinflationoriginal, trimmed_cpi$inf)
  
  # Select inflation
  trimmed_cpi <- trimmed_cpi %>% select(Date, inf)
  
  # Trim the trimmed series (haha...)
  trimmed_cpi <- trimmed_cpi[max(which(is.na(trimmed_cpi$inf)) ):nrow(trimmed_cpi),] 
  
  # Create index
  trimmed_cpi$index_inf <- 100*c(1,cumprod(1+ (trimmed_cpi$inf[2:nrow(trimmed_cpi)]/100 )))
  
  # Re index
  index_date <- as.Date(index_date) %>% last_day_quarter
  trimmed_cpi$index_inf <- 100*trimmed_cpi$index/trimmed_cpi$index[trimmed_cpi$Date==index_date]
  
  trimmed_cpi <- trimmed_cpi %>% select(Date, index_inf)
  
  # Deflate all series in df ---------------------------------------------------------------
  if (missing(series2deflate)){
    series2deflate <- colnames(df)[colnames(df) != "Date"]
  }
  

  df_mod <- rolling_join(df, trimmed_cpi)  %>% data.frame
  
  df_mod[, paste0("real_", series2deflate)] <-  NA #initialise deflated columns
  df_mod[, paste0("real_", series2deflate)] <-  df_mod[,  series2deflate] /df_mod[, "index_inf"] 
  
  return(df_mod)
  
}


# Import trimmed mean cpi from RBA website
aus_cpi <- function(){
  
    # Read in Data
    cpi <- read.csv(url("https://www.rba.gov.au/statistics/tables/csv/g1-data.csv"), skip=1, stringsAsFactors = FALSE) 
    
    # change column names
    colnames(cpi) <- gsub("\\.","",colnames(cpi)) %>% gsub("Title","Date",.)
    
    # convert data types
    cpi[,2:ncol(cpi)] <- sapply(cpi[,2:ncol(cpi)], as.numeric) # to numeric
    cpi$Date <- as.Date(paste0("1-",   cpi$Date), format = "%d-%b-%Y")
    
    # remove rows with date as na
    cpi <- cpi %>% dplyr::filter(!is.na(Date))
    cpi$Date <- cpi$Date %>% last_day_month() %>% as.Date  
    
    # remove column if all na
    cpi <- cpi[,apply(cpi,2,function(x) !all(is.na(x)))]
    
    # remove row if all na
    cpi <- cpi[apply(cpi%>% select(-Date), 1, function(x) !all(is.na(x))) ,]
    
    # generate trimmed mean index
    cpi  <- cpi %>% dplyr::rename(trimed_mean_qtrly_inf = Quarterlytrimmedmeaninflation) %>% 
      mutate( trimmed_mean_index = NA)
    trimmed_mean_index <- c(100, 100*(cumprod(1 + cpi$trimed_mean_qtrly_inf[!is.na( cpi$trimed_mean_qtrly_inf)]/100) - 1) + 100)
    cpi$trimmed_mean_index[(min(which(!is.na(cpi$trimed_mean_qtrly_inf )))-1):nrow(cpi) ] <-   trimmed_mean_index
    
    
    # generate trimmed mean excl interest and tax changes
    trimmed_mean_ex_it <- gertrude_timeseries("AUC100000N1.IS0", mnemonic = "trimmed_mean_ex_it_index") %>% fortify.zoo() %>% 
      rename(Date = Index) %>% 
      mutate(inf = 100*( log(trimmed_mean_ex_it_index) - dplyr::lag(log(trimmed_mean_ex_it_index))),
             trimmed_mean_ex_it_qtrly_inf = inf) 
    
    cpi <- left_join(cpi, trimmed_mean_ex_it, by= "Date")
    
    return(cpi)
}

