### Romer and Romer Regression
rr_regress <- function(data, y_var = "cr_chg", x_vars) {
  
  # Convert to zoo object for dynamic estimation
  yx.zoo <- select(data, -Date)  
  yx.zoo <- zoo(yx.zoo, data$Date)
  
  # Set up equation
  eq_rr <- paste(y_var, " ~ L(", x_vars[1], ", 0)", sep="")
  if (length(x_vars)>1){
    for (k in 2:length(x_vars)){
      eq_rr <- paste(eq_rr, " + L(", x_vars[k], ", 0)", sep="")
    }
  }
  
  # Estimate model
  rr_est <- dynlm(as.formula(eq_rr), yx.zoo)
  
  # Collect output
  y_fit <- rr_est$fitted.values
  rr_shocks <- rr_est$residuals
  
  return(list(rr_est = rr_est, y_fit = y_fit, rr_shocks = rr_shocks))
}