'Program written by Trent Saunders
'--------------------------
'Estimate costs and benefits of LAW
'This program puts together the results in Section 3.6 in Saunders and Tulip (2019).
'--------------------------

'Discount rate (the paper assumes the discount rate is zero)
smpl @all
series weight = 1
smpl %forsd %fored
series weight = weight(-1) * discount

'Estimate 1: Fixed crisis unemployment gap (DEFAULT)
'These are the core estimates discussed in section 3.6 of the paper (p. 15-16)
'--------------------------
smpl %forsd %fored

'Costs and benefits of LAW (flow)
series cost1		= (1 - p_b)*(ur_diff)^2*weight			'Equation 4, Appendix A
series benefit1 	= (p_b - p_s)* scale_p	*((ur_crisis)^2 - (ur_diff)^2) *weight  'Equation 5, Appendix A
series loss1 		= cost1 - benefit1 

'Costs and benefits of LAW (cumulative sum)
series cost1_sum		= @cumsum(cost1)
series benefit1_sum 	= @cumsum(benefit1)	
series loss1_sum 		= @cumsum(loss1)

'Benefit-cost ratio
series bc_ratio1 =  benefit1_sum / @recode(cost1_sum=0, na, cost1_sum)


