'Program written by Trent Saunders
'--------------------------
'Extension: Different assumptions for the costs and benefits of LAW
'This program puts together the results for the extensions in Section 5.2 and Appendix B in Saunders and Tulip (2019)
'--------------------------

'Estimate 2: Svensson - Severity of crisis depends on initial unemployment gap
'Discussed in section 5.2 and Appendix B
'--------------------------
smpl %sd %fored

'Costs and benefits of LAW (flow)
series cost2		= ( (1 - p_b)*(ur_diff)^2 + p_b*((ur_crisis+ur_diff)^2 - ur_crisis^2) )*weight	
series benefit2 	= ( (p_b - p_s)* scale_p	*((ur_crisis+ur_diff)^2 - ur_diff^2) )*weight
series loss2 		= cost2 - benefit2

'Costs and benefits of LAW (cumulative sum)
series cost2_sum		= @cumsum(cost2)
series benefit2_sum 	= @cumsum(benefit2)	
series loss2_sum 		= @cumsum(loss2)
series bc_ratio2 = benefit2_sum / cost2_sum

'Estimate 3: Gerdrup et al - Severity of crisis depends on credit growth
'Discussed in section 5.2 and Appendix B
'--------------------------

'Estimate the effect of credit growth on the expected crisis unemployment gap
smpl @all
'Gerdrup coefficients
for %j b_constant b_slope
	vector(21) {%j}_vec = {%j}	
	delete  {%j}	
	rename {%j}_vec {%j}
next

smpl %forsd %fored
!length = @obssmpl

for %k b s
smpl @all
series g5y_{%k} = (cred_r_{%k} / cred_r_{%k}(-20))-1

for !i = 1 to !length
	smpl %forsd+!i-1 %forsd+!i
	%date = @otods(1)
	scalar g5y_sev_{%k}=@elem(g5y_{%k}, %date)
	vector(20) crisis_sev_{%k} = b_constant + b_slope*g5y_sev_{%k}
	vector(20) crisis_sev_{%k}2
	for !j = 1 to 20
		crisis_sev_{%k}2(!j) = crisis_sev_{%k}(!j)^2
	next
	scalar severity_scalar_{%k} = @sqrt(@sum(crisis_sev_{%k}2)/20)
	series severity_{%k} = severity_scalar_{%k}
next
next

smpl %sd %fored
series severity_diff = severity_s-severity_b

'Costs and benefits of LAW (flow)
series cost3		= ( (1 - p_b)*(ur_diff)^2 ) *weight
series benefit3 	= ( (p_b - p_s)* scale_p *(severity_s^2 - ur_diff^2) + p_b*(severity_b^2 - severity_s^2 ))*weight
series loss3 		= cost3 - benefit3

'Costs and benefits of LAW (cumulative sum)
series cost3_sum		= @cumsum(cost3)
series benefit3_sum 	= @cumsum(benefit3)	
series loss3_sum 		= @cumsum(loss3)

'Benefit-cost ratio
series bc_ratio3 = benefit3_sum / cost3_sum

'Estimate 4: Svensson and Gerdrup et al - Severity depends on both initial unemployment gap and credit growth
'--------------------------

'Costs and benefits of LAW (flow)
series cost4		= ( (1 - p_b)*(ur_diff)^2  +  p_b*( (severity_b+ur_diff)^2 - severity_b^2 + 2*severity_diff*ur_diff) ) *weight
series benefit4 	= ( (p_b - p_s)* scale_p * ((severity_s+ur_diff)^2 - ur_diff^2) + p_b*(severity_b^2 - severity_s^2) )*weight	
series loss4		= cost4 - benefit4

'Costs and benefits of LAW (cumulative sum)
series cost4_sum		= @cumsum(cost4)
series benefit4_sum 	= @cumsum(benefit4)	
series loss4_sum 		= @cumsum(loss4)

'Benefit-cost ratio
series bc_ratio4 = benefit4_sum / cost4_sum

'Re-run baseline programs
include 2_crisis_probability
include 3_cost_benefit


