'Program written by Trent Saunders
'--------------------------
'Estimate probability of a crisis. This is discussed in Section 3.4 in Saunders and Tulip (2019).
'There are lots of options for calculating the probability of a crisis, which you can choose by setting a value for the string %prob in '_main_program.prg'.
'The option used for the baseline results in the paper is a logit specification with fixed effects (i.e. %prob = "logit_fe").
'The coefficient estimates below are estimated using the Stata programs in this
'--------------------------

for %i b s
	smpl %sd %fored

	'The estimated coefficients below are put together in Stata using the Schularick and Taylor (2012) dataset.
	'See readme file for more details.
	'--------------

	'Logit - Fixed effects - Schularick and Taylor (2012) (DEFAULT)
	if %prob = "logit_fe" then
		series x_{%i} = -0.3983921*g_{%i}(-4) + 7.13757*g_{%i}(-8) + 0.8883703*g_{%i}(-12) + 0.2026765*g_{%i}(-16) + 1.866577*g_{%i}(-20) -3.444936  -1.046257
	endif

	'Quadratic - Fixed effects
	if %prob = "quadratic_fe" then
		series x_{%i} = -.0500908*g_{%i}(-4) + .1587127*g_{%i}(-8) -.1375603*g_{%i}(-12) + .2363279*g_{%i}(-16) + .0355819*g_{%i}(-20) +.2258536*(g_{%i}(-4))^2 + 1.096698*(g_{%i}(-8))^2 + 1.110962*(g_{%i}(-12))^2 -1.455341*(g_{%i}(-16))^2 + .4364949*(g_{%i}(-20))^2 + .0118192 -.0120497
	endif

	'Gap - Fixed effects
	if %prob = "gap_fe" then
		series x_{%i} = -.0302182*g_{%i}(-4) + .1529208*g_{%i}(-8) -.0037899*g_{%i}(-12) -.0225819*g_{%i}(-16) + .0789532*g_{%i}(-20)  -.0010793*creditgdpgap + .0597547*(g_{%i}(-8))*creditgdpgap - 0.0064587 + 0.008321
	endif

	'Logit - Pooled - Schularick and Taylor (2012) - Table 3, p1045
	if %prob = "logit_pool" then
		series x_{%i} = -0.2573462*g_{%i}(-4) + 6.955872*g_{%i}(-8) + 1.079293*g_{%i}(-12) + 0.290111*g_{%i}(-16) + 2.03465*g_{%i}(-20) - 3.839115		
	endif

	'Quadratic - Pooled
	if %prob = "quadratic_pool" then
		series x_{%i} = -.0498794*g_{%i}(-4) + .1577333*g_{%i}(-8) -.1381149*g_{%i}(-12) + .2368532*g_{%i}(-16) + .033045*g_{%i}(-20) + .206157*(g_{%i}(-4))^2 + 1.08645*(g_{%i}(-8))^2 + 1.106549*(g_{%i}(-12))^2 -1.446772*(g_{%i}(-16))^2 + .4720554*(g_{%i}(-20))^2 + .0182556
	endif

	'Gap - Pooled
	if %prob = "gap_pool" then
		series x_{%i} = -.0293769*g_{%i}(-4) + .1685053*g_{%i}(-8) + .0107244*g_{%i}(-12) -.010119*g_{%i}(-16) + .0924136*g_{%i}(-20) -.0015918*creditgdpgap + .0586611*(g_{%i}(-8))*creditgdpgap + .0192041
	endif

	'Calculate probability of a crisis
	'--------------
	if	%prob = "logit_pool" or  %prob = "logit_fe"  then		'Logit
		series q_{%i} = 1/4 * (exp(x_{%i}) / (1+exp(x_{%i}))) 	'Probability of crisis start in quarter
		smpl @all
		series p_{%i} = @cumsum(q_{%i}) - @cumsum(q_{%i}(-duration_q)) 'Probability of crisis (Note: this is the sum of all the probabilities of a crisis start during the last n quarters, the duration of a crisis)
	else		'Quadratic/linear
		series q_{%i} = 1/4 * x_{%i} 									'Probability of crisis start in quarter
		series p_{%i} = @cumsum(q_{%i}) - @cumsum(q_{%i}(-duration_q)) 'Probability of crisis (Note: this is the sum of all the probabilities of a crisis start during the last n quarters, the duration of a crisis)
	endif
next

series q_diff = (q_s - q_b) * scale_p	'Change in probability of crisis start in quarter
series p_diff = (p_s - p_b) * scale_p	'Change in probability of crisis
series q_diff_annual = q_diff + q_diff(-1) + q_diff(-2) + q_diff(-3) 'Change in probability of crisis start in year


