'Program written by Trent Saunders
'--------------------------------
'This program puts together the assumed paths for credit and the unemployment gap in the baseline and LAW scenarios
'These assumptions are discussed in Sections 3.2 and 3.3 in Saunders and Tulip (2019).
'--------------------------------

' Multipliers 
'--------------------------
'Note:The multipliers are read in from the excel file 'eviews.xlsx' from '_mainprogram.prg'
'		The code belows aligns the dates of the multipliers with the forecast start date (i.e. %forsd defined in _main_program)
for %j cred ur  i
	smpl @all
	vector(48) {%j}_diff_vec = {%j}_diff	'Place multipliers into vectors
	series {%j}_diff = 0 					'Set the multipliers equal to 0 prior to the forecast period

	'Fill in the multipliers for the forecast period
	for !i = 1 to 48
		smpl %forsd+!i-1 %forsd+!i-1
		series {%j}_diff = {%j}_diff_vec({!i})
	next
next

'Baseline scenario (suffix: _b) 
'--------------------------

'Unemployment gap
series ur_gap_b = ur_gap  'Unemployment gap is zero in baseline scenario

'Real credit
smpl %sd %sd
series cred_r_b = 1 'Create series for the baseline credit growth assumption
smpl %sd+1 %fored
series cred_r_b = cred_r_b(-1)*(1+g_baseline/100)^(1/4)	'Level -- annual real credit is 5 per cent in the absence of LAW
series g_b =  @movav(cred_r_b,4) / @movav(cred_r_b(-4),4)-1 	'4q/4q growth rate -- this is used in the calculation of the probability of a crisis

'LAW scenario (suffix: _s)
'--------------------------
smpl @all
'Unemployment gap
series ur_gap_s = ur_gap_b + ur_diff * scale_ur	  'note: scale_ur is defined in _main_program.prg. It scales the effect of interest rates on the non-crisis unemployment rate.

'Real credit
series cred_r_s = cred_r_b * (1 + cred_diff) 'Real credit (level)
series g_s =  @movav(cred_r_s,4) / @movav(cred_r_s(-4),4)-1 	'Real credit (4q/4q growth rate) -- this is used in the calculation of the probability of a crisis
series g_diff = @pcy(cred_r_s)-@pcy(cred_r_b) 'Difference between year-ended real credit growth in LAW and baseline scenarios

