'Program written by Trent Saunders
'--------------------------------
'This program puts together a bunch of graphs and tables from the paper.
'This includes Table 2 and Figures 1, 3, 5a, 7, B1, B3 
'--------------------------------

'Font size for graph titles
!font_size = 20 

'Put together a series with the x-axis labels for the responses charts
series x_axis = na
for !i = 1 to 37
	smpl %forsd+!i %forsd+!i
	series  x_axis = !i-1
next


'------------
'Table 2: Effects of policy on the severity of a crisis
'------------

delete(noerr) _table_2	'delete _table_2 if it already exists
Table(12, 3) _table_2	'create _table_2
_table_2.setjust(4,b,8,b) left	'left align
_table_2.setjust(1,a,11,a) left	'left align
_table_2.setformat(5,c,8,c) f.2 'set number format to 2 decimals
_table_2.setlines(a2:c2) +b	'bottom border
_table_2.setlines(a4:c4) +b	'bottom border
_table_2.setlines(a8:c8) +b	'bottom border

_table_2(1,2) = "Table 2: Effects of policy on the severity of a crisis*"
_table_2(2,2) = "9-years from initial increase in interest rates"

_table_2(4,2) = "Assumption"
_table_2(4,3) = "Benefit-cost ratio**"

_table_2(5,1) = "1"
_table_2(5,2) = "Baseline; unemployment gap is 5 per cent"
_table_2(5,3) = @elem(bc_ratio1, "2024Q3")

_table_2(6,1) = "2"
_table_2(6,2) = "Unemployment gap increases by 5 percentage points from the gap just before the crisis"
_table_2(6,3) = @elem(bc_ratio2, "2024Q3")

_table_2(7,1) = "3"
_table_2(7,2) = "Unemployment gap depends on recent credit growth"
_table_2(7,3) = @elem(bc_ratio3, "2024Q3")

_table_2(8,1) = "4"
_table_2(8,2) = "Unemployment gap depends on both pre-crisis unemployment gap and recent credit growth"
_table_2(8,3) = @elem(bc_ratio4, "2024Q3")

_table_2(10,1) = "*  Appendix A shows how the total loss is decomposed into separate benefits and costs for "
_table_2(11,1) = "    each of these assumptions. Appendix B provides a detailed discussion of these results"
_table_2(12,1) = "**  Cumulative sum of benefits divided by cumulative sum of costs."

'------------
'Figure 1 - Responses to interest rates
'------------

'Graphit data
smpl %forsd %fored

'Put graph data into group
group graphit_1a  x_axis i_diff
group graphit_1b  x_axis ur_diff
group graphit_1c  x_axis cred_diff*100 g_diff
group graphit_1d  x_axis q_diff*100 p_diff*100

'Eviews graphs
%n = "1a"	'Panel A
graph _gr_{%n}.xyline graphit_1a
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Interest rate"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(black)

%n = "1b"	'Panel B
graph _gr_{%n}.xyline graphit_1b
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Non-crisis unemployment gap"
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(purple)
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)

%n = "1c"	'Panel C
graph _gr_{%n}.xyline graphit_1c
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "C: Real credit"
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")    linecolor(@rgb(0,0,128))
_gr_{%n}.setelem(2)  legend("Level")  linecolor(orange)
_gr_{%n}.setelem(3)  legend("Year-ended growth")  
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.legend position(botcenter)

%n = "1d"	'Panel D
graph _gr_{%n}.xyline graphit_1d
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "D: probability of a crisis"
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(@rgb(0,128,255))
_gr_{%n}.setelem(2)  legend("Probability of a crisis start") linecolor(red)
_gr_{%n}.setelem(3)  legend("Probability of being in a crisis") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.legend position(botcenter)

%n = "1"  
graph _gr_{%n}.merge _gr_{%n}a _gr_{%n}b _gr_{%n}c _gr_{%n}d 'Merge into 4-panel graph
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Responses to interest rates"
_gr_{%n}.align(2,1,2.5)
delete _gr_{%n}a _gr_{%n}b _gr_{%n}c _gr_{%n}d	 	'Delete individual graphs

'------------
'Figure 3 - Difference between costs and benefits
'------------

'Graphit data
smpl %forsd %fored

group graphit_2 x_axis cost1 benefit1 loss1

'Eviews graphs
%n = "3"	
graph _gr_{%n}.xyline graphit_2
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "Difference between costs and benefits"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(red)
_gr_{%n}.setelem(2)  legend("Cost") linecolor(blue)
_gr_{%n}.setelem(3)  legend("Benefit") linecolor(purple)
_gr_{%n}.setelem(4)  legend("Difference") 
_gr_{%n}.legend position(botcenter)

'------------
'Figure 5 - Real credit growth and the probability of a crisis
'------------

smpl %forsd %fored

'Eviews graphs
%n = "5a"	
freeze(_gr_{%n}) graphit_5a.xyline
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Peak effect of cash rate on \r the probability of a crisis"
_gr_{%n}.addtext(l, font({!font_size}))  "Response of crisis \r probability (ppt)"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,20)
_gr_{%n}.setelem(1)  legend("Recent real credit growth (%)")  linecolor(@rgb(255,128,128))
_gr_{%n}.setelem(2)  legend("") linecolor(red)
_gr_{%n}.setelem(3)  legend("Logit") linecolor(red) linewidth(5) symbol(filledcircle) linepattern(none)
_gr_{%n}.setelem(4)  legend("Threshold (benefits = costs)") linecolor(@rgb(138,197,255))
_gr_{%n}.setelem(5)  legend("") linecolor(blue)
_gr_{%n}.setelem(6)  legend("Quadratic") linecolor(blue) linewidth(5) symbol(filledcircle) linepattern(none)
_gr_{%n}.setelem(7)  legend("Threshold (benefits = costs)") linecolor(black) linewidth(3) symbol(filledsquare) linepattern(none)
_gr_{%n}.setelem(8)  legend("Baseline assumption (5%)")
_gr_{%n}.legend position(botcenter)

'------------
'Figure 7 - Difference between costs and benefits
'------------

'Graphit data
smpl %forsd %fored

group graphit_7 x_axis cost4 benefit4 loss4

'Eviews graphs
%n = "7"	
graph _gr_{%n}.xyline graphit_7
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "Severity of crisis depends on both \r pre-crisis unemployment gap and credit growth"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(red)
_gr_{%n}.setelem(2)  legend("Cost") linecolor(blue)
_gr_{%n}.setelem(3)  legend("Benefit") linecolor(purple)
_gr_{%n}.setelem(4)  legend("Difference") 
_gr_{%n}.legend position(botcenter)


'------------
'Figure B1 - Difference between costs and benefits
'------------

'Graphit data
smpl %forsd %fored

group graphit_b1  x_axis cost2 benefit2 loss2

'Eviews graphs
%n = "B1"	
graph _gr_{%n}.xyline graphit_b1
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "Severity depends on initial unemployment gap"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(red)
_gr_{%n}.setelem(2)  legend("Cost") linecolor(blue)
_gr_{%n}.setelem(3)  legend("Benefit") linecolor(purple)
_gr_{%n}.setelem(4)  legend("Difference") 
_gr_{%n}.legend position(botcenter)

'------------
'Figure B3 - Difference between costs and benefits
'------------

'Graphit data
smpl %forsd %fored

group graphit_b3 x_axis cost3 benefit3 loss3

'Eviews graphs
%n = "B3"	
graph _gr_{%n}.xyline graphit_b3
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "Severity of crisis depends on credit growth"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(b) range(0,36)
_gr_{%n}.setelem(1)  legend("Quarters from initial increase in interest rates")  linecolor(red)
_gr_{%n}.setelem(2)  legend("Cost") linecolor(blue)
_gr_{%n}.setelem(3)  legend("Benefit") linecolor(purple)
_gr_{%n}.setelem(4)  legend("Difference") 
_gr_{%n}.legend position(botcenter)


