
%% sanity check regression
clc
clear all
close all

load shock.mat 
load response.mat    
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,6);
for i = 1:7
    z_temp = shock_Three{i}; shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); response_temp = response_temp(:,ind_originator(i));      
    stats = regstats(response_temp*100,shock_temp,'linear',{'beta','rsquare','tstat'});
    z_out((i-1)*2+1,1:4) = stats.beta';  z_out((i-1)*2+1,5) = stats.rsquare; z_out((i-1)*2+1,6) = length(response_temp); 
    z_out((i-1)*2+2,1:4) = stats.tstat.t';
end
%% global factor
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
EM_ind = xlsread('../data/EM indicator.xlsx'); EM_ind = EM_ind(b); AE_ind = 1 - EM_ind; 
addpath(genpath('./function')); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,13);
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end-1)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{2}.D;  z2_temp = MacroFin_data{2}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); commodity_temp = z2_temp(flag_temp); 
    
    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end

    
%     x_temp = []; x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54);
    
%     x_temp = []; x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54);

%     x_temp = []; x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(response_temp(:,51)*100,1,54);

    x_temp = []; x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 

%     x_temp = []; x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54);
%     x_temp(:,:,4) = repmat(shock_temp(:,1),1,54).*repmat(AE_ind',size(shock_temp,1),1); x_temp(:,:,5) = repmat(shock_temp(:,2),1,54).*repmat(AE_ind',size(shock_temp,1),1); x_temp(:,:,6) = repmat(shock_temp(:,3),1,54).*repmat(AE_ind',size(shock_temp,1),1);

    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% fianancial variable
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
z_out = NaN(14,16);
% l = 4; 
% l = 5;
% l = 6; 
l = 7; 
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:); 

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    
    if (l~=5) && (l~=6)
        ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
        ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
        [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    else
        ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];  
        ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];
        mu_temp = nanmean(nanmean(MacroFin_variables_temp))
        sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
        MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
        x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
        [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    end
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% Robustness check for government debt by removing Japan 
clc
clear all
close all
load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
z_out = NaN(14,16);
l = 5;
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:); 

    y_temp = response_temp; y_temp(:,27)= []; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(response_temp(:,51)*100,1,54); x_temp(:,:,5) = repmat(vix_temp,1,54); 
    x_temp(:,:,6) = repmat(response_temp(:,51)*100,1,54).*repmat(EM_ind',size(shock_temp,1),1); x_temp(:,:,7) = repmat(vix_temp,1,54).*repmat(EM_ind',size(shock_temp,1),1);
    x_temp(:,:,8) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,9) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,10) = x_temp(:,:,3).*MacroFin_variables_temp;
    x_temp(:,:,11) = x_temp(:,:,1).*MacroFin_variables_temp.*repmat(EM_ind',size(shock_temp,1),1);  x_temp(:,:,12) = x_temp(:,:,2).*MacroFin_variables_temp.*repmat(EM_ind',size(shock_temp,1),1); x_temp(:,:,13) = x_temp(:,:,3).*MacroFin_variables_temp.*repmat(EM_ind',size(shock_temp,1),1);
    x_temp(:,27,:) = []; 

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end

%% financial openness variable
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
z_out = NaN(14,16);
% l = 8; 
% l = 9;
% l = 10; 
% l = 11;
% l = 12;
% l = 13;
% l = 14; 
% l = 15; 
l = 16; 
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);  
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];  
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];
    
    if l ~= 8 
        mu_temp = nanmean(nanmean(MacroFin_variables_temp))
        sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
        MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
        x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    end
    
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% financial openness variable, ECB shock only, excluding Euro Area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 

load EuroArea.mat

z_out = NaN(14,16);

% l = 9;
% l = 10; 
% l = 11;
% l = 12;
% l = 13;
% l = 14; 
l = 15; 
% l = 16; 

i = 3; 
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp; 

x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);  
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];  
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];

mu_temp = nanmean(nanmean(MacroFin_variables_temp))
sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
%% macro variables
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
z_out = NaN(14,16);

l = 17; 
% l = 18;
% l = 19; 
% l = 20; 
% l = 21; 
% l = 22; 
% l = 23;
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:); 

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54);  x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    if l ~=23 
        ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
        ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
        [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    else
        ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];  
        ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = [];
        mu_temp = nanmean(nanmean(MacroFin_variables_temp))
        sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
        MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
        x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
        [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    end
        
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral trade relation - import and export
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);
% l = 31; 
l = 32;
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);  
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    mu_temp = nanmean(nanmean(MacroFin_variables_temp))
    sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
    MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral trade relation - import and export, ECB shock only, excluding Euro Area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 

load EuroArea.mat

z_out = NaN(14,16);
l = 31; 
% l = 32;
i = 3;

z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp; 
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);  
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
mu_temp = nanmean(nanmean(MacroFin_variables_temp))
sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';

%% bilateral trade relation - common language; weighted distance; time difference; member of FTA
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

l = 33; 
% k = 1; i_list = [1:2 5:7]; 
% k = 2; i_list = [1:2 4:7]; 
k = 3; i_list = [1:2 4:7]; 
% k = 4; i_list = [1:2 4:7]; 

for i = i_list
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,:,k,:)); 
    z2_temp_a = squeeze(z2_temp(ind_originator(i),:,:)); z2_temp_b = squeeze(z2_temp(:,ind_originator(i),:));
%     if sum(sum(z2_temp_a-z2_temp_b)) ~=0
%         error('Something wrong');
%     end
    z2_temp = z2_temp_a';
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral financial relation - foreign currency debt
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
z_out = NaN(14,16);

l = 25; 
for i = 3:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end    
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    mu_temp = nanmean(nanmean(MacroFin_variables_temp));
    sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)));
    MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral financial relation - foreign currency debt - ECB shock only, excluding Euro area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
load EuroArea.mat

z_out = NaN(14,16);

l = 25; 

i = 3; 
    
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp; 
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
mu_temp = nanmean(nanmean(MacroFin_variables_temp))
sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
%% bilateral financial relation - portfolio, debt, FDI, Loan
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

% l = 26;
% l = 27; 
% l = 28;
l = 29; 
for i = 1:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
%     z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,ind_originator(i),:,1)); 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    mu_temp = nanmean(nanmean(MacroFin_variables_temp))
    sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
    MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral financial relation - portfolio, debt, FDI, Loan - ECB shocks only, excluding Euro area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
load EuroArea.mat
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

% l = 26;
% l = 27; 
l = 28;
% l = 29; 

i = 3; 
    
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,ind_originator(i),:,1)); 
% z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp;
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
mu_temp = nanmean(nanmean(MacroFin_variables_temp))
sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)))
MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
%% bilateral financial relation - fx volatility
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

l = 30; 
for i = 1:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
%     z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); %10y
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end-1)); response_temp = response_temp(:,b); %2y
    
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,:,i)); 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end    
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral financial relation - fx volatility - ECB shock only, excluding Euro area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
load EuroArea.mat
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

l = 30; 
i = 3; 
    
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
% z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end));
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end-1)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,:,i)); 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp; 
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
%% inflation and growth correlation
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);
% l = 34; 
l = 35;
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);  
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% inflation and growth correlation, ECB shock only, excluding Euro Area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 

load EuroArea.mat

z_out = NaN(14,16);
% l = 34; 
l = 35;
i = 3;

z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp; 
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);  
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
%% foreign currency debt, portfolio equity from originator and porftolio debt from orignator
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

for i = 3:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    l = 25;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  
    
    l = 27; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_2 = z2_temp(flag_temp,:);  
    
    l = 28; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_3 = z2_temp(flag_temp,:);  
    
    l = 30;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,:,i)); 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_4 = z2_temp(flag_temp,:);  

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
    x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;

    ind = find(sum(isnan(MacroFin_variables_temp_1))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_2))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_3))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_4))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end

    mu_temp_1 = nanmean(nanmean(MacroFin_variables_temp_1));
    sigma_temp_1 = sqrt(nanmean(nanmean((MacroFin_variables_temp_1-mu_temp_1).^2)));
    MacroFin_variables_temp_1 = (MacroFin_variables_temp_1 - mu_temp_1)/sigma_temp_1; 
    mu_temp_2 = nanmean(nanmean(MacroFin_variables_temp_2));
    sigma_temp_2 = sqrt(nanmean(nanmean((MacroFin_variables_temp_2-mu_temp_2).^2)));
    MacroFin_variables_temp_2 = (MacroFin_variables_temp_2 - mu_temp_2)/sigma_temp_2; 
    mu_temp_3 = nanmean(nanmean(MacroFin_variables_temp_3));
    sigma_temp_3 = sqrt(nanmean(nanmean((MacroFin_variables_temp_3-mu_temp_3).^2)));
    MacroFin_variables_temp_3 = (MacroFin_variables_temp_3 - mu_temp_3)/sigma_temp_3; 
    
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
    x_temp(:,:,[8 9:11 12:13 15 17]) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% foreign currency debt, portfolio equity from originator and porftolio debt from orignator, ECB shock only, excluding Euro Area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 

load EuroArea.mat

z_out = NaN(14,16);

i = 3; 
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

l = 25;
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  

l = 27; 
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_2 = z2_temp(flag_temp,:);  

l = 28; 
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_3 = z2_temp(flag_temp,:);  

l = 30;
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,:,i)); 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_4 = z2_temp(flag_temp,:);  

y_temp = response_temp;
if i == 7
    [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
    response_temp(:,51) = r; 
end
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;

ind = find(sum(isnan(MacroFin_variables_temp_1))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end
ind = find(sum(isnan(MacroFin_variables_temp_2))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end
ind = find(sum(isnan(MacroFin_variables_temp_3))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end
ind = find(sum(isnan(MacroFin_variables_temp_4))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end

mu_temp_1 = nanmean(nanmean(MacroFin_variables_temp_1));
sigma_temp_1 = sqrt(nanmean(nanmean((MacroFin_variables_temp_1-mu_temp_1).^2)));
MacroFin_variables_temp_1 = (MacroFin_variables_temp_1 - mu_temp_1)/sigma_temp_1; 
mu_temp_2 = nanmean(nanmean(MacroFin_variables_temp_2));
sigma_temp_2 = sqrt(nanmean(nanmean((MacroFin_variables_temp_2-mu_temp_2).^2)));
MacroFin_variables_temp_2 = (MacroFin_variables_temp_2 - mu_temp_2)/sigma_temp_2; 
mu_temp_3 = nanmean(nanmean(MacroFin_variables_temp_3));
sigma_temp_3 = sqrt(nanmean(nanmean((MacroFin_variables_temp_3-mu_temp_3).^2)));
MacroFin_variables_temp_3 = (MacroFin_variables_temp_3 - mu_temp_3)/sigma_temp_3; 

x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
x_temp(:,:,[8 9:11 12:13 15 17]) = []; 
[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';

%% selection foreign currency debt, portfolio equity from originator, porftolio debt from orignator, portfolio equity to originator 
clc
clear all
close all

addpath(genpath('./function'));

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

for i = 3:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    l = 25;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  
    
    l = 27; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_2 = z2_temp(flag_temp,:);  
    
    l = 28; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_3 = z2_temp(flag_temp,:);  
    
    l = 28; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,1)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_4 = z2_temp(flag_temp,:);  

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
    x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;

    ind = find(sum(isnan(MacroFin_variables_temp_1))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_2))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_3))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_4))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end

    mu_temp_1 = nanmean(nanmean(MacroFin_variables_temp_1));
    sigma_temp_1 = sqrt(nanmean(nanmean((MacroFin_variables_temp_1-mu_temp_1).^2)));
    MacroFin_variables_temp_1 = (MacroFin_variables_temp_1 - mu_temp_1)/sigma_temp_1; 
    mu_temp_2 = nanmean(nanmean(MacroFin_variables_temp_2));
    sigma_temp_2 = sqrt(nanmean(nanmean((MacroFin_variables_temp_2-mu_temp_2).^2)));
    MacroFin_variables_temp_2 = (MacroFin_variables_temp_2 - mu_temp_2)/sigma_temp_2; 
    mu_temp_3 = nanmean(nanmean(MacroFin_variables_temp_3));
    sigma_temp_3 = sqrt(nanmean(nanmean((MacroFin_variables_temp_3-mu_temp_3).^2)));
    MacroFin_variables_temp_3 = (MacroFin_variables_temp_3 - mu_temp_3)/sigma_temp_3; 
    mu_temp_4 = nanmean(nanmean(MacroFin_variables_temp_4));
    sigma_temp_4 = sqrt(nanmean(nanmean((MacroFin_variables_temp_4-mu_temp_4).^2)));
    MacroFin_variables_temp_4 = (MacroFin_variables_temp_4 - mu_temp_4)/sigma_temp_4; 

    
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
    x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;
    
    ind_reg = [3;4]; 
    ind_reg = setdiff([1;2;3;4],ind_reg); ind_reg = [3+3*ind_reg(1):3+3*ind_reg(1)+2 3+3*ind_reg(2):3+3*ind_reg(2)+2]; 
    
    x_temp(:,:,ind_reg) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% selection foreign currency debt, portfolio equity from originator, porftolio debt from orignator, portfolio equity to originator - ECB only
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 

load EuroArea.mat

z_out = NaN(14,16);

i = 3; 
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

l = 25;
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  

l = 27; 
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_2 = z2_temp(flag_temp,:);  

l = 28; 
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,2)); 
z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_3 = z2_temp(flag_temp,:);  

l = 28; 
z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,1)); 
z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp_4 = z2_temp(flag_temp,:);  

y_temp = response_temp;
if i == 7
    [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
    response_temp(:,51) = r; 
end
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;

ind = find(sum(isnan(MacroFin_variables_temp_1))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end
ind = find(sum(isnan(MacroFin_variables_temp_2))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end
ind = find(sum(isnan(MacroFin_variables_temp_3))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end
ind = find(sum(isnan(MacroFin_variables_temp_4))==size(y_temp,1));
if ~isempty(ind)
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
end

mu_temp_1 = nanmean(nanmean(MacroFin_variables_temp_1));
sigma_temp_1 = sqrt(nanmean(nanmean((MacroFin_variables_temp_1-mu_temp_1).^2)));
MacroFin_variables_temp_1 = (MacroFin_variables_temp_1 - mu_temp_1)/sigma_temp_1; 
mu_temp_2 = nanmean(nanmean(MacroFin_variables_temp_2));
sigma_temp_2 = sqrt(nanmean(nanmean((MacroFin_variables_temp_2-mu_temp_2).^2)));
MacroFin_variables_temp_2 = (MacroFin_variables_temp_2 - mu_temp_2)/sigma_temp_2; 
mu_temp_3 = nanmean(nanmean(MacroFin_variables_temp_3));
sigma_temp_3 = sqrt(nanmean(nanmean((MacroFin_variables_temp_3-mu_temp_3).^2)));
MacroFin_variables_temp_3 = (MacroFin_variables_temp_3 - mu_temp_3)/sigma_temp_3;
mu_temp_4 = nanmean(nanmean(MacroFin_variables_temp_4));
sigma_temp_4 = sqrt(nanmean(nanmean((MacroFin_variables_temp_4-mu_temp_4).^2)));
MacroFin_variables_temp_4 = (MacroFin_variables_temp_4 - mu_temp_4)/sigma_temp_4; 


x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;

ind_reg = [3;4]; 
ind_reg = setdiff([1;2;3;4],ind_reg); ind_reg = [3+3*ind_reg(1):3+3*ind_reg(1)+2 3+3*ind_reg(2):3+3*ind_reg(2)+2]; 
x_temp(:,:,ind_reg) = []; 
[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';

%% selection portfolio asset, FDI asset, portfolio liabilities, FDI liabilities
clc
clear all
close all

addpath(genpath('./function'));

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

for i = 1:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    l = 9;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  
    
    l = 10;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_2 = z2_temp(flag_temp,:);  
    
    l = 11;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_3 = z2_temp(flag_temp,:);  
    
    l = 12;
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_4 = z2_temp(flag_temp,:);  

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
    x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;

    ind = find(sum(isnan(MacroFin_variables_temp_1))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_2))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_3))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_4))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; MacroFin_variables_temp_3(:,ind) = []; MacroFin_variables_temp_4(:,ind) = [];
    end

    mu_temp_1 = nanmean(nanmean(MacroFin_variables_temp_1));
    sigma_temp_1 = sqrt(nanmean(nanmean((MacroFin_variables_temp_1-mu_temp_1).^2)));
    MacroFin_variables_temp_1 = (MacroFin_variables_temp_1 - mu_temp_1)/sigma_temp_1; 
    mu_temp_2 = nanmean(nanmean(MacroFin_variables_temp_2));
    sigma_temp_2 = sqrt(nanmean(nanmean((MacroFin_variables_temp_2-mu_temp_2).^2)));
    MacroFin_variables_temp_2 = (MacroFin_variables_temp_2 - mu_temp_2)/sigma_temp_2; 
    mu_temp_3 = nanmean(nanmean(MacroFin_variables_temp_3));
    sigma_temp_3 = sqrt(nanmean(nanmean((MacroFin_variables_temp_3-mu_temp_3).^2)));
    MacroFin_variables_temp_3 = (MacroFin_variables_temp_3 - mu_temp_3)/sigma_temp_3; 
    mu_temp_4 = nanmean(nanmean(MacroFin_variables_temp_4));
    sigma_temp_4 = sqrt(nanmean(nanmean((MacroFin_variables_temp_4-mu_temp_4).^2)));
    MacroFin_variables_temp_4 = (MacroFin_variables_temp_4 - mu_temp_4)/sigma_temp_4; 

    
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    x_temp(:,:,12) = x_temp(:,:,1).*MacroFin_variables_temp_3;  x_temp(:,:,13) = x_temp(:,:,2).*MacroFin_variables_temp_3; x_temp(:,:,14) = x_temp(:,:,3).*MacroFin_variables_temp_3;
    x_temp(:,:,15) = x_temp(:,:,1).*MacroFin_variables_temp_4;  x_temp(:,:,16) = x_temp(:,:,2).*MacroFin_variables_temp_4; x_temp(:,:,17) = x_temp(:,:,3).*MacroFin_variables_temp_4;
    
    ind_reg = [3;4]; 
    ind_reg = setdiff([1;2;3;4],ind_reg); ind_reg = [3+3*ind_reg(1):3+3*ind_reg(1)+2 3+3*ind_reg(2):3+3*ind_reg(2)+2]; 
    
    x_temp(:,:,ind_reg) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end

%% selection foreign currency debt, portfolio assets, portfolio liabilities, FDI assets, FDI liabilities
clc
clear all
close all

addpath(genpath('./function'));

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

for i = 1:7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
%     l = 25;
%     z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
%     flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
%     MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  
    
    l = 28; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(ind_originator(i),:,:,1)); 
    z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_1 = z2_temp(flag_temp,:);  

    
%     l = 9; 
%     l = 10; 
%     l = 11; 
    l = 12; 
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp_2 = z2_temp(flag_temp,:);  
    
    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;

    ind = find(sum(isnan(MacroFin_variables_temp_1))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = [];
    end
    ind = find(sum(isnan(MacroFin_variables_temp_2))==size(y_temp,1));
    if ~isempty(ind)
        y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp_1(:,ind) = []; MacroFin_variables_temp_2(:,ind) = []; 
    end

    mu_temp_1 = nanmean(nanmean(MacroFin_variables_temp_1));
    sigma_temp_1 = sqrt(nanmean(nanmean((MacroFin_variables_temp_1-mu_temp_1).^2)));
    MacroFin_variables_temp_1 = (MacroFin_variables_temp_1 - mu_temp_1)/sigma_temp_1; 
    mu_temp_2 = nanmean(nanmean(MacroFin_variables_temp_2));
    sigma_temp_2 = sqrt(nanmean(nanmean((MacroFin_variables_temp_2-mu_temp_2).^2)));
    MacroFin_variables_temp_2 = (MacroFin_variables_temp_2 - mu_temp_2)/sigma_temp_2; 

    
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp_1;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp_1; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp_1;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp_2;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp_2; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp_2;
    
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% FX classification
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
ind_originator = [4;7;13;27;8;19;51]; 
z_out = NaN(14,16);

l = 36; 
for i = 1:7
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:); 

    y_temp = response_temp;
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54);  x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; 
    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se;         
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% Robutss - bilateral financial relation - foreign currency debt, asymmetry
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
z_out = NaN(14,16);

l = 25; 
for i = 7
    
    z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
    z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); response_temp = response_temp(:,b); 
    
    z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
    [~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);
    
    z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
    flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
    MacroFin_variables_temp = z2_temp(flag_temp,:);  

    y_temp = response_temp; 
    if i == 7
        [~,~,r,~] = regress(response_temp(:,51),[ones(size(response_temp(:,51))) shock_temp]);
        response_temp(:,51) = r; 
    end    
    x_temp = []; 
    x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

    ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
    y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
    mu_temp = nanmean(nanmean(MacroFin_variables_temp));
    sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2)));
    MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
    MacroFin_variables_temp_flag = (MacroFin_variables_temp<repmat(median(MacroFin_variables_temp,2),1,size(MacroFin_variables_temp,2))); 
    x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
    x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp.* MacroFin_variables_temp_flag;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp.* MacroFin_variables_temp_flag; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp.* MacroFin_variables_temp_flag;

    [beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 
    
    z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
    z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
end
%% bilateral financial relation - foreign currency debt - ECB shock only, excluding Euro area countries
clc
clear all
close all

load shock.mat 
load response.mat  
load MacroFin.mat
b = xlsread('../data/CountryOrder_alpha.xlsx'); 
load EuroArea.mat

z_out = NaN(14,16);

l = 25; 

i = 3; 
    
z_temp = shock_Three{i}; shocktime_temp = z_temp(:,1); shock_temp = z_temp(:,3:end); 
z_temp = response_Three{i}; response_temp = squeeze(z_temp(:,:,end)); 
response_temp(:,EuroArea) = NaN; response_temp = response_temp(:,b); 

z1_temp = MacroFin_data{1}.D;  z2_temp = MacroFin_data{1}.data_out; 
[~,Locb] = ismember(shocktime_temp,z1_temp); vix_temp = z2_temp(Locb);

z1_temp = MacroFin_data{l}.D;  z2_temp = MacroFin_data{l}.data_out; z2_temp = squeeze(z2_temp(:,i,:)); z2_temp = z2_temp'; 
flag_temp = sum((repmat(z1_temp,1,length(shocktime_temp))<repmat(shocktime_temp',length(z1_temp),1))); 
MacroFin_variables_temp = z2_temp(flag_temp,:);  

y_temp = response_temp; 
x_temp = []; 
x_temp(:,:,1) = repmat(shock_temp(:,1),1,54); x_temp(:,:,2) = repmat(shock_temp(:,2),1,54); x_temp(:,:,3) = repmat(shock_temp(:,3),1,54); x_temp(:,:,4) = repmat(vix_temp,1,54); x_temp(:,:,5) = repmat(response_temp(:,51)*100,1,54);
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;

ind = find(sum(isnan(MacroFin_variables_temp))==size(y_temp,1));
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
ind = find(sum(isnan(y_temp))==size(y_temp,1)); 
y_temp(:,ind) = []; x_temp(:,ind,:) = []; MacroFin_variables_temp(:,ind) = []; 
mu_temp = nanmean(nanmean(MacroFin_variables_temp)); 
sigma_temp = sqrt(nanmean(nanmean((MacroFin_variables_temp-mu_temp).^2))); 
MacroFin_variables_temp = (MacroFin_variables_temp - mu_temp)/sigma_temp; 
MacroFin_variables_temp_flag = (MacroFin_variables_temp<repmat(median(MacroFin_variables_temp,2),1,size(MacroFin_variables_temp,2))); 
x_temp(:,:,6) = x_temp(:,:,1).*MacroFin_variables_temp;  x_temp(:,:,7) = x_temp(:,:,2).*MacroFin_variables_temp; x_temp(:,:,8) = x_temp(:,:,3).*MacroFin_variables_temp;
x_temp(:,:,9) = x_temp(:,:,1).*MacroFin_variables_temp.* MacroFin_variables_temp_flag;  x_temp(:,:,10) = x_temp(:,:,2).*MacroFin_variables_temp.* MacroFin_variables_temp_flag; x_temp(:,:,11) = x_temp(:,:,3).*MacroFin_variables_temp.* MacroFin_variables_temp_flag;

[beta,se,Rsquare,Nobs] = PCSE(y_temp*100,x_temp); tstat = beta./se; 

z_out((i-1)*2+1,1:size(x_temp,3)+1) = beta';  z_out((i-1)*2+1,size(x_temp,3)+2) = Rsquare; z_out((i-1)*2+1,size(x_temp,3)+3) = Nobs; 
z_out((i-1)*2+2,1:1:size(x_temp,3)+1) = tstat';
