% Last modified by Dora Xia March 08, 2017

clc
close all
clear all

load data_M.mat
load shock.mat
load TimeZoneList.mat
load response.mat

addpath(genpath('./function')); 
time_1 = 20110000; 
%% regression for high frequency monetary policy shocks
beta_Three = NaN(3,length(CountryName_shock),length(CountryName)); se_Three = beta_Three; RFN_Three = NaN(3,length(CountryName_shock),length(CountryName)); 
for i = 1:length(CountryName_shock)
    
    X_Three = shock_Three{i}; Y_Three = response_Three{i}; 
    ind_Three = find(X_Three(:,1)>time_1,1,'first'); X_Three = X_Three(ind_Three:end,:); Y_Three = Y_Three(ind_Three:end,:,:);

    for j = 1:length(CountryName)
        
       X_Three_temp = X_Three(:,3:end); Y_Three_temp = Y_Three(:,j,4);
       X_Three_temp(find(isnan(Y_Three_temp)),:) = []; Y_Three_temp(find(isnan(Y_Three_temp))) = [];

       if length(Y_Three_temp) > 10
         stats = regstats2(Y_Three_temp*100,X_Three_temp,'linear',{'beta','hac','rsquare','fstat'});
         beta_Three(:,i,j) = stats.beta(2:end); se_Three(:,i,j) = stats.hac.se(2:end); 
         RFN_Three(1,i,j) = stats.rsquare; RFN_Three(2,i,j) = stats.fstat.pval; RFN_Three(3,i,j) = length(Y_Three_temp);
       end
       
    end
    
end
%%
z = xlsread('../data/Region.xlsx','Sheet1'); 
[RegionCode,b] = sort(z(2:end,1));
CountryName_Reorder = CountryName(b); 
beta_Three_Reorder = beta_Three(:,:,b); se_Three_Reorder = se_Three(:,:,b); RFN_Three_Reorder = RFN_Three(:,:,b); 
tsta_Three_Reorder = beta_Three_Reorder./se_Three_Reorder;  
beta_Three_sig_Reorder = beta_Three_Reorder; sig_Three_Reorder = (abs(tsta_Three_Reorder)>1.65); beta_Three_sig_Reorder(find(sig_Three_Reorder==0)) = NaN; 

save Regression_country_10y.mat CountryName_Reorder RegionCode beta_Three_Reorder beta_Three_sig_Reorder tsta_Three_Reorder RFN_Three_Reorder
%%
clc
clear all
close all

load Regression_country_10y.mat
beta_median = NaN(3,7); beta_10pct = NaN(3,7); beta_90pct = NaN(3,7);
XString = {'RBA','BoC','ECB','BoJ','SNB','BoE','Fed'}; 
TitleString = {'Target','Path','Premium'}; 

for i = 1:3
    for j = 1:7
        z_temp = squeeze(beta_Three_Reorder(i,j,:)); 
        z_temp(find(isnan(z_temp))) = [];
        beta_median(i,j) = median(z_temp); beta_10pct(i,j) = prctile(z_temp,10); beta_90pct(i,j) = prctile(z_temp,90);
    end
end
figure
for i = 1:3
    subplot(2,2,i)
    errorbar(1:7, beta_median(i,:),beta_median(i,:)-beta_10pct(i,:), beta_90pct(i,:)-beta_median(i,:),'bo:','LineWidth',2); hold on
    plot(0:0.1:8, zeros(81,1),'k--'); 
    title(TitleString{i}); 
    set(gca,'XTick',1:7,'XTickLabel', XString, 'fontsize',15); 
    ylim([-5 5]);
end
%%
clc
clear all
close all

load Regression_country_10y.mat
beta_median = NaN(3,2); beta_25pct = NaN(3,2); beta_75pct = NaN(3,2);
TitleString = {'Target','Path','Premium'}; 

JJ = [7;3]; 
for i = 1:3
    for j = 1:2
        z_temp = squeeze(beta_Three_Reorder(i,JJ(j),:)); 
        z_temp(find(isnan(z_temp))) = [];
        beta_median(i,j) = median(z_temp); beta_25pct(i,j) = prctile(z_temp,25); beta_75pct(i,j) = prctile(z_temp,75);
    end
end
TitleString = {'Fed','ECB'}; 
figure
for j = 1:2
    subplot(1,2,j)
    bar(beta_median(:,j));
    hold on
    errorbar(1:3, beta_median(:,j), beta_median(:,j)- beta_25pct(:,j), beta_75pct(:,j)-beta_median(:,j),'.','LineWidth',3);
    title(TitleString{j}); 
    set(gca,'XTick',1:3,'XTickLabel', {'Target','Path','Premia'}, 'fontsize',15); 
end


%%
clc
clear all
close all

load Regression_country_10y.mat
LegendString = {'Path','Premium'}; 
figure
for i = 1:2
    beta_temp = squeeze(beta_Three_sig_Reorder(i+1,7,2:end)); CountryName_Reorder_temp = CountryName_Reorder(2:end); 
    [~,b] = sort(beta_temp); 
    beta_temp = beta_temp(b); CountryName_Reorder_temp = CountryName_Reorder_temp(b);
    ind = find(isnan(beta_temp),1,'first'); 
    beta_temp = beta_temp(1:ind-1); CountryName_Reorder_temp = CountryName_Reorder_temp(1:ind-1);
    subplot(2,1,i)
    bar(beta_temp)
    hold on
    plot(0:0.1:31,ones(1,311),'k:','LineWidth',3); 
    if i==1
        ylim([0 4]);
    end
    xlim([1 length(beta_temp)]+1)
    set(gca,'XTickLabel',CountryName_Reorder_temp,'XTick',1:1:length(beta_temp),'FontSize',15); 
end

%% Counting nodes
clear all
close all
load Regression_country_10y.mat
load shock.mat

z = squeeze(RFN_Three_Reorder(2,:,:)); z = z'; 
% remove self-spillover
z(16,1) = 1000; z(18,2) = 1000; z(14,4) = 1000; z(17,5) = 1000; z(15,6) = 1000; z(14,7) = 1000; 
% remove non-observation
ind = find(sum(isnan(z),2)==7); z(ind,:) = []; RegionCode(ind) = []; CountryName_Reorder(ind) = []; 
% remove XM as a area
z(1,:) = []; RegionCode(1) = []; CountryName_Reorder(1) = []; 
% % normalization factor
% NormFactor = sum(~isnan(z)); 


count_giver = sum(z<0.1); count_giver_ByRegion = NaN(6,7); 
count_receiver = sum(z<0.1,2);
count_receiver_region_median = NaN(6,1); count_receiver_region_max = NaN(6,1); count_receiver_region_min = NaN(6,1);
for i = 1:6
    ind = find(RegionCode==i); count_temp = count_receiver(ind); 
    count_giver_ByRegion(i,:) = sum(z(ind,:)<0.1); 
    count_receiver_region_median(i) = median(count_temp); count_receiver_region_max(i) = max(count_temp); count_receiver_region_min(i) = min(count_temp); 
end
% count_giver_ByRegion_norm = count_giver_ByRegion./repmat(NormFactor,6,1); 

ShockString = {'RBA','BoC','ECB','BoJ','SNB','BoE','Fed'}; 
RegionString = {'AE-Euro area','AE-other','EME-Asia','EME-Europe','EME-Latam','EME-other'}; 
% [a,b] = sort(count_giver./NormFactor,'descend'); 
[a,b] = sort(count_giver,'descend'); 

figure
% bar(count_giver_ByRegion_norm(:,b)','stacked')
bar(count_giver_ByRegion(:,b)','stacked')
set(gca,'XTickLabel',ShockString(b),'XTick',1:1:length(CountryName_shock));
ylim([0 35])
legend(RegionString); 
set(gca,'FontSize',20); 

[a,b] = sort(count_receiver_region_median,'descend'); 
figure
bar(count_receiver_region_median(b),'FaceColor',[0.5 0.5 1]); 
hold on
errorbar(1:6, count_receiver_region_median(b),count_receiver_region_median(b)-count_receiver_region_min(b), count_receiver_region_max(b)-count_receiver_region_median(b),'bo','MarkerSize',5,'LineWidth',3); hold on
set(gca,'XTickLabel',RegionString(b),'XTick',1:1:6); 
set(gca,'FontSize',15); 

figure
[a,b] = sort(count_receiver,'descend');
bar(a,'FaceColor',[0.5 0.5 1])
set(gca,'XTickLabel',CountryName_Reorder(b),'XTick',1:1:length(CountryName_Reorder),'FontSize',10); 




        
        

