% Last modified by Dora Xia March 08, 2017

clc
close all
clear all

load data_M.mat
load shock.mat
load TimeZoneList.mat

response_TargetPath = cell(1,length(CountryName_shock)); response_ExpectationPremium = cell(1,length(CountryName_shock)); response_Three = cell(1,length(CountryName_shock));

for i = 1:length(CountryName_shock)
    
    Z_TP = shock_TargetPath{i}; Z_ET = shock_ExpectationPremium{i}; Z_Three = shock_Three{i};  
    D_TP = Z_TP(:,1); H_TP = Z_TP(:,2); X_TP = Z_TP(:,3:4); D_TP_1 = floor(D_TP/10000); D_TP_2 = floor((D_TP-D_TP_1*10000)/100); D_TP_3 = D_TP - D_TP_1*10000 - D_TP_2*100; 
    D_ET = Z_ET(:,1); H_ET = Z_ET(:,2); X_ET = Z_ET(:,3:4); D_ET_1 = floor(D_ET/10000); D_ET_2 = floor((D_ET-D_ET_1*10000)/100); D_ET_3 = D_ET - D_ET_1*10000 - D_ET_2*100; 
    D_Three = Z_Three(:,1); H_Three = Z_Three(:,2); X_Three = Z_Three(:,3:5); D_Three_1 = floor(D_Three/10000); D_Three_2 = floor((D_Three-D_Three_1*10000)/100); D_Three_3 = D_Three - D_Three_1*10000 - D_Three_2*100; 
    [Lia_TP, Locb_TP] = ismember(D_TP,T); [Lia_ET, Locb_ET] = ismember(D_ET,T); [Lia_Three, Locb_Three] = ismember(D_Three,T); 
    
    response_TP_temp = NaN(length(D_TP),length(CountryName),4);
    response_ET_temp = NaN(length(D_ET),length(CountryName),4);
    response_Three_temp = NaN(length(D_Three),length(CountryName),4);

    for j = 1:length(CountryName)
        
         flag_TP_temp_1 = NaN(length(D_TP),1); flag_ET_temp_1 = NaN(length(D_ET),1); flag_Three_temp_1 = NaN(length(D_Three),1); 
      
         % determine whether the event occurred before the trading close hour
         d1 = tzoffset(datetime(D_TP_1,D_TP_2,D_TP_3,'TimeZone',TimeZoneList{j}));
         d2 = tzoffset(datetime(D_TP_1,D_TP_2,D_TP_3,'TimeZone','Europe/Zurich'));
         flag_TP_temp_1 = ((hour(d1-d2)+H_TP) < ClosingHour_local(j)); 
         
         d1 = tzoffset(datetime(D_ET_1,D_ET_2,D_ET_3,'TimeZone',TimeZoneList{j}));
         d2 = tzoffset(datetime(D_ET_1,D_ET_2,D_ET_3,'TimeZone','Europe/Zurich'));
         flag_ET_temp_1 = ((hour(d1-d2)+H_ET) < ClosingHour_local(j)); 
         
         d1 = tzoffset(datetime(D_Three_1,D_Three_2,D_Three_3,'TimeZone',TimeZoneList{j}));
         d2 = tzoffset(datetime(D_Three_1,D_Three_2,D_Three_3,'TimeZone','Europe/Zurich'));
         flag_Three_temp_1 = ((hour(d1-d2)+H_Three) < ClosingHour_local(j)); 
          
        for k = 1:4
            
            X_TP_temp = X_TP; X_ET_temp = X_ET; X_Three_temp = X_Three; 
            
            Y_TP_temp_before = data_M(Locb_TP-flag_TP_temp_1,k+1,j); 
            ind = find(isnan(Y_TP_temp_before)); Y_TP_temp_before(ind) = data_M(Locb_TP(ind)-flag_TP_temp_1(ind)-1,k+1,j);
            ind = find(isnan(Y_TP_temp_before)); Y_TP_temp_before(ind) = data_M(Locb_TP(ind)-flag_TP_temp_1(ind)-2,k+1,j);
            ind = find(isnan(Y_TP_temp_before)); Y_TP_temp_before(ind) = data_M(Locb_TP(ind)-flag_TP_temp_1(ind)-3,k+1,j);
            Y_TP_temp_after = data_M(Locb_TP-flag_TP_temp_1+1,k+1,j);
            ind = find(isnan(Y_TP_temp_after)); Y_TP_temp_after(ind) = data_M(Locb_TP(ind)-flag_TP_temp_1(ind)+2,k+1,j);
            ind = find(isnan(Y_TP_temp_after)); Y_TP_temp_after(ind) = data_M(Locb_TP(ind)-flag_TP_temp_1(ind)+3,k+1,j);
            ind = find(isnan(Y_TP_temp_after)); Y_TP_temp_after(ind) = data_M(Locb_TP(ind)-flag_TP_temp_1(ind)+4,k+1,j);
            Y_TP_temp = Y_TP_temp_after - Y_TP_temp_before;
            response_TP_temp(:,j,k) = Y_TP_temp; 
            
            
            Y_ET_temp_before = data_M(Locb_ET-flag_ET_temp_1,k+1,j); 
            ind = find(isnan(Y_ET_temp_before)); Y_ET_temp_before(ind) = data_M(Locb_ET(ind)-flag_ET_temp_1(ind)-1,k+1,j);
            ind = find(isnan(Y_ET_temp_before)); Y_ET_temp_before(ind) = data_M(Locb_ET(ind)-flag_ET_temp_1(ind)-2,k+1,j);
            ind = find(isnan(Y_ET_temp_before)); Y_ET_temp_before(ind) = data_M(Locb_ET(ind)-flag_ET_temp_1(ind)-3,k+1,j);
            Y_ET_temp_after = data_M(Locb_ET-flag_ET_temp_1+1,k+1,j);
            ind = find(isnan(Y_ET_temp_after)); Y_ET_temp_after(ind) = data_M(Locb_ET(ind)-flag_ET_temp_1(ind)+2,k+1,j);
            ind = find(isnan(Y_ET_temp_after)); Y_ET_temp_after(ind) = data_M(Locb_ET(ind)-flag_ET_temp_1(ind)+3,k+1,j);
            ind = find(isnan(Y_ET_temp_after)); Y_ET_temp_after(ind) = data_M(Locb_ET(ind)-flag_ET_temp_1(ind)+4,k+1,j);
            Y_ET_temp = Y_ET_temp_after - Y_ET_temp_before; 
            response_ET_temp(:,j,k) = Y_ET_temp; 
 
            
            Y_Three_temp_before = data_M(Locb_Three-flag_Three_temp_1,k+1,j); 
            ind = find(isnan(Y_Three_temp_before)); Y_Three_temp_before(ind) = data_M(Locb_Three(ind)-flag_Three_temp_1(ind)-1,k+1,j);
            ind = find(isnan(Y_Three_temp_before)); Y_Three_temp_before(ind) = data_M(Locb_Three(ind)-flag_Three_temp_1(ind)-2,k+1,j);
            ind = find(isnan(Y_Three_temp_before)); Y_Three_temp_before(ind) = data_M(Locb_Three(ind)-flag_Three_temp_1(ind)-3,k+1,j);
            Y_Three_temp_after = data_M(Locb_Three-flag_Three_temp_1+1,k+1,j);
            ind = find(isnan(Y_Three_temp_after)); Y_Three_temp_after(ind) = data_M(Locb_Three(ind)-flag_Three_temp_1(ind)+2,k+1,j);
            ind = find(isnan(Y_Three_temp_after)); Y_Three_temp_after(ind) = data_M(Locb_Three(ind)-flag_Three_temp_1(ind)+3,k+1,j);
            ind = find(isnan(Y_Three_temp_after)); Y_Three_temp_after(ind) = data_M(Locb_Three(ind)-flag_Three_temp_1(ind)+4,k+1,j);
            Y_Three_temp = Y_Three_temp_after - Y_Three_temp_before;
            response_Three_temp(:,j,k) = Y_Three_temp; 
                       
        end
        
    end
    
    response_TargetPath{i} = response_TP_temp; response_ExpectationPremium{i} = response_ET_temp; response_Three{i} = response_Three_temp;
    
end

save response.mat response_TargetPath response_ExpectationPremium response_Three
%% Two events
clc
clear all
close all

load shock.mat
load response.mat
load data_M.mat

shock_temp = shock_Three{7}; response_temp = response_Three{7}; response_temp(:,2,:) = NaN; 
event = [20090318; 20110809; 20130619]; LegendString = {'2009/03/18','2011/08/09','2013/06/19'}; 
figure
for t = 1:2
    ind = find(shock_temp(:,1)==event(t));
    subplot(3,1,t)
    [a,b] = sort(response_temp(ind,:,4)); 
    ind = find(isnan(a),1,'first'); 
    bar(a(1:ind-1)*100);
    xlim([1 length(b(1:ind-1))]); 
    set(gca,'XTickLabel',CountryName(b(1:ind-1)),'XTick',1:1:length(b(1:ind-1)),'FontSize',10);  
    legend(LegendString(t),'Location','SouthEast','FontSize',15); 
end
t = 3;
ind = find(shock_temp(:,1)==event(t));
subplot(3,1,t)
[a,b] = sort(response_temp(ind,:,4),'descend'); 
ind = find(isnan(a),1,'last'); 
bar(a(ind+1:end)*100);
xlim([1 length(b(ind+1:end))]); 
set(gca,'XTickLabel',CountryName(b(ind+1:end)),'XTick',1:1:length(b(ind+1:end)),'FontSize',10);  
legend(LegendString(t),'Location','SouthEast','FontSize',15); 

shock_temp = shock_Three{3}; response_temp = response_Three{3}; response_temp(:,2,:) = NaN; 
event = [20120705; 20150122; 20150603]; LegendString = {'2012/07/05','2015/01/22','2015/06/03'}; 
figure
for t = 1:2
    ind = find(shock_temp(:,1)==event(t));
    subplot(3,1,t)
    [a,b] = sort(response_temp(ind,:,4)); 
    ind = find(isnan(a),1,'first'); 
    bar(a(1:ind-1)*100);
    xlim([1 length(b(1:ind-1))]); 
    set(gca,'XTickLabel',CountryName(b(1:ind-1)),'XTick',1:1:length(b(1:ind-1)),'FontSize',10);  
    legend(LegendString(t),'Location','SouthEast','FontSize',15); 
end
t = 3;
ind = find(shock_temp(:,1)==event(t));
subplot(3,1,t)
[a,b] = sort(response_temp(ind,:,4),'descend'); 
ind = find(isnan(a),1,'last'); 
bar(a(ind+1:end)*100);
xlim([1 length(b(ind+1:end))]); 
set(gca,'XTickLabel',CountryName(b(ind+1:end)),'XTick',1:1:length(b(ind+1:end)),'FontSize',10);  
legend(LegendString(t),'Location','SouthEast','FontSize',15); 


