% generate the closing time vector [closing time form BBG tick data closing time from timezone adjustment]

clc
close all
clear all

FileName = '../data/closing time.xlsx'; 
[~,CountryName] = xlsfinfo(FileName); CountryName(end) = []; CountryName = CountryName'; 
ClosingTime = NaN(length(CountryName),1); 

for i = 1:length(CountryName)
    z_temp = xlsread(FileName,CountryName{i});
    ClosingTime(i) = z_temp(1,1);  
end
ClosingTime(end-2:end) = [];

%%

TimeZoneList = {'America/New_York'; 'Europe/Zurich'; 'Asia/Tokyo'; 'Europe/London'; 'Australia/Sydney'; 'Europe/Zurich'; 'America/New_York'; 'Europe/Stockholm';'Europe/Zurich'};
TimeZoneList = [TimeZoneList; 'Pacific/Auckland'; 'Europe/Dublin'; 'Europe/Moscow'; 'Europe/Warsaw'; 'Asia/Kuala_Lumpur'; 'Asia/Hong_Kong'; 'Asia/Shanghai'; 'Europe/Brussels'; 'America/Sao_Paulo'];  
TimeZoneList = [TimeZoneList; 'Asia/Kolkata'; 'Europe/Copenhagen'; 'America/Bogota'; 'Asia/Jakarta'; 'Europe/Istanbul'; 'Asia/Seoul'; 'Europe/Prague'; 'America/Lima'; 'Asia/Bangkok'];
TimeZoneList = [TimeZoneList; 'Asia/Jerusalem'; 'Asia/Kuala_Lumpur'; 'Asia/Singapore'; 'Europe/Zurich'; 'Europe/Zurich'; 'Europe/Zurich'; 'Europe/Zurich';'Europe/Zurich'; 'Europe/Zurich'; 'Europe/Zurich'];
TimeZoneList = [TimeZoneList; 'Europe/Zurich'; 'Europe/Zurich'; 'Africa/Johannesburg'; 'America/Mexico_City'; 'Asia/Taipei'; 'Africa/Algiers'; 'America/Santiago'; 'Asia/Karachi'; 'America/Caracas']; 
TimeZoneList = [TimeZoneList; 'Europe/Bucharest'; 'Asia/Bangkok'; 'Asia/Kuwait'; 'Asia/Riyadh'; 'America/Argentina/Buenos_Aires'; 'Asia/Muscat'; 'Africa/Cairo'; 'Asia/Dhaka'; 'Asia/Kuwait'; 'Asia/Dhaka'];

offset = NaN(length(TimeZoneList),1); 

for i = 1:length(TimeZoneList)
 d1 = tzoffset(datetime(2017,3,1,'TimeZone',TimeZoneList{i}));
 d2 = tzoffset(datetime(2017,3,1,'TimeZone','Europe/Zurich'));
 offset(i) = hour(d2-d1); 
end
ClosingTime = [ClosingTime 17+offset]; 

%%
z_temp = xlsread('../data/closing time list.xlsx'); 
ClosingHour_local = z_temp(:,end); 
save TimeZoneList.mat TimeZoneList ClosingHour_local

%%
ClosingHour_CEST = ClosingHour_local; 
for i = 1:length(TimeZoneList)
 d1 = tzoffset(datetime(2017,3,1,'TimeZone',TimeZoneList{i}));
 d2 = tzoffset(datetime(2017,3,1,'TimeZone','Europe/Zurich'));
 offset(i) = hour(d2-d1); 
 ClosingHour_CEST(i) = ClosingHour_CEST(i) + offset(i); 
end







