/*******************************************************************************

	13_unionmem.do
	
	This file contains code that uses ABS data to generate data used for
	Figure 1 in Bishop J and I Chan (2019), Is Declining Union Membership
	Contributing to Low Wages Growth?, RBA Research Discussion Paper No 2019-02.
	Output will be saved to fig1.xlsx.

*******************************************************************************/

clear all
set more off

local dir  "<path for 'data' folder here>"

cd "`dir'"

* Import data
import excel using abs_unionmem.xlsx, clear firstrow
tsset year

* Generate union membership shares
gen double union_sh = emp_u / emp_tot * 100 // Including OMIEs
gen double union_exomie_sh = emp_exomie_u / emp_exomie_tot * 100 // Excl OMIEs

* Manual input for 1986 and 1988 from ABS, Trade Union Members, Australia, Cat.
* No. 6325.0 (August 1996), 'Summary of Findings'
replace union_sh = 46 if year == 1986
replace union_sh = 42 if year == 1988

* Linear interpolation for odd years with missing share data
replace union_sh = (union_sh[_n-1] + union_sh[_n+1])/2 if ///
	missing(union_sh) & inlist(year, 1987, 1989, 1991, 2015)
replace union_exomie_sh = (union_exomie_sh[_n-1] + union_exomie_sh[_n+1])/2 if ///
	missing(union_exomie_sh) & inlist(year, 2015, 2017)

* Calculate break-adjusted series (excl OMIEs)
gen double union_sh_ch = union_sh - L1.union_sh // First differencing incl OMIE series
gen double union_sh_adj = union_exomie_sh

replace union_sh_adj = union_sh_adj[_n+1] - union_sh_ch[_n+1] if year == 2003

forval i = 2003(-1)1986 {
	replace union_sh_adj = union_sh_adj[_n+1] - union_sh_ch[_n+1] if year==`i'
}

* Labelling
label variable year "Year"
label variable union_sh_adj "Union membership rate (ex OMIE), break-adjsted"

* Export to Excel
export excel year union_sh_adj using fig1.xlsx, ///
	sheet("fig1") sheetreplace firstrow(varlabels)
	
* end of do file
