/*******************************************************************************

	11_regressions_DD.do
	
	This file contains code that estimates the difference-in-differences and
	instrumental variable models in Section 4.7 of Bishop J and I Chan (2019),
	Is Declining Union Membership Contributing to Low Wages Growth?, RBA
	Research Discussion Paper No 2019-02.
	
	The reghdfe package needs to be installed for this code to run.
		
*******************************************************************************/

clear all
set more off   

local dir  "<path for 'data' folder here>"

cd "`dir'"

use wad_extract_final_RDP, clear

/* In some cases, FWA EBAs were certified after 27 March 2006 deadline 
   Similarly, some WC EBAs were certified after the 1 July 2009 deadline. For 
   graphing, assume these were certified on 27 March 2006 and 30 June 2009, respectively */

gen     cert_date_adj = cert_date
replace cert_date_adj = td(27March2006) if cert_date >= td(27March2006) & Law==3
replace cert_date_adj = td(30Jun2009)   if cert_date >= td(30Jun2009)   & Law==2

format  cert_date_adj %td

gen    cert_adj_qy=yq(year(cert_date_adj),quarter(cert_date_adj))
format cert_adj_qy %tq

/* Focus on approx. three-year symmetric window around introduction (and repeal) of Work Choices 

   Exact length of window is the duration of Work Choices (3.26 years) */

local l_wc = (td(30Jun2009) - td(27March2006)) / 365

gen w1 = cert_date_adj>=(td(27March2006)-365*`l_wc') & cert_date_adj<=(td(27March2006)+365*`l_wc')
gen w2 = cert_date_adj>=(td(30Jun2009)  -365*`l_wc') & cert_date_adj<=(td(30Jun2009)  +365*`l_wc')

keep if w1==1 | w2==1

keep if short_duration!=1 & public==0 & aawi_a_effect!=.

* Figure 13

tabstat union  if cert_adj_qy>=tq(2003q1) & cert_adj_qy<=tq(2012q4) & gf==0, by(cert_adj_qy)
tabstat union  if cert_adj_qy>=tq(2003q1) & cert_adj_qy<=tq(2012q4) & gf==1, by(cert_adj_qy)

* Figure 15

tabstat  aawi_a_effect if gf==0, by(Law)
tabstat  aawi_a_effect if gf==1, by(Law)

 * WC dummy (=0 if WRA, =1 if WC)

gen     WC = 1 if Law==2 
replace WC = 0 if Law==3

gen WC_gf = WC*gf 

* FWA dummy (=0 if WorkChoices, =1 if FWA)

gen     FWA = 1 if Law==1 
replace FWA = 0 if Law==2

gen FWA_gf = FWA*gf 

/*********************************************************************************************
* DD results (Table 6)
 *******************************************************************************************/

 *** Effect of policy change on AAWI
 
* Experiment 1

qui reghdfe aawi_a_effect gf WC  WC_gf   if w1==1, absorb(i.ind_state) vce(cluster anzsic06_2dig) 
estimates store  wc, title(wc) 

* Experiment 2

qui reghdfe aawi_a_effect gf FWA  FWA_gf  if w2==1, absorb(i.ind_state) vce(cluster anzsic06_2dig) 
estimates store  fwa, title(fwa) 


 *** Effect of policy change on union involvement (Denominators for Wald Estimator)

* Experiment 1
 
qui reghdfe union gf WC  WC_gf   if w1==1, absorb(i.ind_state) vce(cluster anzsic06_2dig) 
estimates store  wcwo, title(wcwo) 

* Experiment 2

qui reghdfe union gf FWA  FWA_gf  if w2==1, absorb(i.ind_state) vce(cluster anzsic06_2dig) 
estimates store  fwawo, title(fwawo) 

 *** Effect of union involvement on AAWI

set matsize 10000

* Experiment 1

quietly ivregress 2sls aawi_a_effect WC  gf i.ind_state (union=WC_gf)  if w1==1, cluster(anzsic06_2dig)
estimates store  wciv, title(wciv) 

* Experiment 2

quietly ivregress 2sls aawi_a_effect FWA gf i.ind_state (union=FWA_gf) if w2==1, cluster(anzsic06_2dig)
estimates store  fwaiv, title(fwaiv) 



/* Alternatively: Implement Wald estimator 

sureg (eq1: aawi_a_effect gf WC  WC_gf  if w1==1) (eq2:union gf WC  WC_gf   if w1==1)

* SEs using Delta method

nlcom ratio:[eq1]_b[WC_gf]/[eq2]_b[WC_gf]

ivregress 2sls aawi_a_effect WC  gf (union=WC_gf)  if w1==1
*/

***** Table 6 

estout  wc wcwo wciv fwa fwawo fwaiv, cells(b(star fmt(2)) se(par fmt(2))) legend label varlabels(_cons constant) stats(r2 r2_a r2_within r2_a_within N , fmt(2 2 2 2 0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(union WC_gf FWA_gf)


*************** Test if changes between experiments 1 and 2 are stat. sig.

* 1- re-estimate models excluding clustering and using reg command (clustering will be done by suest)

 *** Effect of policy change on AAWI

quietly reg aawi_a_effect gf WC  WC_gf i.ind_state if w1==1
estimates store  wc, title(wc) 
quietly reg aawi_a_effect gf FWA  FWA_gf i.ind_state if w2==1
estimates store  fwa, title(fwa) 

 *** Effect of policy change on union involvement

quietly reg union gf WC  WC_gf  i.ind_state if w1==1   
estimates store  wcwo, title(wcwo) 
quietly reg union gf FWA  FWA_gf i.ind_state if w2==1
estimates store  fwawo, title(fwawo) 

suest wc wcwo fwa fwawo, cluster(anzsic06_2dig)

* 2- test for difference in DD estimates (both the reduced form and first stage)

test [wc_mean]_b[WC_gf] = [fwa_mean]_b[FWA_gf]*-1

test [wcwo_mean]_b[WC_gf] = [fwawo_mean]_b[FWA_gf]*-1

stop

* Test for difference between two Wald ratios

nlcom (ratio1: [wc_mean]_b[WC_gf]/[wcwo_mean]_b[WC_gf]) (ratio2: [fwa_mean]_b[FWA_gf]/[fwawo_mean]_b[FWA_gf]), post

test _b[ratio1] = _b[ratio2]

* end of do file
