/*******************************************************************************

	10_regressions_FE.do
	
	This file contains code that estimates the baseline models, robustness
	checks and generates the figures in Section 4, as well as the results and
	figures in the spillover model in Section 5, in Bishop J and I Chan (2019),
	Is Declining Union Membership Contributing to Low Wages Growth?, RBA
	Research Discussion Paper No 2019-02.
	
	The reghdfe package needs to be installed for this code to run.
		
*******************************************************************************/
	
clear all
set more off   

local dir  "<path for 'data' folder here>"

cd "`dir'"

use wad_extract_final_RDP, clear

/*********************************************************************************************
* Baseline estimates (Table 1)
 *******************************************************************************************/

 *** Private
 
* 1.	Limited controls i.e. OLS + industry/state dummies
qui reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pri==1, absorb(i.ind_state) vce(cluster id anzsic06_2dig) 
estimates store  pr_ols, title(pr_ols) 

* 2.	Controlling for time-varying shocks i.e. OLS + industry/state dummies + time dummies + interactions
qui reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pri==1, absorb(i.surveyq#i.ind_state) vce(cluster id anzsic06_2dig) 
estimates store  pr_t, title(pr_t) 

* 3.	Controlling for time-varying shocks and firm effects i.e. OLS + industry/state dummies + time dummies + interactions + FE
qui reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pri==1, absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 
estimates store  pr_fe, title(pr_fe) 
 
 *** Public

 * 1.	Limited controls i.e. OLS + industry/state dummies
qui reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pub==1, absorb(i.state_code) vce(cluster id anzsic06_2dig) 
estimates store  pu_ols, title(pu_ols) 

* 2.	Controlling for time-varying shocks i.e. OLS + industry/state dummies + time dummies + interactions
qui reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pub==1, absorb(i.surveyq#i.state_code) vce(cluster id anzsic06_2dig) 
estimates store  pu_t, title(pu_t) 

* 3.	Controlling for time-varying shocks and firm effects i.e. OLS + industry/state dummies + time dummies + interactions + FE
qui reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pub==1, absorb(i.surveyq#i.state_code i.id) vce(cluster id anzsic06_2dig) 
estimates store  pu_fe, title(pu_fe) 

 *** Table

estout  pr_ols pr_t pr_fe pu_ols pu_t pu_fe, cells(b(star fmt(2)) se(par fmt(2))) legend label varlabels(_cons constant) stats(r2 r2_a r2_within r2_a_within N , fmt(2 2 2 2 0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(union)


/*********************************************************************************************
* Union wage growth premium over time (Figures 10, 11)
  *******************************************************************************************/    
  
* Private 

reghdfe aawi_a_effect i.union##i.ir_regime_cat ln_emp multi_firm  if in_panel_pri==1, absorb(i.surveyq##i.ind_state i.id) vce(cluster id anzsic06_2dig) 


* IRA
test (_b[1.union] + _b[1.union#2.ir_regime_cat]=0) 
* WRA
test (_b[1.union] + _b[1.union#4.ir_regime_cat]=0) 
* WC
test (_b[1.union] + _b[1.union#3.ir_regime_cat]=0) 
* FWA
test (_b[1.union]=0)


* Test WC=FWA
test (_b[1.union] + _b[1.union#3.ir_regime_cat]=0) 



* Matched sample, no FE

reghdfe aawi_a_effect i.union##i.ir_regime_cat ln_emp multi_firm  if in_panel_pri==1, absorb(i.surveyq##i.ind_state) vce(cluster id anzsic06_2dig) 

* IRA
test (_b[1.union] + _b[1.union#2.ir_regime_cat]=0) 
* WRA
test (_b[1.union] + _b[1.union#4.ir_regime_cat]=0) 
* WC
test (_b[1.union] + _b[1.union#3.ir_regime_cat]=0) 
* FWA
test (_b[1.union]=0)



* Unmatched sample, no FE

reghdfe aawi_a_effect i.union##i.ir_regime_cat ln_emp multi_firm  if in_panel_pri==0 & public==0, absorb(i.surveyq##i.ind_state) vce(cluster id anzsic06_2dig) 

* IRA
test (_b[1.union] + _b[1.union#2.ir_regime_cat]=0) 
* WRA
test (_b[1.union] + _b[1.union#4.ir_regime_cat]=0) 
* WC
test (_b[1.union] + _b[1.union#3.ir_regime_cat]=0) 
* FWA
test (_b[1.union]=0)


 /*********************************************************************************************
* Spillover effects model (Table 7, Figure 16)
 *******************************************************************************************/

replace union_eba_ind_rate = union_eba_ind_rate 

gen union_eba_interact = union * union_eba_ind_rate

* Controls

reghdfe aawi_a_effect union union_eba_ind_rate union_eba_interact ln_emp multi_firm if in_panel_pri==1, absorb(i.surveyq##i.state_code i.id) vce(cluster id anzsic06_2dig) 


* What is the support?

sum union_eba_ind_rate if union==1 & in_panel_pri==1, detail


***** Changes in threat effects over time

reghdfe aawi_a_effect i.ir_regime_cat##(i.union c.union_eba_ind_rate c.union_eba_interact) ln_emp multi_firm if in_panel_pri==1, absorb(i.surveyq##i.state_code i.id) vce(cluster id anzsic06_2dig) 

* Union dummy main effect

* IRA
test (_b[1.union] + _b[1.union#2.ir_regime_cat]=0) 
* WRA
test (_b[1.union] + _b[1.union#4.ir_regime_cat]=0) 
* WC
test (_b[1.union] + _b[1.union#3.ir_regime_cat]=0) 
* FWA
test (_b[1.union]=0)

* Union presence main effect

* IRA
test (_b[union_eba_ind_rate] + _b[2.ir_regime_cat#c.union_eba_ind_rate]=0)
* WRA
test (_b[union_eba_ind_rate] + _b[4.ir_regime_cat#c.union_eba_ind_rate]=0)
* WC
test (_b[union_eba_ind_rate] + _b[3.ir_regime_cat#c.union_eba_ind_rate]=0)
* FWA
test (_b[union_eba_ind_rate]=0)

* WC = FWA
test (_b[union_eba_ind_rate] - _b[3.ir_regime_cat#c.union_eba_ind_rate]=0)


* Interaction

* IRA
test (_b[union_eba_interact] + _b[2.ir_regime_cat#c.union_eba_interact]=0)
* WRA
test (_b[union_eba_interact] + _b[4.ir_regime_cat#c.union_eba_interact]=0)
* WC
test (_b[union_eba_interact] + _b[3.ir_regime_cat#c.union_eba_interact]=0)
* FWA
test (_b[union_eba_interact]=0)


* WC = FWA
test (_b[union_eba_interact] - _b[3.ir_regime_cat#c.union_eba_interact]=0)

 /*********************************************************************************************
* Dynamics of the union premium (Table 3)
 *******************************************************************************************/

sort id fam_count

gen     N_U  = 1 if union==1 & L1.union==0
gen     U_N  = 1 if union==0 & L1.union==1

forvalues i = 1(1)10 {
local j = `i'+1
replace N_U  = `j'  if union==1 & L1.N_U==`i'
replace U_N  = `j'  if union==0 & L1.U_N==`i'
}
*
replace N_U = 0 if N_U==.
replace U_N = 0 if U_N==.
replace U_N = U_N * -1 

gen     Cunion = N_U 
replace Cunion = U_N if N_U==0

reghdfe aawi_a_effect union Cunion ln_emp multi_firm  if in_panel_pri==1, absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 

estimates store  count, title(count) 

estout count, cells(b(star fmt(3)) se(par fmt(3))) legend label varlabels(_cons constant) stats(r2 r2_a r2_within r2_a_within N , fmt(2 2 2 2 0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(union Cunion)

 /*********************************************************************************************
* Markov transition probabilities (Table 4)
 *******************************************************************************************/
 
tabstat n_n n_u if (n_n==1 | n_u==1) [weight=employees_combined]
tabstat u_n u_u if (u_n==1 | u_u==1) [weight=employees_combined]

* Check of LR equilibrium union share broadly similar to LR union share in the data

tabstat union if (n_n==1 | n_u==1 | u_n==1 | u_u==1) [weight=employees_combined]

/*********************************************************************************************
* Robustness checks (Table 2)
 *******************************************************************************************/

* 1- Weighting by employee numbers
    
reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pri==1 [weight=employees_combined], absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 


	
* 2- Accouting for renegotiation delays
 
reghdfe aawi_a_reneg union ln_emp multi_firm  if in_panel_pri==1                  , absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 

estimates store  reneg_r, title(reneg_r) 

gen reneg_sample = e(sample)

reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pri==1 & reneg_sample==1, absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 

estimates store  reneg_b, title(reneg_b) 


**** Figure 9: Average Renegotiation Delay

replace reneg_lagtc18=0 if aawi_a_reneg==aawi_a_effect
replace reneg_lagtc18=. if reneg_lagtc18>=1.5

sum reneg_lagtc18, detail
sum reneg_lagtc18 if reneg_lagtc18!=0, detail

gen start_date_y = year(start_date)

tabstat reneg_lagtc18 if union==0 & public==0 [weight=employees_combined], by(start_date_y) statistics(mean, N)
tabstat reneg_lagtc18 if union==1 & public==0 [weight=employees_combined], by(start_date_y) statistics(mean, N)

* NB: multiply by 52.2 to convert to weeks



* 3- Controlling for firm-specific shocks

reghdfe aawi_a_effect union ln_emp multi_firm roa lsales if in_panel_pri==1                 , absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 

estimates store  firm_r, title(firm_r) 

gen firm_sample = e(sample)

reghdfe aawi_a_effect union ln_emp multi_firm            if in_panel_pri==1 & firm_sample==1, absorb(i.surveyq#i.ind_state i.id) vce(cluster id anzsic06_2dig) 

estimates store  firm_b, title(firm_b) 


* 4- Controlling for inertia in wage setting

tab surveyq, gen(surveyq_)

xtabond  aawi_a_effect union ln_emp multi_firm surveyq_* if in_panel_pri==1, robust

estimates store  ab_r, title(ab_fe) 

drop surveyq_*

gen ab_sample = e(sample)

reghdfe aawi_a_effect union ln_emp multi_firm  if in_panel_pri==1 & ab_sample==1, absorb(i.surveyq i.id) vce(cluster id anzsic06_2dig) 

estimates store  ab_b, title(ab_base) 



* 5- Including unmatched agreements in the sample (rely on industry and state effects instead of FE)

reghdfe aawi_a_effect union##in_panel_pri ln_emp multi_firm  if public==0 & short_duration!=1, absorb(i.surveyq#i.ind_state) vce(cluster id anzsic06_2dig) 

estimates store  unmatched, title(unmatched) 



/* 6- Heckman model;, no FE
 
  Excluded instrument is the share of employees on EBAs in the same industry with quantifiable AAWI
  
  The selectivity effect summarized by 'lambda' 
  
  rho is the correlation between the errors in the regression relationship and selection equation
  
  The lLR test reported at the bottom of the output is an equivalent test for rho=0. If significant, this justifies a Heckman selection.
     
  Matched sample only */ 

heckman  aawi_a_effect union ln_emp multi_firm i.surveyq i.anzsic_1dig i.state_code if  in_panel_priheck==1, select(quant = union ln_emp multi_firm i.surveyq i.anzsic_1dig i.state_code quant_eba_ind_rate) vce(cluster id)

estimates store  heck_r, title(heck_r) 

gen heck_sample = e(sample)

reghdfe aawi_a_effect union ln_emp multi_firm if in_panel_priheck==1 & heck_sample==1, absorb(i.surveyq i.state_code i.anzsic_1dig) vce(cluster id) 

estimates store  heck_b, title(heck_b) 


* end of do file
