
logmode +addin
'logmode debug


'  addin model prodecure
'
'  model_name.mcontrol_qp(options) control_vars target_vars trajectory_vars [weights discount constraints]
'

' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (1) Examine the object

  'check that an object exists
  %type =@getthistype
  if %type="NONE" then
    @uiprompt("Error:  No object found, please open a MODEL object.")
    stop
    endif

  'check that _this is a model object
  if %type<>"MODEL" then
    @uiprompt("Error:  Procedure can only be run from a MODEL object.")
    stop
    endif


' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (2) Examine the arguments

  if @len(%args) = 0 then
    @uiprompt("Error:  Procedure requires at least three arguments.")
    stop
    endif

  !nargs = @wcount(%args)
  if !nargs < 3 then
    @uiprompt("Error:  Procedure requires at least three arguments.")
    stop
    endif

  for !i = 1 to 3
    !j = !i - 1
    if @isobject(%{!j}) = 0 then
      %errstring = "Error:  mcontrol argument " + @str({!i}) + " is not the name of an existing object"
      @uiprompt(%errstring)
      stop
      else
      if {%{!j}}.@type <> "GROUP" then
        %errstring = "Error:  mcontrol argument " + @str({!i}) + " must be a group object"
        @uiprompt(%errstring)
        stop
        endif
      endif
    next

  %opt_instruments = %0
  %opt_targets = %1
  %opt_desireds = %2
  !ninstruments = {%opt_instruments}.@count
  !ntargets = {%opt_targets}.@count
  !ndesireds = {%opt_desireds}.@count  

  if !ntargets <> !ndesireds then
    @uiprompt("Error:  There must as many trajectory variables as target variables.")
    stop
    endif

  if !ntargets < !ninstruments then
    @uiprompt("Error:  There must be at least as many target variables as control variables.")
    stop
    endif

  if !nargs >= 4 then
    %type3 = {%3}.@detailedtype
    if %type3 = "GROUP" or %type3 = "SYM" then
      %opt_weights = %3
      %argweights = "yes"
      else
      if %type3 = "TEXT" then
        %constraints = %3
        %argconstraints = "yes"
        else
        @uiprompt("Error:  Argument 4 must be either a group, sym, or text object")
        stop
        endif
      endif
    endif

  if !nargs >= 5 then
    %type4 = {%4}.@detailedtype
    if %3 = %constraints then
      if %type4 = "GROUP" or %type4 = "SYM" then
        %opt_weights = %4
        %argweights = "yes"
        else
        @uiprompt("Error:  Argument 5 is of the wrong type")
        stop
        endif
      endif
    if %3 = %opt_weights then
      if %type4 = "TEXT" then
        %constraints = %4
        %argconstraints = "yes"
        else
        if %type4 = "SCALAR" then
          !w_discount = {%5}
          %argdisc = "yes"
          else
          @uiprompt("Error:  Argument 5 is of the wrong type")
          stop
          endif
        endif
      endif
    endif

  if !nargs >= 6 and %type4 <> "SCALAR" then
    %type5 = {%5}.@detailedtype
    if %type5 = "SCALAR" then
      !w_discount = {%5}
      %argdisc = "yes"
      endif
    endif

  if %argweights = "yes" then
    %w_type = {%opt_weights}.@detailedtype
    if %w_type = "SYM" then
      if %argdisc <> "yes" then
        !w_discount = 1
        endif
      endif
    else
    %w_type = "IDENTITY"
    endif


  'check that control variables are exogenous variables or add factors
  'and that target variables are endogenous variables
  %exog_vnames = _this.@exoglist
  %adds_vnames = _this.@addfactors
  %exog_vnames = %exog_vnames + " " + %adds_vnames
  %endog_vnames = _this.@endoglist
  for !i = 1 to {%opt_instruments}.@count
    %vvv = {%opt_instruments}.@seriesname(!i)
    !cc = @wfindnc(%exog_vnames,%vvv)
    if !cc = 0 then
      %errstring = "control variable " + %vvv + " is not an exogenous variable or add factor"
      @uiprompt(%errstring)
      stop
      endif
    next
  for !i = 1 to {%opt_targets}.@count
    %vvv = {%opt_targets}.@seriesname(!i)
    !cc = @wfindnc(%endog_vnames,%vvv)
    if !cc = 0 then
      %errstring = "target variable " +  %vvv + " is not an endogenous variable"
      @uiprompt(%errstring)
      stop
      endif
    next

' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (3) Examine the options

  'default option values
  !conv = .000001
  !bigmax = 15
  !ptrb = .01
  !show = 2
  %debug = "no"

  if @len(@option(1)) > 0 then
    %temp = @equaloption("c")
    if @len(%temp)>0 then
      !conv = @val(%temp)
       endif
    %temp = @equaloption("m")
    if @len(%temp)>0 then
      !bigmax = @val(%temp)
      endif
    %temp = @equaloption("p")
    if @len(%temp)>0 then
      !ptrb = @val(%temp)
      endif
    %temp = @equaloption("o")
    if @len(%temp)>0 then
      !show = @val(%temp)
      endif
    if @hasoption("debug") then
      %debug = "yes"
       endif
    endif        



' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (3) Setup (part 1)

  'make sure that solution options are tight enough that derivatives 
  'computed using small perturbations are accurate
  _this.solveopt(g=12,z=1e-12)

  %mcontrol_work = " "
  %sample = @pagesmpl
  %control_start = @wleft(%sample,1)
  %control_end = @wright(%sample,1)
  !nqtrs = @obssmpl

  if %w_type = "IDENTITY" then
    %opt_weights = @getnextname("work_")
    %mcontrol_work = %mcontrol_work + "opt_weights "
    matrix {%opt_weights} = @identity(!ntargets*!nqtrs)
    endif


' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (4) Examine the inequality constraints and transfer the informaion
' into a table

  if %argconstraints = "yes" then
    %sss = @getnextname("work_")
    svector {%sss} = {%constraints}.@svectornb
    !nconstraints = @rows({%sss})
    %mcontrol_work = %mcontrol_work + "sss "
    %ctable = @getnextname("work_")
    table(1,1) {%ctable}
    %mcontrol_work = %mcontrol_work + "ctable "
    %cvarnames = @getnextname("work_")
    string {%cvarnames} = " "
    %mcontrol_work = %mcontrol_work + "cvarnames "
    call parse_constraints({%sss},{%ctable},{%cvarnames})
    %extra_targets = @wnotin(@upper({%cvarnames}),{%opt_targets}.@members)
    %extra_targets = @wunique(%extra_targets)
    if @isempty(%extra_targets) = 0 then
      call add_targets
      endif
    endif


' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (4) Setup (part 2)

  !ttargets = !ntargets * !nqtrs
  !tinstruments = !ninstruments * !nqtrs
  %targetnames = {%opt_targets}.@members
  %instrunames = {%opt_instruments}.@members
  %desirednames = {%opt_desireds}.@members


  '**************************************************************************
  ' convert inequality constraints to the matrix form
  '
  '  lbmat*y >= lbvec
  '
  ' where y is the vector of target variables.

  if %argconstraints = "yes" then
    %lbmat = @getnextname("work_")
    matrix(!nqtrs * !nconstraints,!nqtrs*!ntargets) {%lbmat} = 0
    %mcontrol_work = %mcontrol_work + "lbmat "
    %lbvec = @getnextname("work_")
    matrix(!nqtrs * !nconstraints,1) {%lbvec} = 0
    %mcontrol_work = %mcontrol_work + "lbvec "
    for !i = 1 to !nconstraints
      !nterms = @val({%ctable}(!i,1))
      for !k = 1 to !nterms
        %var = @upper({%ctable}(!i,2*!k))
        !coef =  @val({%ctable}(!i,2*!k+1))
        !j = @wfindnc(%targetnames,%var)
        for !l = 1 to !nqtrs
          {%lbmat}((!i-1)*!nqtrs+!l,(!j-1)*!nqtrs+!l) = !coef
          next
        next
      for !l = 1 to !nqtrs
        !coef =  @val({%ctable}(!i,2*!nterms+2))
        {%lbvec}((!i-1)*!nqtrs+!l) = !coef
        next
      next
    else
    !nconstraints = 1
    %lbmat = @getnextname("work_")
    matrix(!nqtrs,!nqtrs*!ntargets) {%lbmat} = 0
    %mcontrol_work = %mcontrol_work + "lbmat "
    %lbvec = @getnextname("work_")
    matrix(!nqtrs,1) {%lbvec} = 0
    %mcontrol_work = %mcontrol_work + "lbvec "
    endif


  '**************************************************************************
  ' weight matrix 

  %weight_mat = @getnextname("work_")
  matrix(!ntargets*!nqtrs,!ntargets*!nqtrs) {%weight_mat} = 0
  %mcontrol_work = %mcontrol_work + "weight_mat "

  %stom_mat = @getnextname("work_")
  matrix(!nqtrs,!ntargets) {%stom_mat}
  %mcontrol_work = %mcontrol_work + "stom_mat "

  if %w_type = "IDENTITY" then
    {%weight_mat} = {%opt_weights}
    endif

  if %w_type = "SYM" then
    !weight_rows = @rows({%opt_weights})
    if !weight_rows <> !ntargets and !weight_rows <> !ttargets then
      %errstring = "Error:  The size of the weight matrix is " + @str(!weight_rows)
      %errstring = %errstring + " but must be either " + @str(!ntargets) + " or " + @str(!ttargets)  
      @uiprompt(%errstring)
      stop
      endif
    if !weight_rows  = !ntargets then
      %w_discount = @getnextname("work_")
      series  {%w_discount}
      %mcontrol_work = %mcontrol_work + "w_discount "

      %tmpvec = @getnextname("work_")
      vector(!nqtrs) {%tmpvec}
      %mcontrol_work = %mcontrol_work + "tmpvec "

      %tmpmat = @getnextname("work_")
      matrix(!nqtrs,!nqtrs) {%tmpmat}
      %mcontrol_work = %mcontrol_work + "tmpmat "

      %tmpser = @getnextname("work_")
      series {%tmpser}
      %mcontrol_work = %mcontrol_work + "tmpser "

      smpl @all
      {%w_discount} = 1
      smpl %control_start + 1 %control_end
      {%w_discount} = !w_discount * {%w_discount}(-1)
      smpl %control_start %control_end
      for !j = 1 to !ntargets
        for !k =1 to !ntargets
          series {%tmpser} = {%opt_weights}(!j,!k) * {%w_discount}
          stom({%tmpser},{%tmpvec})
          matrix {%tmpmat} = @makediagonal({%tmpvec})
          matplace({%weight_mat},{%tmpmat},1+!nqtrs*(!j-1),1+!nqtrs*(!k-1))
          next
        next

      else
      {%weight_mat} = {%opt_weights}
      endif
    endif

  if %w_type = "GROUP" then
    if {%opt_weights}.@count <> !ntargets then
      @uiprompt("The number of weight series does not equal the number of target series")
      stop
      endif
    smpl {%control_start} {%control_end}
    {%weight_mat} = @makediagonal(@vec(@convert({%opt_weights})))
    endif


  '**************************************************************************
  ' create additional matrix/vector objects

  %desired_vec = @getnextname("work_")
  matrix(!ttargets,1) {%desired_vec} 
  %mcontrol_work = %mcontrol_work + "desired_vec "

  %target_dvec = @getnextname("work_")
  matrix(!ttargets,1) {%target_dvec} 
  %mcontrol_work = %mcontrol_work + "target_dvec "

  %derivs = @getnextname("work_")
  matrix {%derivs} = @filledmatrix(!ninstruments*!nqtrs,!ntargets*!nqtrs,0)
  %mcontrol_work = %mcontrol_work + "derivs "

  %gap_vec = @getnextname("work_")
  vector(!ntargets*!nqtrs) {%gap_vec} 
  %mcontrol_work = %mcontrol_work + "gap_vec "

  %perturb_mat = @getnextname("work_")
  matrix {%perturb_mat} = @filledmatrix(!nqtrs,!ninstruments,!ptrb)
  %mcontrol_work = %mcontrol_work + "perturb_mat "

  %target_vec = @getnextname("work_")
  matrix(!ntargets*!nqtrs,1) {%target_vec} 
  %mcontrol_work = %mcontrol_work + "target_vec "

  %instru_vec = @getnextname("work_")
  matrix(!ninstruments*!nqtrs,1) {%instru_vec} 
  %mcontrol_work = %mcontrol_work + "instru_vec "

  %instru_vec_prev = @getnextname("work_")
  matrix(!ninstruments*!nqtrs,1) {%instru_vec_prev} 
  %mcontrol_work = %mcontrol_work + "instru_vec_prev "

  %k_vec = @getnextname("work_")
  matrix(!ntargets*!nqtrs,1) {%k_vec} 
  %mcontrol_work = %mcontrol_work + "k_vec "

  %yhat_lin = @getnextname("work_")
  matrix(!ntargets*!nqtrs,1) {%yhat_lin} 
  %mcontrol_work = %mcontrol_work + "yhat_lin "

  %yhat_nlin = @getnextname("work_")
  matrix(!ntargets*!nqtrs,1) {%yhat_nlin} 
  %mcontrol_work = %mcontrol_work + "yhat_nlin "

  %d_mat = @getnextname("work_")
  matrix(!ninstruments*!nqtrs,!ninstruments*!nqtrs) {%d_mat} 
  %mcontrol_work = %mcontrol_work + "d_mat "

  %d_vec = @getnextname("work_")
  matrix(!ninstruments*!nqtrs,1) {%d_vec} 
  %mcontrol_work = %mcontrol_work + "d_vec "

  %a_mat = @getnextname("work_")
  matrix(!ninstruments*!nqtrs,!nconstraints*!nqtrs) {%a_mat} 
  %mcontrol_work = %mcontrol_work + "a_mat "

  %b_vec = @getnextname("work_")
  matrix(!nconstraints*!nqtrs,1) {%b_vec} 
  %mcontrol_work = %mcontrol_work + "b_vec "

  %xhat = @getnextname("work_")
  matrix(!ninstruments*!nqtrs,1) {%xhat} 
  %mcontrol_work = %mcontrol_work + "xhat "

  '**************************************************************************
  ' set up table of iteration-by-iteration statistics

  if @isobject("mcontrol_stats") then
    delete mcontrol_stats
    endif
  table(!bigmax+2,3) mcontrol_stats
  mcontrol_stats.setwidth(1:3) 12
  mcontrol_stats.setlines(a2:c2) +b
  setcell(mcontrol_stats,1,1,"iteration")
  setcell(mcontrol_stats,1,2,"f(x)")
  setcell(mcontrol_stats,1,3,"convergence")
  setcell(mcontrol_stats,2,3,"statistic")


  '**************************************************************************
  ' information text file

  if @isobject("mcontrol_text") then
    delete mcontrol_text
    endif
  text mcontrol_text
  %temp = _this.@name
  mcontrol_text.append Model name = {%temp}
  mcontrol_text.append Simulation start = {%control_start}
  mcontrol_text.append Simulation end   = {%control_end}
  mcontrol_text.append Convergence criteria = {!conv}
  mcontrol_text.append Maximum number of iterations = {!bigmax}
  mcontrol_text.append Initial instrument perturbation factor = {!ptrb}
  mcontrol_text.append Control variables  = {%instrunames}
  mcontrol_text.append Target variables  = {%targetnames}
  mcontrol_text.append Trajectory variables  = {%desirednames}
  mcontrol_text.append There are {!tinstruments} control and {!ttargets} target observations
  if %w_type = "GROUP" then
    %weightnames = {%opt_weights}.@members
    mcontrol_text.append Loss function weights are given by series = {%weightnames}
    endif
  if %w_type = "SYM" then
    mcontrol_text.append Matrix {%opt_weights} used for loss function weights
    if !weight_rows = !ntargets then
      mcontrol_text.append The weight matrix contains first period weights
      mcontrol_text.append Subsequent weights use the discount factor {!w_discount}
      else
      mcontrol_text.append The weight matrix contains weights for all periods
      endif
    endif
  if %w_type = "IDENTITY" then
    mcontrol_text.append Identity matrix used for loss function weights
    endif
  if %argconstraints = "yes" then
    mcontrol_text.append There are {!nconstraints} inequality constraints
    else
    mcontrol_text.append There are 0 inequality constraints
    endif
  if @isempty(%extra_targets) = 0 then
    mcontrol_text.append The constraint variables {%extra_targets} have been added to the set of targets
    endif

  '**************************************************************************
  ' table of matrix and vector names

  if @isobject("mcontrol_work") then
    delete mcontrol_work
    endif
  table(10,2) mcontrol_work

  for !i = 1 to @wcount(%mcontrol_work)
    %abc = @word(%mcontrol_work,!i)
    mcontrol_work(!i,1) = %abc
    %bcd = "%" + %abc
    mcontrol_work(!i,2) = {%bcd}
    next


  ' ***********************************************
  ' iteration initializations

  !bigtry = 1
  %converge = "no"

  smpl %control_start %control_end
  {%desired_vec} = @vec(@convert({%opt_desireds}))
  _this.solve

  'identify active scenario solution alias
  %endog_base = @word(_this.@endoglist,1)
  %endog_active = @word(_this.@endoglist("@active"),1)
  %sufactive = @mid(%endog_active,@len(%endog_base) + 1)
  mcontrol_text.append scenario aliasing suffix   = {%sufactive}
  %targetsols = @wcross(%targetnames,%sufactive)
  group {%opt_targets}_sols {%targetsols}

  xopen(type=r, case=lower)


  ' ***********************************************
  ' iteration loop

  while  !bigtry <= !bigmax and %converge = "no"

    call mcontrol_derivs

    {%instru_vec_prev} = {%instru_vec} 
    {%instru_vec} = @vec(@convert({%opt_instruments}))
    {%k_vec} = {%target_vec} - @transpose({%derivs})*{%instru_vec}
    {%d_mat} = 2 * {%derivs} * {%weight_mat} * @transpose({%derivs})
    {%d_vec} = -2 * {%derivs}*@transpose({%weight_mat})*({%k_vec}-{%desired_vec})
    {%a_mat} = @transpose({%lbmat}*@transpose({%derivs}))
    {%b_vec} = {%lbvec} - {%lbmat}*{%k_vec} 


    ' ************************************************************
    ' ************************************************************
    ' start of R code
    '
    '   quadprog::solve.QP(D,d,A,b)
    '
    ' solves the constrained quadratic programming problem
    '
    '   min [0.5 * x' D x - d'x] with the constraint A'x >= b
    ' 

    xput {%d_mat} {%d_vec} {%a_mat} {%b_vec}
    %cmd = "QP.results <- quadprog::solve.QP(" + @lower(%d_mat) + ","  
    %cmd = %cmd + @lower(%d_vec) + "," + @lower(%a_mat) + "," + @lower(%b_vec) + ")"
    xrun %cmd 

    xrun "r_xhat <- QP.results$solution"
    xrun "r_xhat <- as.matrix(r_xhat)"
    xget(type = matrix, name = {%xhat}) r_xhat
 
    ' end of R code
    ' ************************************************************
    ' ************************************************************

    ' values of target variables based on linearization
    {%yhat_lin} = @transpose({%derivs})*{%xhat} + {%k_vec}

    ' solve for values of target variables in original model
    smpl %control_start %control_end
    mtos({%xhat},{%opt_instruments})
    _this.solve
    {%target_vec} = @vec(@convert({%opt_targets}_sols))
    {%gap_vec} = {%target_vec} - {%desired_vec}
    !nloss = @sum(@transpose({%gap_vec})*{%weight_mat}*{%gap_vec})
    mcontrol_stats(!bigtry+2,1) = !bigtry
    mcontrol_stats(!bigtry+2,2) = !nloss

    ' convergence test is based on the maximum difference between
    ' the target variable values in the linearized and original models
    !conv_stat = @max(abs({%yhat_lin}-{%target_vec}))
    if !conv_stat < !conv then
      %converge = "yes"
      endif
    mcontrol_stats(!bigtry+2,3) = !conv_stat
    show mcontrol_stats
    !bigtry = !bigtry + 1
    wend

  xclose


' ******************************************************************
' ******************************************************************
' (6) Final tasks


  if !show = 2 then
    close mcontrol_stats
    endif

  if !show = 1 or !show = 2 then
    if @isobject("mcontrol_spool") then
      delete mcontrol_spool
      endif
    spool mcontrol_spool
    mcontrol_spool.append mcontrol_stats
    mcontrol_spool.append mcontrol_text
    mcontrol_spool.name untitled01 mcontrol_stats
    mcontrol_spool.name untitled02 mcontrol_text
    show mcontrol_spool
    endif

  if %debug = "no" then
    for !i = 1 to @wcount(%mcontrol_work)
      %abc = @word(%mcontrol_work,!i)
      %bcd = "%" + %abc
      delete(noerr) {%bcd}
      next
    else
    mcontrol_spool.append mcontrol_work
    mcontrol_spool.name untitled03 mcontrol_work
    show mcontrol_spool
    endif

  statusline mcontrol_qp is finished


'****************************************************************
'****************************************************************
'****************************************************************
subroutine mcontrol_derivs
 

'This subroutine computes the derivatives of the targets wrt the instruments


  if !bigtry > 1 then
    {%perturb_mat} = @abs(@unvec({%instru_vec}-{%instru_vec_prev},!nqtrs)) + 1e-6
    endif

  smpl %control_start %control_end
  {%target_vec} = @vec(@convert({%opt_targets}_sols))

  '************************************
  'derivatives loop  
  statusline computing instrument derivatives at iteration !bigtry
  for !i = 1 to !ninstruments
    %instru_name = {%opt_instruments}.@seriesname(!i)
    for !j = 1 to !nqtrs
      !perturbit =  {%perturb_mat}(!j,!i)
      smpl %control_start + !j-1 %control_start + !j-1
      {%instru_name} = {%instru_name} + !perturbit
      smpl %control_start %control_end
      _this.solve
      {%target_dvec} = @vec(@convert({%opt_targets}_sols))
      matplace({%derivs},@transpose(({%target_dvec}-{%target_vec})/!perturbit),(!i-1)*!nqtrs+!j,1)
      smpl %control_start + !j-1 %control_start + !j-1
      {%instru_name} = {%instru_name} - !perturbit
      next
    next

  smpl %control_start %control_end

endsub


'****************************************************************
'****************************************************************
'****************************************************************
subroutine local parse_constraints(svector sss, table ctable,string cvarnames)


'This subroutine converts the inequality constraint text into a table 

' subroutine arguments:
'
' inputs:
'
'   sss                svector of constraint text
' 
' outputs:
'
'   ctable             table of constraint variables and coefficients
'   cvarnames          string of names of variables in constraints

'***************************************


!nconstraints = @rows(sss)
scalar loc
scalar sign

for !i = 1 to !nconstraints
  %rrr = sss(!i)

  '*****************************************
  '*****************************************
  'separate the left and right sides of each constraint

  !kk1 = @instr(%rrr,">=")
  if !kk1 = 0 then
    @uiprompt("each constraint must contain an "">="" term")
    stop
    endif
  %rrrl = @left(%rrr,!kk1-1)
  if @isempty(%rrrl) = 1 then
    @uiprompt("each constraint must contain terms to the left of "">=""")
    stop 
    endif
  %rrrr = @mid(%rrr,!kk1+2)
  if @isempty(%rrrr) = 1 then
    @uiprompt("each constraint must contain a value to the right of "">=""")
    stop 
    endif

  
  '*****************************************
  '*****************************************
  'process the left side of each constraint
  ' 
  '1. split %rrrl into individual terms (based on + and - characters);
  '   the main challenge concerns the first term, which may or may not
  '   have a leading + or - attached 
  '2. then split each term into 2 parts (based on * character)
  '3. then identify which part is coefficient and which is variable

  !zz = 0    'flag to indicate end of left hand side of a constraint
  !nterms = 1
  vector(100) split_locs = 0
  vector(100) split_signs = 0
  %rrrlx = %rrrl

  ' find boundaries and signs of each term
  while !zz = 0

    'first term: determine whether its sign is explicit or implicit
    if !nterms = 1 then                
      call find_next_delimit(%rrrlx,loc,sign)
      if loc = 0 then                  'implicit leading sign
        split_locs(!nterms) = 0
        split_signs(!nterms) = 1
        else
        %rrrll = @left(%rrrlx,loc-1)
        if @isempty(%rrrll) = 1 then   'explicit leading sign
          split_locs(!nterms) = loc
          split_signs(!nterms) = sign
          %rrrlx = @mid(%rrrlx,loc+1)
          else                         'implicit leading sign
          split_locs(!nterms) = 0
          split_signs(!nterms) = 1
          endif
        endif
      endif

    call find_next_delimit(%rrrlx,loc,sign)
    if loc = 0 then                  'last term
      split_locs(!nterms+1) = @length(%rrrlx)
      !zz = 1
      else
      split_locs(!nterms+1) = loc
      split_signs(!nterms+1) = sign
      %rrrlx = @mid(%rrrlx,loc+1)
      endif

    !nterms = !nterms + 1
    wend

  for !k = 2 to !nterms 
    split_locs(!k) = split_locs(!k-1) + split_locs(!k)
    next

  !nterms = !nterms - 1

     
  ' parse each term into coefficient times variable (they must 
  ' appear in that order, although coefficients = 1 can be 
  ' omitted), and store coefficient and variable in ctable
  for !k = 1 to !nterms
    %term = @mid(%rrrl,split_locs(!k)+1,split_locs(!k+1)-split_locs(!k)-1)
    if @isempty(%term) = 1 then
      @uiprompt("term is empty:  illegal constraint specification")
      stop
      else
      !ii = @instr(%term,"*")
      if !ii > 0 then
        %coef = @left(%term,!ii-1)
        !coef = split_signs(!k) * @val(%coef)
        %var =  @mid(%term,!ii+1)
        else
        !coef = split_signs(!k)
        %var = %term
        endif
      %var = @trim(%var)
      endif
  
    ctable(!i,2*!k) = %var
    ctable(!i,2*!k+1) = !coef
    cvarnames = cvarnames + " " + %var
    next


  '*****************************************
  '*****************************************
  'process the right side of each constraint

  ctable(!i,2*!nterms+2) = @val(%rrrr)
  ctable(!i,1) = !nterms
  
  next

  cvarnames = @wunique(cvarnames)

endsub


'****************************************************************
'****************************************************************
'****************************************************************
subroutine add_targets

' This subroutine is called when one or more of the variables
' appearing in the constraints is not a target variable.  Each
' extra variable is added to the set of targets, its desired
' trajectory is set to zero (an arbitrary choice), and so is
' its weight.

  !nextra = @wcount(%extra_targets)
  for !qq = 1 to !nextra
    %newtarg = @word(%extra_targets,!qq)
    {%opt_targets}.add {%newtarg}
    !ntargets = !ntargets + 1
    %newtarg_t = %newtarg + "_t"
    smpl @all
    series {%newtarg_t} = 0
    {%opt_desireds}.add {%newtarg_t}
    if %w_type = "GROUP" then
      %newtarg_w = %newtarg + "_w"
      smpl @all
      series {%newtarg_w} = 0
      {%opt_weights}.add {%newtarg_w}
      endif
    if %w_type = "SYM" or %w_type = "IDENTITY" then
      %wtmpmat1 = @getnextname("work_")
      !weight_rows = @rows({%opt_weights})
      if !weight_rows  = (!ntargets-1) then
        matrix(!ntargets,!ntargets) {%wtmpmat1} = 0
        endif
      if !weight_rows  = (!ntargets-1)*!nqtrs then
        matrix(!ntargets*!nqtrs,!ntargets*!nqtrs) {%wtmpmat1} = 0
        endif
      if %w_type = "SYM" then
        %wtmpmat2 = @getnextname("work_")
        matrix {%wtmpmat2} = {%opt_weights}
        matplace({%wtmpmat1},{%wtmpmat2},1,1)
        else
        matplace({%wtmpmat1},{%opt_weights},1,1)
        endif
      {%opt_weights} = {%wtmpmat1}
      delete(noerr) {%wtmpmat1} {%wtmpmat2}
      endif
    next

endsub

'****************************************************************
'****************************************************************
'****************************************************************
subroutine local find_next_delimit(string %instring,scalar loc,scalar sign) 

  !ttp = @instr(%instring,"+")
  !ttm = @instr(%instring,"-")
  if !ttp= 0 or !ttm = 0 then
    loc = !ttp + !ttm
    if !ttp = 0 and !ttm = 0 then
      sign = 1
      else
      sign = (!ttp > 0) - (!ttm > 0)
      endif
    else
    loc = !ttp*(!ttp < !ttm) + !ttm*(!ttm < !ttp)
    sign = (!ttp < !ttm) - (!ttm < !ttp)
  endif

endsub
  
