' This program contains some simple examples that illustrate the use 
' of the  mcontrol and mcontrol_qp addins.  All examples use a simple,
' three-equation model of the unemployment rate, inflation,
' and the federal funds rate.  One variant of the model is
' linear; a second version introduces a (minor) nonlinearity in
' the unemployment equation.
'
' Example 1:  mcontrol, linear model, more targets than instruments
' Example 2:  mcontrol, linear model, equal number of targets and instruments
' Example 3:  mcontrol, nonlinear model, more targets than instruments
'             explicit loss weights supplied
' Example 4:  mcontrol, nonlinear model, equal number of targets and instruments
' Example 5:  mcontrol_qp, linear model, more targets than instruments
'             federal funds rate constrained to be positive (requires R)
' Example 6:  mcontrol_qp, nonlinear model, more targets than instruments
'             federal funds rate constrained to be positive
'             explicit loss weights (requires R)


wfcreate(wf=testing,page=monthly) m 1970m1 2010m12


' choose which example to execute
  scalar selection = 1
  @uiradio(selection,"Select an example to run:","Example_1 Example_2 Example_3 Example_4 Example_5 Example_6")
  !example = selection


' ***********************************************
' fetch monthly data
  statusline data
  dbopen(type=fred)
  fetch unrate fedfunds pcepilfe

' ***********************************************
' convert data to quarterly frequency
  pagecreate(page=quarterly) q 1970q1 2010q4

  smpl @all
  copy(c=a) monthly\unrate urate
  copy(c=a) monthly\fedfunds rff
  copy(c=a) monthly\pcepilfe pce

  series pi = 400*dlog(pce)
  series dpi = d(pi)
  series real = rff - @movav(pi,4)
  series un = 5.5
  series ugap = urate - un
  series drff = d(rff)
  series pi_t = 2

' ***********************************************
' estimate unemployment rate, inflation rate, and interest
' rate equations
  statusline equations

  smpl 1980q1 2008q4
  equation ueq.ls ugap c ugap(-1 to -4) real(-1 to -4)
  equation peq.ls dpi dpi(-1 to -3) ugap(0 to -1)
  equation peq_nlin.ls dpi dpi(-1 to -3) (@exp(.5*ugap)-1)

  smpl 1987q1 2007q4
  equation req.ls rff = c(1)*rff(-1) + (1-c(1))*(c(2)*(pi-pi_t) _
                      + c(3)*ugap + +c(4)*d(ugap) + 2 + pi_t)

' ***********************************************
' create models
  statusline models

  model testmod_lin
  testmod_lin.merge ueq
  testmod_lin.merge peq
  testmod_lin.merge req
  testmod_lin.append real = rff - @movav(pi,4)
  testmod_lin.append pi = dpi + pi(-1)
  testmod_lin.append drff = rff - rff(-1)

  model testmod_nlin
  testmod_nlin.merge ueq
  testmod_nlin.merge peq_nlin
  testmod_nlin.merge req
  testmod_nlin.append real = rff - @movav(pi,4)
  testmod_nlin.append pi = dpi + pi(-1)
  testmod_nlin.append drff = rff - rff(-1)


' ***********************************************
' Example 1:  mcontrol, linear model, more targets than instruments

  if !example = 1 then
    statusline mcontrol
    smpl 2002q1 2009q4
    testmod_lin.addassign @all
    testmod_lin.addinit(v=z) @all

    group instruments rff_a
    group targvars ugap pi drff

    series pi_t = 2
    series ugap_t = 0
    series drff_t = 0

    group trajvars ugap_t pi_t drff_t

    testmod_lin.scenario(n,a="_1") oc
    testmod_lin.mcontrol instruments targvars trajvars
    testmod_lin.makegraph(a) gr1 ugap pi rff
    statusline example 1 done
    endif

' ***********************************************
' Example 2:  mcontrol, linear model, equal number of targets and instruments

  if !example = 2 then
    statusline mcontrol
    smpl 2002q1 2009q4
    testmod_lin.addassign @all
    testmod_lin.addinit(v=z) @all

    group instruments ugap_a pi_a
    group targvars ugap pi

    series ugap_t = 0
    series pi_t = 3

    group trajvars ugap_t pi_t

    testmod_lin.scenario(n,a="_1") oc
    testmod_lin.mcontrol instruments targvars trajvars
    testmod_lin.makegraph(a) gr1 ugap pi rff
    statusline example 2 done
    endif


' ***********************************************
' Example 3:  mcontrol, nonlinear model, more targets than instruments
'             explicit loss weights supplied

  if !example = 3 then
    statusline mcontrol
    smpl 2002q1 2009q4
    testmod_nlin.addassign @all
    testmod_nlin.addinit(v=z) @all

    group instruments rff_a
    group targvars ugap pi drff

    series pi_t = 2
    series ugap_t = 0
    series drff_t = 0

    group trajvars ugap_t pi_t drff_t

    series ugap_w = 3
    series pi_w = 2
    series drff_w = 1
    group weights ugap_w pi_w drff_w

    testmod_nlin.scenario(n,a="_1") oc
    testmod_nlin.mcontrol instruments targvars trajvars weights
    testmod_nlin.makegraph(a) gr1 ugap pi rff
    statusline example 3 done
    endif


' ***********************************************
' Example 4:  mcontrol, nonlinear model, equal number of targets and instruments

  if !example = 4 then
    statusline mcontrol
    smpl 2002q1 2009q4
    testmod_nlin.addassign @all
    testmod_nlin.addinit(v=z) @all

    group instruments ugap_a pi_a
    group targvars ugap pi

    series ugap_t = 0
    series pi_t = 3

    group trajvars ugap_t pi_t

    testmod_nlin.scenario(n,a="_1") oc
    testmod_nlin.mcontrol instruments targvars trajvars
    testmod_nlin.makegraph(a) gr1 ugap pi rff
    statusline example 4 done
    endif

' ***********************************************
' Example 5:  mcontrol_qp, linear model, more targets than instruments
'             federal funds rate constrained to be positive

  if !example = 5 then
    statusline mcontrol_qp
    smpl 2002q1 2009q4
    testmod_lin.addassign @all
    testmod_lin.addinit(v=z) @all

    group instruments rff_a
    group targvars ugap pi drff

    series pi_t = 3
    series ugap_t = 0
    series drff_t = 0

    text constraints
    constraints.append rff >=0

    group trajvars ugap_t pi_t drff_t

    testmod_lin.scenario(n,a="_1") oc
    testmod_lin.mcontrol_qp instruments targvars trajvars constraints
    testmod_lin.makegraph(a) gr1 ugap pi rff
    statusline example 5 done
    endif


' ***********************************************
' Example 6:  mcontrol_qp, nonlinear model, more targets than instruments
'             federal funds rate constrained to be positive
'             explicit loss weights

  if !example = 6 then
    statusline mcontrol_qp
    smpl 2002q1 2009q4
    testmod_nlin.addassign @all
    testmod_nlin.addinit(v=z) @all

    group instruments rff_a
    group targvars ugap pi drff

    series pi_t = 3
    series ugap_t = 0
    series drff_t = 0

    matrix weight_mat = @identity(3) 
    sym weight_sym = weight_mat
    scalar weight_discount = .99

    text constraints
    constraints.append rff >=0

    group trajvars ugap_t pi_t drff_t

    testmod_nlin.scenario(n,a="_1") oc
    testmod_nlin.mcontrol_qp instruments targvars trajvars constraints weight_sym weight_discount
    testmod_nlin.makegraph(a) gr1 ugap pi rff
    statusline example 6 done
    endif

' ***********************************************
    mcontrol_spool.insert(loc=1) gr1
    mcontrol_spool.name untitled03 graph
