'-------------------
'This program is used to estimate the historical simulations in Figures 13 and 14 in Saunders and Tulip (2019).
'Program written by Trent Saunders
'-------------------

if %history = "yes" then
	smpl @all
	
	'Add factors
	model.addassign @all
	model.addinit(s=b, v=z) @all
	
	'Create groups for mcontrol add-in
	group mcontrol_a	
	group mcontrol	
	group mcontrol_t	
	
	'Define exogenous/endogenous variables that will be adjusted
	%exog_variables = "rinc_per_capita ur wap depreciation_rate demolition_rate tcpi cash vmr i_10y_bond uc"
	%endog_variables = "bahousevol baothervol baaavol chouseno cotherno chousevol cothervol caavol wdhousevol wdothervol wdaavol comphouseno compotherno rdp rrent vacancy yield"
	
	'Set targets for variables and add variables to groups (i.e. need to create groups for mcontrol add-in)
	smpl @all
	for %x {%exog_variables} {%endog_variables}
		'Create targets
		series {%x}_t = {%x}
		
		'Add variables to group objects
		mcontrol_a.add	{%x}_a
		mcontrol.add		{%x}	
		mcontrol_t.add	{%x}_t
	next

	include 9a_cash_rate_scenario		'Run interest rate simulation (Figure 13)
	model.addinit(s=a, v=z) @all 			'Reset all add factors to equal zero before running next scenario
	include 9b_population_scenario 	'Run population simulation (Figure 14)
	model.addinit(s=o, v=z) @all 			'Reset all add factors to equal zero before running next scenario

	'Reset income addfactors to offset effect of rsing interest rates, so that income grows at lr_inc.
	'Otherwise rising interest rates generate low growth -- in which case interest rates would not rise.
	smpl %sfc  %efc
	rinc_per_capita_a = 0.0016*(rvmr_k(-1)-rvmr_k(-41)) 	'This is the assumption used in program '5_baseline_projections'

	close mcontrol_spool
endif


