
'-------------------
'This program is used to put together Figures 2 to 11 and C1 to C3 in Saunders and Tulip (2019).
'Program written by Trent Saunders
'-------------------
'IMPORTANT: Remember to turn %ragged off  in '_main_program.prg', or you will compare to the wrong baseline for some of the estimated responses!
'-------------------

!font_size = 20 'Font size for graph titles

'------------
'Graph 2 -  Dwelling Investment and Real Household Disposable Income
'------------
smpl 1959 %ed

'Graphit data
group graphit_02 date1 natdi/@mean(natdi,"2015q1 2015q4")*100 rinc/@mean(rinc,"2015q1 2015q4")*100 date2 (natdi/rinc)/@mean(natdi/rinc)*100

'Eviews graphs
%n = "2a"	'Panel A
graph _gr_{%n}.line natdi/@mean(natdi,"2015q1 2015q4")*100 rinc/@mean(rinc,"2015q1 2015q4")*100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Level \r (2015 average = 100)"
_gr_{%n}.setelem(1)  legend("Dwelling investment") 
_gr_{%n}.setelem(2)  legend("Real household disposable income") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "2b"	'Panel B
graph _gr_{%n}.line (natdi/rinc)/@mean(natdi/rinc)*100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Ratio \r (Long-run average = 100)"
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "02"  
graph _gr_{%n}.merge _gr_2a _gr_2b 'Merge into 2-panel graph
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Dwelling Investment and Real Household Disposable Income"
_gr_{%n}.align(2,1,2.5)
delete _gr_2a _gr_2b 	'Delete individual graphs

'------------
'Graph 3 - Changes in Building Approvals
'------------

'Graphit data
smpl @all
series batotalvol1 = batotalvol
group graphit_03 date1 @pcy(batotalvol) rvmr(-2)-rvmr(-6) date2 @pcy(batotalvol1) @pcy(rdp) 

'Eviews graphs
%n = "3a"
smpl 1983 2018
graph _gr_{%n}.line(x) @pcy(batotalvol) rvmr(-2)-rvmr(-6) 100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Real interest rates"
_gr_{%n}.setelem(1)  legend("Total dwelling approvals (year-ended growth, LHS)") 
_gr_{%n}.setelem(2)  legend("Real variable mortgage rate (4-quarter change,") 
_gr_{%n}.setelem(3)  legend("inverted, lagged 2-qrtrs, RHS)") lcolor(white)
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(r) invert range(-9,6)
_gr_{%n}.axis(left)  zeroline		'Include zero line

%n = "3b"
graph _gr_{%n}.line(x) @pcy(batotalvol) @pcy(rdp) 
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Real dwelling prices"
_gr_{%n}.setelem(1)  legend("Total dwelling approvals (year-ended growth, LHS)") lcolor(orange)
_gr_{%n}.setelem(2)  legend("Real dwelling prices (year-ended growth, RHS)") lcolor(green)
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left)  zeroline		'Include zero line

%n = "03"
graph _gr_{%n}.merge _gr_3a _gr_3b	 'Merge into 2-panel graph
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Dwelling Investment and Real Household Disposable Income \r (year-ended change)"
_gr_{%n}.align(2,1,2.5)
delete _gr_3a _gr_3b

'------------
'Graph 4 - Responses of Building Approvals to Interest Rates and Housing Prices (partial equilibrium)
'Note: To re-create this scenario it is necessary to run the baseline forecast without the ragged edge (see '_main_program.prg')
'------------

'Set exogenous paths for housing prices and income, and save temporary series with actual data
smpl @all
series rdp_temp = rdp 	'Store temp series for real housing prices
series rdp = rdp_b 			'Target real housing prices
series rinc_temp = rinc	'Store temp series for rinc
series rinc = rinc_b 		'Target rinc

'Panel A - Calculate response to sustained 100bp increase in cash rate, holding rdp and rinc constant
'Note: This is the same scenario as 6a
%shock = "cash"   	'Cash rate
%shock_type = "perm"	'Permanent
scalar shock_size = -1
%scenario = "4a"
%excludevars = "rinc rdp" 'Exogenise real income
include 6_alternative_projections	'Estimate alternative scenario
series rdp = rdp_temp 'Reset real housing price variable
series rinc = rinc_temp 'Reset real income variable
%excludevars = " " 'Reset exclusions

'Panel B - Sustained 10% increase in real housing prices 
'Note: Real housing prices do not affect the other variables in the approvals equations, so the single equation and full model responses of investment to housing prices are the same
%shock = "rdp"   			'Cash rate
%shock_type = "perm"	'Permanent
scalar shock_size = 0.10	'10% increase
%scenario = "4b"			'Define scenario
include 6_alternative_projections	'Estimate alternative scenario

'Graphit data
smpl %sfc-1 %sfc+28			'Sample for graph
group graphit_4a trend1 batotalvol_4a/batotalvol_b*100-100 trend2 bahousevol_4a/bahousevol_b*100-100 trend3 baothervol_4a/baothervol_b*100-100 trend4 baaavol_4a/baaavol_b*100-100
group graphit_4b trend5 batotalvol_4b/batotalvol_b*100-100 trend6 bahousevol_4b/bahousevol_b*100-100 trend7 baothervol_4b/baothervol_b*100-100 trend8 baaavol_4b/baaavol_b*100-100
group graphit_04 graphit_4a graphit_4b

'Eviews graphs
smpl %sfc-1 %sfc+28			'Sample for graph
%n = "4a"
graph _gr_{%n}.line  batotalvol_4a/batotalvol_b*100-100 bahousevol_4a/bahousevol_b*100-100 baothervol_4a/baothervol_b*100-100 baaavol_4a/baaavol_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Sustained 100bp Reduction \r in Real Mortgage Rates"
_gr_{%n}.setelem(1)  legend("Total dwelling") 
_gr_{%n}.setelem(2)  legend("Detached house") 
_gr_{%n}.setelem(3)  legend("Higher-density housing") 
_gr_{%n}.setelem(4)  legend("Alterations and additions") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left)  zeroline		'Include zero line

%n = "4b"
graph _gr_{%n}.line  batotalvol_4b/batotalvol_b*100-100 bahousevol_4b/bahousevol_b*100-100 baothervol_4b/baothervol_b*100-100 baaavol_4b/baaavol_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Sustained 10 per cent Increase \r in Real Housing Prices"
_gr_{%n}.setelem(1)  legend("Total dwelling") 
_gr_{%n}.setelem(2)  legend("Detached house") 
_gr_{%n}.setelem(3)  legend("Higher-density housing") 
_gr_{%n}.setelem(4)  legend("Alterations and additions") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left)  zeroline		'Include zero line

%n = "04"
graph _gr_{%n}.merge _gr_4a _gr_4b
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Responses of Building Approvals to Interest Rates and Housing Prices"
_gr_{%n}.align(2,1,2.5)
delete _gr_4a _gr_4b

'------------
'Graph 5 - Residential Building Approvals
'------------

%n = "05"
!count = 1	'This is used to call the date columns for the different panels when compiling the Graphit data below.
for %x house other aa
	smpl @all
	'Scale and graph time-varying intercepts for graphs
	series sv1f_{%x}_lr = exp(sv1f_{%x}/-lambda_{%x})
	series sv1s_{%x}_lr = exp(sv1s_{%x}/-lambda_{%x})

	'Graphit data
	!count = !count + 1
	group graphit_{%n}_{%x} date{!count} ba{%x}vol/rinc/100 sv1f_{%x}_lr/100 sv1s_{%x}_lr/100

	'Eviews graphs
	smpl 1990 %ed
	graph _gr_{%n}_{%x}.line ba{%x}vol/rinc/100 sv1f_{%x}_lr/100 sv1s_{%x}_lr/100
	_gr_{%n}_{%x}.setelem(1)  legend("Actual") 
	_gr_{%n}_{%x}.setelem(2)  legend("1-sided trend") 
	_gr_{%n}_{%x}.setelem(3)  legend("2-sided trend") 
next

'Aggregate time-varying intercept
smpl @all
series sv1f_total_lr = sv1f_house_lr + sv1f_other_lr + sv1f_aa_lr
series sv1s_total_lr = sv1s_house_lr + sv1s_other_lr + sv1s_aa_lr

'Graphit data
group graphit_{%n}_total date1 batotalvol/rinc/100 sv1f_total_lr/100 sv1s_total_lr/100
group graphit_{%n} graphit_{%n}_total graphit_{%n}_house graphit_{%n}_other graphit_{%n}_aa

'Eviews graphs
smpl %sd_approvals %ed
smpl 1990 2018
graph _gr_{%n}_total.line  batotalvol/rinc/100 sv1f_total_lr/100 sv1s_total_lr/100
_gr_{%n}_total.setelem(1)  legend("Actual") 
_gr_{%n}_total.setelem(2)  legend("1-sided trend") 
_gr_{%n}_total.setelem(3)  legend("2-sided trend") 

'Graph titles
_gr_{%n}_total.addtext(t, font({!font_size}), just(c)) "Total dwelling approvals"
_gr_{%n}_house.addtext(t, font({!font_size}), just(c)) "Detached house approvals"
_gr_{%n}_other.addtext(t,font({!font_size}), just(c)) "Higher-density housing approvals"
_gr_{%n}_aa.addtext(t, font({!font_size}), just(c)) "Alterations and additions approvals"

'Merge into 4-panel graph
graph _gr_{%n}.merge _gr_{%n}_total _gr_{%n}_house _gr_{%n}_other _gr_{%n}_aa
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Residential Building Approvals \r (Constant prices, ratio to real household disposable income)"
_gr_{%n}.align(2,1,2.5)
delete _gr_{%n}_total _gr_{%n}_house _gr_{%n}_other _gr_{%n}_aa

'------------
'Graph 6 - Responses of Dwelling Investment to a Sustained 100bp Reduction in Interest Rates
'------------

'Set exogenous paths for housing prices and income, and save temporary series with actual data
smpl @all
series rdp_temp = rdp 	'Store temp series for real housing prices
series rdp = rdp_b 			'Target real housing prices
series rinc_temp = rinc	'Store temp series for rinc
series rinc = rinc_b 		'Target rinc

'Panel A - Calculate response to sustained 100bp increase in cash rate, allowing rdp to vary but not rinc
'Note: this is the same scenario as 4a
%n = "6a"
%shock = "cash"   	'Cash rate
%shock_type = "perm"	'Permanent
scalar shock_size = -1
%scenario = "6a"
%excludevars = "rinc rdp" 'Exogenise real income
include 6_alternative_projections	'Estimate alternative scenario
series rdp = rdp_temp 'Reset real housing price variable
%excludevars = " " 'Reset exclusions

'Panel B - Calculate response to sustained 100bp increase in cash rate, allowing rdp to vary but not rinc
%n = "6b"
%shock = "cash"   	'Cash rate
%shock_type = "perm"	'Permanent
scalar shock_size = -1
%scenario = "6b"
%excludevars = "rinc" 'Exogenise real income
'Exogenise cash_exp_av to see effect of changes in long-term interest rates (as discussed in section 4.2.1)
'%excludevars = "rinc cash_exp_av"
include 6_alternative_projections	'Estimate alternative scenario
series rinc = rinc_temp 'Reset real income variable
%excludevars = " " 'Reset exclusions

'Panel C - Calculate response to sustained 100bp increase in cash rate, allowing dp and rinc to vary
%n = "6c"
%shock = "cash"   	'Cash rate
%shock_type = "perm"	'Permanent
scalar shock_size = -1
%scenario = "6c"
include 6_alternative_projections	'Estimate alternative scenario

'Calculate contributions for chart
smpl @all
series cont_direct = natdi_6a-natdi_b
series cont_dp = natdi_6b-natdi_6a
series cont_inc = natdi_6c-natdi_6b

'Graphit data
group graphit_06a  trend1 natdi_6a/natdi_b*100-100		
group graphit_06b  trend2  (cont_direct/natdi_b*100) trend3  (cont_dp/natdi_b*100) trend4 (cont_inc/natdi_b*100)	

'Eviews graphs
smpl %sfc-1 %sfc+28			'Sample for graph
%n = "6a"
graph _gr_{%n}.line  natdi_6a/natdi_b*100-100 'Does not include responses from AUS-M or MARTIN
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Partial Response"
_gr_{%n}.setelem(1)  legend("Our model")  
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left)  zeroline		'Include zero line

%n = "6b"
smpl %sfc-1 %sfc+28			'Sample for graph
graph _gr_{%n}.area(s)  (cont_direct/natdi_b*100) (cont_dp/natdi_b*100) (cont_inc/natdi_b*100) 'Does not include responses from AUS-M or MARTIN
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Full Model Response"
_gr_{%n}.setelem(1)  legend("Direct effect")  
_gr_{%n}.setelem(2)  legend("Price contribution")  
_gr_{%n}.setelem(3)  legend("Income contribution")  
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left)  zeroline		'Include zero line

%n = "06"
smpl %sfc-1 %sfc+28			'Sample for graph
graph _gr_{%n}.merge _gr_6a _gr_6b
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Responses of Dwelling Investment to Interest Rates"
_gr_{%n}.align(2,1,2.5) 'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)
delete _gr_6a _gr_6b

'------------
'Graph 7 - Direct Responses of Dwelling Stock
'------------
'NOTES: The response to interest rates is the same scenario as Graph 4a
'			Real housing prices do not affect the other variables in the approvals equations, so the single equation and full model responses to housing prices are the same

'Calculate response to sustained 10 per cent increase in real house prices 
%shock = "rdp"   			'Real housing prices
%shock_type = "perm"	'Permanent
scalar shock_size = 0.10  '10% increase
%scenario = "7"
include 6_alternative_projections	'Estimate alternative scenario

'Eviews graphs
smpl %sfc-1 %efc
%n = "07"
graph _gr_{%n}.line  stock_4a/stock_b*100-100 stock_7/stock_b*100-100 
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Responses of Dwelling Stock \r (Deviation from baseline, partial equilibrium)"
_gr_{%n}.setelem(1)  legend("Sustained 100bp reduction in real mortgage rates") 
_gr_{%n}.setelem(2)  legend("Sustained 10 per cent increase in real housing prices") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left)  zeroline		'Include zero line

'Graphit data
group graphit_{%n}  trend1 stock_4a/stock_b*100-100	trend2  stock_7/stock_b*100-100	'Same scenario as Graph 4

'------------
'Graph 8 - Rental Vacancies and Excess Housing
'------------

'Graphit data
group graphit_08 date1 0.001*d(stock_no) 0.001*d(wap)/(@movav(wap/stock_no,20)) date2 excess_comp*100 vacancy

'Eviews graphs
'smpl %sd %efc
smpl 1983Q1 %ed
%n = "8a"
graph _gr_{%n}.line  d(stock_no_b) d(wap_b)/(@movav(wap_b/stock_no_b,20)) 
_gr_{%n}.setelem(1)  legend("Net additions to the dwelling stock ('000)")  lcolor(green)
_gr_{%n}.setelem(2)  legend("'Underlying' household formation ('000)")  lcolor(purple)
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(l) units(k) label
'_gr_{%n}.draw(shade, b, gray) %sfc %efc	'Shade forecast horizon grey

%n = "8b"
graph _gr_{%n}.line(x)  vacancy_b excess_comp_b*100 
_gr_{%n}.setelem(1)  legend("Vacancy rate (%, LHS)")  lcolor(red)
_gr_{%n}.setelem(2)  legend("Excess completions (% of total housing stock, RHS)") lcolor(blue)
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(left) range(1, 5.5)
_gr_{%n}.axis(right) range(-0.3, 0.6) 
'_gr_{%n}.draw(shade, b, gray) %sfc %efc	'Shade forecast horizon grey

%n = "08"
graph _gr_{%n}.merge _gr_8a _gr_8b
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Rental Vacancies and Excess Housing"
_gr_{%n}.align(1,0.5,2) 'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)
delete _gr_8a _gr_8b

'------------
'Graph 9 - Rental Vacancy Rate
'------------

'Save temporary series
smpl @all
series ur_temp = ur
series excess_comp_temp = excess_comp

'Set variables equal to baseline projections
smpl %sfc %efc
series ur = ur_b
series excess_comp = excess_comp_b

'Calculate forecasts
smpl 1983q2 %efc
eq_vac.forecast(e, g) vacancy_fit

'Graphit data
smpl 1983 %efc
group graphit_09 date1 vacancy vacancy_fit

'Eviews graphs
'smpl 1983 %efc
smpl 1983 %ed
%n = "09"
graph _gr_{%n}.line  vacancy_b vacancy_fit 
'graph _gr_{%n}.line  vacancy vacancy_fit 
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Rental Vacancy Rate \r (Actual and fitted)*"
_gr_{%n}.setelem(1)  legend("Rental vacancy rate")  
_gr_{%n}.setelem(2)  legend("Dynamic forecast from 1983Q1")  
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.addtext(b)  "* The in-sample forecasts use actual data for the explanatory variables"
'_gr_{%n}.draw(shade, b, gray) %sfc %efc	'Shade forecast horizon grey

'------------
'Graph 10 - Real CPI Rent Growth and the Rental Vacancy Rate
'------------

'Graphit data
group graphit_10 date @pcy(rent_cpi)-inf_3y*400 vacancy

'Eviews graphs
'smpl %sd %efc
smpl 1983 %ed
%n = "10"
graph _gr_{%n}.line(x) vacancy_b @pcy(rent_cpi_b)-inf_3y_b*400
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Real CPI Rent Growth and the Rental Vacancy Rate"
_gr_{%n}.setelem(1)  legend("Vacancy Rate (LHS, inverted scale)")  
_gr_{%n}.setelem(2)  legend("Real CPI rents (year-ended growth, RHS)")  
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
_gr_{%n}.axis(l) invert range(0,6)
_gr_{%n}.axis(r) range(-6,6)
'_gr_{%n}.draw(shade, b, gray) %sfc %efc	'Shade forecast horizon grey

'------------
'Graph 11 - Cost of Owning Versus Renting
'------------

'Graphit data
group graphit_11 date uc yield

'Eviews graphs
smpl %sd %ed
smpl 1982q3 2018q3
%n = "11"
graph _gr_{%n}.line uc yield
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Cost of Owning Versus Renting"
_gr_{%n}.setelem(1)  legend("User cost of housing")  
_gr_{%n}.setelem(2)  legend("Rental yield (based on CPI rents)")  
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

'------------
'Graphs 12 to 16 are put together in seperate programs and called from '_main_program.prg'
'------------

'------------
'Graph B1 -  Average Quality of Approvals and Real Income Per Adult
'------------
smpl 1990 %ed

'Graphit data
group graphit_b1 date1 bahouseavol/@mean(bahouseavol,"1990q1 2018q4")*100 (rinc/wap)/@mean(rinc/wap,"1990q1 2018q4")*100 date2 baotheravol/@mean(baotheravol,"1990q1 2018q4")*100 (rinc/wap)/@mean(rinc/wap,"1990q1 2018q4")*100

'Eviews graphs
%n = "b1a"
graph _gr_{%n}.line bahouseavol/@mean(bahouseavol,"1990q1 2018q4")*100 (rinc/wap)/@mean(rinc/wap,"1990q1 2018q4")*100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Detached houses"
_gr_{%n}.setelem(1)  legend("Average volume of approvals") 
_gr_{%n}.setelem(2)  legend("Real household disposable income") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "b1b"
graph _gr_{%n}.line baotheravol/@mean(baotheravol,"1990q1 2018q4")*100 (rinc/wap)/@mean(rinc/wap,"1990q1 2018q4")*100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Higher-density housing"
_gr_{%n}.setelem(1)  legend("Average volume of approvals") 
_gr_{%n}.setelem(2)  legend("Real household disposable income") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "b1"
graph _gr_{%n}.merge _gr_{%n}a _gr_{%n}b
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Average Quality of Approvals and Real Income Per Adult"
_gr_{%n}.align(2,1,2.5)
delete _gr_{%n}a _gr_{%n}b

'------------
'Graph B2
'------------

'Calculate response to higher approvals
%n = "b2"
%shock = "batotalvol"   	'Real housing prices
%shock_type = "perm"	'Permanent
scalar shock_size = 0.1	 	'10 per cent increase
%scenario = "b2"
include 6_alternative_projections	'Estimate alternative scenario

'Graphit data
group graphit_b2 trend1 natdi_{%scenario}/natdi_b*100-100  trend2 nahousevol_{%scenario}/nahousevol_b*100-100  trend3 naothervol_{%scenario}/naothervol_b*100-100  trend4 naaavol_{%scenario}/naaavol_b*100-100 trend5 comptotalno_{%scenario}/comptotalno_b*100-100  trend6 comphouseno_{%scenario}/comphouseno_b*100-100  trend7 compotherno_{%scenario}/compotherno_b*100-100

'Eviews graphs

smpl %sfc-1 %sfc+16

%n = "b2a"
graph _gr_{%n}.line natdi_{%scenario}/natdi_b*100-100 nahousevol_{%scenario}/nahousevol_b*100-100 naothervol_{%scenario}/naothervol_b*100-100 naaavol_{%scenario}/naaavol_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "A: Dwelling Investment"
_gr_{%n}.setelem(1)  legend("Total") 
_gr_{%n}.setelem(2)  legend("Detached houses") 
_gr_{%n}.setelem(3)  legend("Higher-density housing") 
_gr_{%n}.setelem(4)  legend("Alterations and additions") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "b2b"
graph _gr_{%n}.line comptotalno_{%scenario}/comptotalno_b*100-100 comphouseno_{%scenario}/comphouseno_b*100-100 compotherno_{%scenario}/compotherno_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "B: Dwelling completions"
_gr_{%n}.setelem(1)  legend("Total") 
_gr_{%n}.setelem(2)  legend("Detached houses") 
_gr_{%n}.setelem(3)  legend("Higher-density housing") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "b2"
graph _gr_{%n}.merge _gr_{%n}a _gr_{%n}b
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Responses to a Sustained 1 per cent Increase in Approvals"
_gr_{%n}.align(2,1,2.5)
delete _gr_{%n}a _gr_{%n}b

'------------
'Graph B3 - Coverage of alterations and additions data
'------------
smpl 1990 %ed

'Graphit data
group graphit_b3 date1 baaavol_original/1000 wdaavol_original/1000 naaavol/1000 date2 wdaavol_original/naaavol*100 @movav(wdaavol_original/naaavol,8)*100

'Eviews graphs
%n = "b3a"
graph _gr_{%n}.line baaavol_original wdaavol_original naaavol
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "Chain volume ($m)"
_gr_{%n}.setelem(1)  legend("Building approvals") 
_gr_{%n}.setelem(2)  legend("Work done") 
_gr_{%n}.setelem(3)  legend("National accounts investment") 
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "b3b"
graph _gr_{%n}.line wdaavol_original/naaavol*100 @movav(wdaavol_original/naaavol,8)*100
_gr_{%n}.addtext(t, font({!font_size}), just(c)) "Large alteration and additions share of investment"
_gr_{%n}.setelem(1)  legend("Actual") lcolor(green)
_gr_{%n}.setelem(2)  legend("2-year moving average") lcolor(purple)
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)

%n = "b3"
graph _gr_{%n}.merge _gr_{%n}a _gr_{%n}b
_gr_{%n}.addtext(t, font({!font_size},b), just(c))  "Alterations and Additions"
_gr_{%n}.align(2,1,2.5)
delete _gr_{%n}a _gr_{%n}b

'------------
'Graph C1 - Forecast
'------------
copy _gr_projections_b _gr_c1 

'Update progress table
'------------------- 
!progress_row = !progress_row+1
progress(!progress_row,1) = "8_other_graphs"


