'-------------------
'Responses to 10% increase in residential building approvals (i.e. each component of approvals increases by 10%)
'This program is used to estimate the responses in Figure 15, Saunders and Tulip (2019)
'-------------------
'IMPORTANT: Remember to turn %ragged off  in '_main_program.prg', or you will compare to the wrong baseline!
'-------------------

'Scenario settings
%shock = "batotalvol"   	'Variable that will be changed
shock_size = 0.1	 		'10% increase
%shock_type = "temp"'	'Temporary 
'%shock_type = "perm"'	'Permanent
%scenario = "15"			'Suffix for scenario estimates
!temp_horizon = 4			'Number of quarters for temporary change
include 6_alternative_projections	'Estimate alternative scenario

'-------------------------------------------------------------------
'Make Figure 15 - Responses to more construction
'-------------------------------------------------------------------

%shock_name = "Housing Approvals (Chain Volume)" 'Graph label
!font_size = 20
smpl %sfc-1 %sfc+28			'Sample for graph

'Make individual graphs
'-------------------

%n = %scenario+"1"	'Panel 1
graph _gr_{%n}.line batotalvol_{%scenario}/batotalvol_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Total housing approvals (%)"

%n = %scenario+"2"	'Panel 2
graph _gr_{%n}.line natdi_{%scenario}/natdi_b*100-100 comptotalno_{%scenario}/comptotalno_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling investment and completions (%)"
_gr_{%n}.setelem(1)  legend("Investment")  
_gr_{%n}.setelem(2)  legend("Completions")  

%n = %scenario+"3"	'Panel 3
graph _gr_{%n}.line stock_no_{%scenario}/stock_no_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Number of dwellings (%)"

%n = %scenario+"4"	'Panel 4
graph _gr_{%n}.line vacancy_{%scenario}-vacancy_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (ppt)"

%n = %scenario+"5"	'Panel 5
graph _gr_{%n}.line rrent_{%scenario}/rrent_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real CPI rents (%)"

%n = %scenario+"6"	'Panel 6
graph _gr_{%n}.line rdp_{%scenario}/rdp_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real housing prices (%)"

'Format individual graphs
'------------------- 
for !i = 1 to 6
	_gr_{%scenario}{!i}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)	'Set fonts
	_gr_{%scenario}{!i}.axis(left)  zeroline	'Include zero line
next

'Merge into 6-panel graph
'------------------- 
graph _gr_{%scenario}.merge _gr_{%scenario}1 _gr_{%scenario}2 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6 
_gr_{%scenario}.align(3,1,2.5)	'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)
%title = "Responses to "+%shock_name+"\r Deviation from baseline level"
_gr_{%scenario}.addtext(t, font({!font_size},b), just(c))  {%title}
delete _gr_{%scenario}1 _gr_{%scenario}2 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6  'Delete individual graphs

'Compile Graphit data
'------------------- 
group graphit_{%scenario} trend1 batotalvol_{%scenario}/batotalvol_b*100-100 trend2 natdi_{%scenario}/natdi_b*100-100 comptotalno_{%scenario}/comptotalno_b*100-100 trend3 stock_no_{%scenario}/stock_no_b*100-100 trend4 vacancy_{%scenario}-vacancy_b trend5 rrent_{%scenario}/rrent_b*100-100 trend6  rdp_{%scenario}/rdp_b*100-100


'Calculate flow into completions
'Note: This is used for the estimated boost to the total number of dwellings in section 5.3 in Saunders and Tulip (2019)
'------------------- 
smpl @all
series cumbahouse = @cumsum(bahouseno_15-bahouseno_b)
series cumcomphouse = @cumsum(comphouseno_15-comphouseno_b )
series houseflow = cumcomphouse/cumbahouse 
series cumbaother = @cumsum(baotherno_15-baotherno_b)
series cumcompother = @cumsum(compotherno_15-compotherno_b )
series otherflow = cumcompother/cumbaother 

'Update progress table
'------------------- 
!progress_row = !progress_row+1
progress(!progress_row,1) = "8_graph15_approvals ("+ %shock +")"

