'-------------------
'This program estimates the models baseline projections, based on the market path for the cash rate
'Program written by Trent Saunders
'-------------------

'Baseline projections
'------------------------------------------
smpl %sfc  %efc

'Do initial run so as to calculate addfactors for income equation
model.scenario(n,a=_k) "k" 	'This projection has suffix "_k"
model.solve(d=d) 'Calculate forecasts

'Set income addfactors to offset effect of rising interest rates, so that income grows at lr_inc.
'Otherwise rising interest rates in the yield curve generate low growth -- in which case interest rates would not rise
model.addassign rinc_per_capita
model.addinit rinc_per_capita
rinc_per_capita_a = 0.0016*(rvmr_k(-1)-rvmr_k(-41)) 	'This is also set at the end of program '9_historical_simulations'. Make sure these programs are consistent.

'Run updated baseline with real income add factors
smpl %sfc  %efc
model.scenario(n,a=_b) "b"	'Baseline projections have suffix "_b"
'Note: choosing %ragged = "yes" in the main program settings will make normally endogenous variables exogenous when values for those variables exist.  So the forecast is really jumping off the latest quarterly observation for each variable.
if %ragged = "yes" then
	model.exclude(actexist=t)	
endif

model.solve(d=d) 'Calculate forecasts

'Update progress table
!progress_row = !progress_row+1
progress(!progress_row,1) = "5_baseline_projections"


