'-----------------------------------------------------
' Data transformations and adjustments
'Program written by Trent Saunders
'-----------------------------------------------------

'Create date series so that data can easily be copied into Graphit
smpl @all
series date = @dateadd(@date, 2, "mm")
date.setformat ddmmYYYY

'Create numbered series so that responses data can easily be copied into Graphit 
smpl @all
series trend = @trend(%sfc) 

'This is an ad hoc solution for an EViews quirk. We need to export multiple trend/date series to the same tExcel worksheet, but you can't directly do this in Eviews. So I have had to create multiple copies of the same series.
for !i = 1 to 18
	series trend{!i} = trend
	series date{!i} = date
	date{!i}.setformat ddmmYYYY
next

'--------------
'Real variables and inflation
'--------------
smpl @all

'Average inflation rates
series inf_1y = (log(tcpi)-log(tcpi(-4)))/4
series inf_3y = (log(tcpi)-log(tcpi(-12)))/12

'Real housing prices
series rdp = ndp/tcpi*100

'Real variable mortgage rate
series rvmr = vmr - ((tcpi/tcpi(-12))^(1/3)-1)*100

'Real income
series rinc = inc/tcpi		'Real income
series rinc_per_capita = rinc/wap	'Real income per capita

'Real rents
series rrent = rent_cpi/tcpi		

'--------------
'Adjust ratio of CPI rents to housing prices to have same mean as Corelogic/REIA rental yield
'--------------

scalar yield_adj = 4.643402		'Scaling factor based on regression of Corelogic/REIA rental yield on rent_cpi/ndp
series yield = rent_cpi/ndp*4.643402

'--------------
'User cost of housing
'--------------

'SOURCE: Fox & Tulip (2014), http://www.rba.gov.au/publications/rdp/2014/pdf/rdp2014-06.pdf
'Note: We import time series for the appreciation rate, stamp duty, interest rates, inflation expectations.
'We set other buying and selling costs and depreciation to be constants, as per the paper.  Running costs are proportional to the matched sample rental yield.
'We construct the expected mortgage rate as per Parsons and Tulip, tracking the govt bond yield rather than 10-year mortgages.

'Running costs
series uc_running_cost = yield*0.358 'Fox & Tulip (2014), p. 39

'Hold paramaters constant
'Corelogic and HANA have stopped updating, so hold the following constant at 2017q3 values
smpl 2017q3  @last
series uc_running_cost = uc_running_cost(-1) 'Corelogic have stopped updating yield, so hold constant at 2017q3 value (4.357%)
series uc_stamp_duty = uc_stamp_duty(-1)	'HANA have stopped updating stamp duty estimates so hold constant at 2017q3 value (4.357%)
series uc_appreciation = uc_appreciation(-1)
smpl @all

'Transaction costs
series uc_selling_cost = 2.5 + 0.5	'Fox & Tulip (2014), p. 38, commissions (2.5) and other fees (0.5)
series uc_buying_cost =	0.25		'Fox & Tulip (2014), p. 29
series uc_tenure = 10			'Fox & Tulip (2014), p. 9, median estimate 
series uc_transaction_cost = (uc_stamp_duty + uc_selling_cost + uc_buying_cost)/uc_tenure

'Depreciation cost
series uc_depreciation = 1.06		'Fox & Tulip (2014), p. 9 

'Expected mortgage rate 
series vmr_exp = vmr + (i_10y_bond - cash) - (@mean(i_10y_bond, "2004q2 2030q1") - @mean(cash, "2004q2 2030q1"))
smpl @first 1997q2	'Splice expected mortgage rate back prior to 1997 using long rate (i.e. 10y government bond yield) when vmr starts to track cash
genr(r) vmr_exp = vmr_exp(1) - i_10y_bond(1) + i_10y_bond
smpl @all

'Real expected mortgage rate
series rvmr_exp = (1 + vmr_exp/100)/(1 + inf_exp/100)*100-100

'User cost
series uc = rvmr_exp + uc_transaction_cost + uc_running_cost + uc_depreciation - uc_appreciation

'--------------
'Housing completions
'--------------

'Splice total detached house completions back using private completions
smpl @first 1969q2	
genr(r) comphouseno = comphouseno(1) * comphouseno_private / comphouseno_private(1) 
smpl @all

'Splice total higher-density completions back using private completions
smpl @first 1984q2	
genr(r) compotherno = compotherno(1) * compotherno_private / compotherno_private(1) 
smpl @all

'Total dwelling completions
series comptotalno = comphouseno + compotherno

'--------------
'Housing stock
'--------------

'Number of dwellings
series demolition_rate = 1 - (stock_no_abs(19) - stock_no_abs(-1)) / @movsum(comptotalno(19), 20) 'Demolition rate (% of completions)
series demolition_rate = @recode(demolition_rate = na, demolition_rate(-1), demolition_rate)
series stock_no = @recode(@date=@dateval("1966:3"), stock_no_abs, stock_no(-1) + comptotalno * (1 - demolition_rate) )

''Dwelling stock (constant prices)
series replacement_rate = 1 - (stock_abs(3) - stock_abs(-1)) / @movsum(natdi(3), 4) ' Replacement rate (% of dwelling investment)
series replacement_rate = @recode(replacement_rate=na, replacement_rate(-1), replacement_rate)	'Interpolate for missing periods
series stock = @recode(@date=@dateval("1960:2"), stock_abs, stock(-1) + natdi * (1 - replacement_rate) )	'Quarterly housing stock
series depreciation_rate = replacement_rate*natdi/stock	 ' Depreciation rate (% of housing stock)

'--------------
'Generate additional series used by the model
'--------------
smpl @all

'GST dummy
series gst = @recode(@date=@dateval("2000:2"), 1, 0)

'Number of adults per dwelling 
series ahs = wap/stock_no*1000

'Investment-to-income ratio
series inv_to_income = natdi / rinc

'Excess completions - used in vacancy rate equation
series excess_comp = (d(stock_no)-d(wap)/(@movav(wap/stock_no,20)))/stock_no
series excess_comp_short = (d(stock_no)-d(wap)/((wap/stock_no)))/stock_no
series excess_comp = @recode(excess_comp=na, excess_comp_short, excess_comp)

'Average vacancy rate
series vacancy_mean  = @mean(vacancy)

'Average volume of approvals (i.e. average quality)
for %x house other
	series ba{%x}avol = ba{%x}vol / ba{%x}no * 1000
next

'Public commencements
for %x house other aa
	series c{%x}vol_public_temp = c{%x}vol - c{%x}vol_private
	series c{%x}vol_public = @recode(c{%x}vol_public_temp<=0, 5,c{%x}vol_public_temp)
next

'---------
'Scale alterations and additions data 
'This accounts for incomplete coverage of approvals, commencements and work done
'For more detail, see Section 4 in Appendix C Saunders and Tulip (2019)
'---------

smpl @all

'Save unadjusted series
series baaavol_original = baaavol
series batotalvol_original = bahousevol + baothervol + baaavol
series caavol_original = caavol
series caavol_private_original = caavol_private
series wdaavol_original = wdaavol

'Estimate the coverage of the data
series aa_coverage = @movav(wdaavol/naaavol,8)

'Adjust series for incomplete coverage
series baaavol = baaavol/aa_coverage 
series caavol = caavol/aa_coverage 
series caavol_private = caavol_private/aa_coverage 
series wdaavol = wdaavol/aa_coverage 
series batotalvol = bahousevol + baothervol + baaavol

'---------
'Update progress table
'---------
!progress_row = !progress_row+1
progress(!progress_row,1) = "0_data_transformations"
show progress


