
logmode +addin
'logmode debug

'  addin model prodecure
'
'  model_name.mcontrol(options) control_vars target_vars trajectory_vars [weights discount]
'

' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (1) Examine the object

  'check that an object exists
  %type =@getthistype
  if %type="NONE" then
    @uiprompt("Error:  No object found, please open a MODEL object.")
    stop
    endif

  'check that _this is a model object
  if %type<>"MODEL" then
    @uiprompt("Error:  Procedure can only be run from a MODEL object.")
    stop
    endif


' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (2) Examine the arguments

  if @len(%args) = 0 then
    @uiprompt("Error:  Procedure requires at least three arguments.")
    stop
    endif

  !nargs = @wcount(%args)
  if !nargs < 3 then
    @uiprompt("Error:  Procedure requires at least three arguments.")
    stop
    endif

  for !i = 1 to 3
    !j = !i - 1
    if @isobject(%{!j}) = 0 then
      %errstring = "Error:  mcontrol argument " + @str({!i}) + " is not the name of an existing object"
      @uiprompt(%errstring)
      stop
      else
      if {%{!j}}.@type <> "GROUP" then
        %errstring = "Error:  mcontrol argument " + @str({!i}) + " must be a group object"
        @uiprompt(%errstring)
        stop
        endif
      endif
    next

  %opt_instruments = %0
  %opt_targets = %1
  %opt_desireds = %2
  !ninstruments = {%opt_instruments}.@count
  !ntargets = {%opt_targets}.@count
  !ndesireds = {%opt_desireds}.@count  

  if !ntargets <> !ndesireds then
    @uiprompt("Error:  There must as many trajectory variables as target variables.")
    stop
    endif

  if !ntargets < !ninstruments then
    @uiprompt("Error:  There must be at least as many target variables as control variables.")
    stop
    endif

  if !nargs > 3 then
    %opt_weights = %3
    if @isobject(%3) = 0 then
      %errstring = "Error:  mcontrol argument 4 is not the name of an existing object"
      @uiprompt(%errstring)
      stop
      endif
    %w_type = {%opt_weights}.@type
    if %w_type = "GROUP" or  %w_type = "SYM" or %w_type = "MATRIX" then
      if %w_type = "SYM" or %w_type = "MATRIX" then
        if !nargs = 5 then
          if @isobject(%4) = 0 then
            %errstring = "Error:  mcontrol argument 5 is not the name of an existing object"
            @uiprompt(%errstring)
            stop
            endif
          if {%4}.@type <> "SCALAR" then
            @uiprompt("Error:  Fifth argument must be a SCALAR object.")
            stop
            endif
          !w_discount = {%4}
          else
          !w_discount = 1
          endif
        endif
      else
      @uiprompt("Error:  Fourth argument must be either a GROUP, SYM or MATRIX object.")
      stop
      endif
    if %w_type = "MATRIX" or %w_type = "SYM" then
      %tmpmat = @getnextname("work_")
      matrix {%tmpmat} = {%opt_weights}
      !symtest = (({%tmpmat} - @transpose({%tmpmat})) = 0)
      if !symtest = 0 then 
        @uiprompt("Error:  When the fourth argument is a matrix, it must be symmetric")
        stop
        endif
      delete(noerr) {%tmpmat}
      endif
    else
    %w_type = "IDENTITY"
    endif


  'check that control variables are exogenous variables or add factors
  'and that target variables are endogenous variables
  %exog_vnames = _this.@exoglist
  %adds_vnames = _this.@addfactors
  %exog_vnames = %exog_vnames + " " + %adds_vnames
  %endog_vnames = _this.@endoglist
  for !i = 1 to {%opt_instruments}.@count
    %vvv = {%opt_instruments}.@seriesname(!i)
    !cc = @wfindnc(%exog_vnames,%vvv)
    if !cc = 0 then
      %errstring = "control variable " + %vvv + " is not an exogenous variable or add factor"
      @uiprompt(%errstring)
      stop
      endif
    next
  for !i = 1 to {%opt_targets}.@count
    %vvv = {%opt_targets}.@seriesname(!i)
    !cc = @wfindnc(%endog_vnames,%vvv)
    if !cc = 0 then
      %errstring = "target variable " +  %vvv + " is not an endogenous variable"
      @uiprompt(%errstring)
      stop
      endif
    next

' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (3) Examine the options

  'default option values
  !loss_conv = .000001
  !bigmax = 15
  !littlemax = 9
  !trigger = .1
  !ptrb = .01
  %na = "no"
  %grad = "no"
  %debug = "no"
  !show = 2

  if @len(@option(1)) > 0 then
    %temp = @equaloption("c")
    if @len(%temp)>0 then
      !loss_conv = @val(%temp)
       endif
    %temp = @equaloption("m")
    if @len(%temp)>0 then
      !bigmax = @val(%temp)
      endif
    %temp = @equaloption("l")
    if @len(%temp)>0 then
      !littlemax = @val(%temp)
      endif
    %temp = @equaloption("t")
    if @len(%temp)>0 then
      !trigger = @val(%temp)
      endif
    %temp = @equaloption("p")
    if @len(%temp)>0 then
      !ptrb = @val(%temp)
      endif
    %temp = @equaloption("o")
    if @len(%temp)>0 then
      !show = @val(%temp)
      endif
    if @hasoption("na") then
      %na = "yes"
       endif
    if @hasoption("g") then
      %grad = "yes"
       endif
    if @hasoption("debug") then
      %debug = "yes"
       endif
    endif        


' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (4) Setup

  %sample = @pagesmpl
  %control_start = @wleft(%sample,1)
  %control_end = @wright(%sample,1)
  !nqtrs = @obssmpl
  !ttargets = !ntargets * !nqtrs
  !tinstruments = !ninstruments * !nqtrs
  %targetnames = {%opt_targets}.@members
  %instrunames = {%opt_instruments}.@members
  %desirednames = {%opt_desireds}.@members
  %mcontrol_work = " "


  '**************************************************************************
  ' weight matrix

  %weight_mat = @getnextname("work_")
  matrix(!ttargets,!ttargets) {%weight_mat}
  %mcontrol_work = %mcontrol_work + "weight_mat "

  %stom_mat = @getnextname("work_")
  matrix(!nqtrs,!ntargets) {%stom_mat}
  %mcontrol_work = %mcontrol_work + "stom_mat "

  if %w_type = "IDENTITY" then
    {%weight_mat} = @identity(!ttargets)
    endif

  if %w_type = "SYM" or %w_type = "MATRIX" then
    !weight_rows = @rows({%opt_weights})
    if !weight_rows <> !ntargets and !weight_rows <> !ttargets then
      %errstring = "Error:  The size of the weight matrix is " + @str(!weight_rows)
      %errstring = %errstring + " but must be either " + @str(!ntargets) + " or " + @str(!ttargets)  
      @uiprompt(%errstring)
      stop
      endif
    if !weight_rows  = !ntargets then
      %w_discount = @getnextname("work_")
      series  {%w_discount}
      %mcontrol_work = %mcontrol_work + "w_discount "

      %tmpvec = @getnextname("work_")
      vector(!nqtrs) {%tmpvec}
      %mcontrol_work = %mcontrol_work + "tmpvec "

      %tmpmat = @getnextname("work_")
      matrix(!nqtrs,!nqtrs) {%tmpmat}
      %mcontrol_work = %mcontrol_work + "tmpmat "

      %tmpser = @getnextname("work_")
      series {%tmpser}
      %mcontrol_work = %mcontrol_work + "tmpser "

      smpl @all
      {%w_discount} = 1
      smpl %control_start + 1 %control_end
      {%w_discount} = !w_discount * {%w_discount}(-1)
      smpl %control_start %control_end
      for !j = 1 to !ntargets
        for !k =1 to !ntargets
          series {%tmpser} = {%opt_weights}(!j,!k) * {%w_discount}
          stom({%tmpser},{%tmpvec})
          matrix {%tmpmat} = @makediagonal({%tmpvec})
          matplace({%weight_mat},{%tmpmat},1+!nqtrs*(!j-1),1+!nqtrs*(!k-1))
          next
        next

      else
      {%weight_mat} = {%opt_weights}
      endif
    endif

  if %w_type = "GROUP" then
    if {%opt_weights}.@count <> !ntargets then
      @uiprompt("The number of weight series does not equal the number of target series")
      stop
      endif
    smpl {%control_start} {%control_end}
    {%weight_mat} = @makediagonal(@vec(@convert({%opt_weights})))
    endif

  !rank_weights = @rank({%weight_mat})
  if !rank_weights <> !ntargets*!nqtrs then
    @uiprompt("The weight matrix does not have full rank")
    stop
    endif
  


  '**************************************************************************
  ' desired trajectories -- check for NAs

  %desired_vec = @getnextname("work_")
  matrix(!ttargets,1) {%desired_vec} 
  %mcontrol_work = %mcontrol_work + "desired_vec "

  %na_mat = @getnextname("work_")
  matrix(!nqtrs,!ntargets) {%na_mat} = NA
  %mcontrol_work = %mcontrol_work + "na_mat "

  smpl {%control_start} {%control_end}
  stomna({%opt_desireds},{%stom_mat})
  {%desired_vec} = @vec({%stom_mat})

  'check for NAs
  !na_switch = 0
  if @sum(@eeqna({%stom_mat},{%na_mat})) > 0 then  
    if %na = "no" then
      %errstring = "NAs are permitted in the desired trajectories only when "
      %errstring = %errstring + "the na option is included"
      @uiprompt(%errstring)
      stop
      else
      !na_switch = 1
      endif
    endif


  '**************************************************************************
  ' desired trajectories -- NAs are present and permitted

  %not_na = @getnextname("work_")
  vector(!ttargets) {%not_na} = 1
  %mcontrol_work = %mcontrol_work + "not_na "

  if !na_switch > 0 then
  ' 1. locate trajectory observations that are NAs and replace them with -9999
    for !i = 1 to !nqtrs
      for !j = 1 to !ntargets
        if {%stom_mat}(!i,!j) = NA then
          {%not_na}((!j-1)*!nqtrs+!i) = 0
          {%desired_vec}((!j-1)*!nqtrs+!i) = -9999
          endif
        next
      next

  ' 2. determine which NA case applies
  '    case 1:  same number of instruments and targets (before adjusting for NAs);
  '             => reduce the number of instruments 
  '    case 2:  fewer instruments than targets (before adjusting for NAs);
  '             => make sure that the number of instruments is less than
  '                the reduced the number of targets 
    !ttargets = @sum({%not_na})  'adjusted number of targets
    if  !tinstruments = (!ntargets*!nqtrs) then
      !na_switch = 1 
      !tinstruments = !ttargets
      else
      !na_switch = 2
      if !tinstruments > !ttargets then
        %errstring = "Error:  Too many control variables.  The number of control variables "
        %errstring = %errstring + "is less than the number of instruments unadjusted for NAs "
        %errstring = %errstring + "but not less than the adjusted number of instruments."
        @uiprompt(%errstring)
        stop
        endif
      endif

  ' 3. create index of locations of not-NA target values, and shrink weight matrix

    %not_na_rows = @getnextname("work_")
    vector(!ttargets) {%not_na_rows} 
    %mcontrol_work = %mcontrol_work + "not_na_rows "

    %weight_mat_na = @getnextname("work_")
    matrix(!ttargets,!ttargets) {%weight_mat_na}
    %mcontrol_work = %mcontrol_work + "weight_mat_na "

    !counter = 1
    for !i = 1 to !ntargets*!nqtrs
      if {%not_na}(!i) = 1 then
        {%not_na_rows}(!counter) = !i
        !counter = !counter + 1  
        endif
      next

    call mcontrol_mshrink({%weight_mat},{%weight_mat_na},{%not_na_rows},{%not_na_rows})
    matrix(!ttargets,!ttargets) {%weight_mat} = {%weight_mat_na}
 
    if !na_switch = 2 then
      %not_na_cols = @getnextname("work_")
      vector(!tinstruments) {%not_na_cols} 
      %mcontrol_work = %mcontrol_work + "not_na_cols "

      for !i = 1 to !tinstruments
        {%not_na_cols}(!i) = !i
        next
      endif
    endif

 

  '**************************************************************************
  ' create additional matrix/vector objects whose size is not reduced by NAs

  %derivs = @getnextname("work_")
  matrix {%derivs} = @filledmatrix(!ninstruments*!nqtrs,!ntargets*!nqtrs,0)
  %mcontrol_work = %mcontrol_work + "derivs "

  %loss_vec = @getnextname("work_")
  vector(!bigmax+1) {%loss_vec}
  %mcontrol_work = %mcontrol_work + "loss_vec "

  %direction = @getnextname("work_")
  vector( !ninstruments*!nqtrs) {%direction} = 0
  %mcontrol_work = %mcontrol_work + "direction "

  %gap_vec = @getnextname("work_")
  vector(!ntargets*!nqtrs) {%gap_vec} 
  %mcontrol_work = %mcontrol_work + "gap_vec "

  %gap_vec_p = @getnextname("work_")
  vector(!ntargets*!nqtrs) {%gap_vec_p} 
  %mcontrol_work = %mcontrol_work + "gap_vec_p "

  %perturb_mat = @getnextname("work_")
  matrix {%perturb_mat} = @filledmatrix(!nqtrs,!ninstruments,!ptrb)
  %mcontrol_work = %mcontrol_work + "perturb_mat "

  %target_vec = @getnextname("work_")
  matrix(!ntargets*!nqtrs,1) {%target_vec} 
  %mcontrol_work = %mcontrol_work + "target_vec "

  %temp_adj = @getnextname("work_")
  vector(!nqtrs) {%temp_adj}
  %mcontrol_work = %mcontrol_work + "temp_adj "

  %temp_ser = @getnextname("work_")
  series {%temp_ser}
  %mcontrol_work = %mcontrol_work + "temp_ser "


  '**************************************************************************
  ' create additional matrix/vector objects whose size depends on number of NAs

  %target_dvec = @getnextname("work_")
  matrix(!ttargets,1) {%target_dvec} 
  %mcontrol_work = %mcontrol_work + "target_dvec "

  %gradient = @getnextname("work_")
  matrix(!tinstruments,1) {%gradient}
  %mcontrol_work = %mcontrol_work + "gradient "

  %hessian = @getnextname("work_")
  matrix(!tinstruments,!tinstruments) {%hessian}
  %mcontrol_work = %mcontrol_work + "hessian "

  %hessinv = @getnextname("work_")
  matrix(!tinstruments,!tinstruments) {%hessinv}
  %mcontrol_work = %mcontrol_work + "hessinv "

  if !na_switch > 0  then
    %derivs_na = @getnextname("work_")
    matrix {%derivs_na} = @filledmatrix(!tinstruments,!ttargets,0)
    %mcontrol_work = %mcontrol_work + "derivs_na "

    %gap_vec_na = @getnextname("work_")
    vector(!ttargets) {%gap_vec_na} 
    %mcontrol_work = %mcontrol_work + "gap_vec_na "

    %gap_vec_p_na = @getnextname("work_")
    vector(!ttargets) {%gap_vec_p_na} 
    %mcontrol_work = %mcontrol_work + "gap_vec_p_na "

    %direction_na = @getnextname("work_")
    vector(!tinstruments) {%direction_na} = 0
    %mcontrol_work = %mcontrol_work + "direction_na "
    endif


  '**************************************************************************
  ' set up table of iteration-by-iteration statistics

  if @isobject("mcontrol_stats") then
    delete mcontrol_stats
    endif
  table(!bigmax+2,7) mcontrol_stats
  mcontrol_stats.setwidth(1:7) 12
  mcontrol_stats.setlines(a2:g2) +b
  setcell(mcontrol_stats,1,1,"iteration")
  setcell(mcontrol_stats,1,2,"f(x)")
  setcell(mcontrol_stats,1,3,"line search")
  setcell(mcontrol_stats,1,3,"step size")
  setcell(mcontrol_stats,1,4,"convergence")
  setcell(mcontrol_stats,2,4,"statistic")
  setcell(mcontrol_stats,1,5,"linearity")
  setcell(mcontrol_stats,2,5,"statistic")
  setcell(mcontrol_stats,1,6,"calculate")
  setcell(mcontrol_stats,2,6,"deriv's")
  setcell(mcontrol_stats,1,7,"predicted")
  setcell(mcontrol_stats,2,7,"f(x)")


  '**************************************************************************
  ' information text file

  if @isobject("mcontrol_text") then
    delete mcontrol_text
    endif
  text mcontrol_text
  %temp = _this.@name
  mcontrol_text.append Model name = {%temp}
  mcontrol_text.append Simulation start = {%control_start}
  mcontrol_text.append Simulation end   = {%control_end}
  mcontrol_text.append Convergence criteria = {!loss_conv}
  mcontrol_text.append Maximum number of iterations = {!bigmax}
  mcontrol_text.append Maximum number of line search steps = {!littlemax}
  mcontrol_text.append Initial instrument perturbation factor = {!ptrb}
  mcontrol_text.append Nonlinearity threshhold = {!trigger}
  mcontrol_text.append Control variables  = {%instrunames}
  mcontrol_text.append Target variables  = {%targetnames}
  mcontrol_text.append Trajectory variables  = {%desirednames}
  if !na_switch > 0  then
    mcontrol_text.append The trajectory variables contain permissable NAs
    if !na_switch = 1 then
      mcontrol_text.append NA case 1:  An equal number of control variables are dropped
      else
      mcontrol_text.append NA case 2:  No control variables are dropped
      endif
    endif
  mcontrol_text.append There are {!tinstruments} control and {!ttargets} target observations
  if %w_type = "GROUP" then
    %weightnames = {%opt_weights}.@members
    mcontrol_text.append Loss function weights are given by series = {%weightnames}
    endif
  if %w_type = "SYM" or %w_type = "MATRIX" then
    mcontrol_text.append Matrix {%opt_weights} used for loss function weights
    if !weight_rows = !ntargets then
      mcontrol_text.append The weight matrix contains first period weights
      mcontrol_text.append Subsequent weights use the discount factor {!w_discount}
      else
      mcontrol_text.append The weight matrix contains weights for all periods
      endif
    endif
  if %w_type = "IDENTITY" then
    mcontrol_text.append Identity matrix used for loss function weights
    endif
  if %grad = "no" then
    mcontrol_text.append Gradients calculated when needed
    endif
  if %grad = "yes" then
    mcontrol_text.append Gradients calculated every iteration
    endif
  if %hess_type = "lq" then
    mcontrol_text.append Hessian based on assumption that model is linear
    endif


  '**************************************************************************
  ' table of matrix and vector names

  if @isobject("mcontrol_work") then
    delete mcontrol_work
    endif
  table(10,2) mcontrol_work

  for !i = 1 to @wcount(%mcontrol_work)
    %abc = @word(%mcontrol_work,!i)
    mcontrol_work(!i,1) = %abc
    %bcd = "%" + %abc
    mcontrol_work(!i,2) = {%bcd}
    next


  '**************************************************************************
  ' initialize counters and switches

  !bigtry = 0
  !littletry = 0
  %converge = "no"
  %redo = "no"
  !nonlin = 0
  !pchloss = 100
  !zero_loss = 0

    

  '**************************************************************************
  ' determine whether optimal loss is zero and shortcut formulas can be used

  if !tinstruments = !ttargets then
    !zero_loss = 1
    endif



' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (5) iterations
  smpl %control_start %control_end
  while !bigtry <= !bigmax and %converge = "no"

    if !bigtry = 0 then
      'preliminary solution
      !step = 0
      !step_prev = 0
      call mcontrol_solvit
      endif


    if !bigtry > 0 then

      '*******************************
      'instrument derivatives
      
      'instrument derivatives are computed every iteration if
      '(a) %grad = "yes"
      '
      'otherwise, instrument derivatives are computed on selected iterations if 
      'any of the following are true
      '(a) it's the first iteration
      '(b) nonlinearity is present (!nonlin)
      '(c) on the previous iteration, the loss value did not decrease at the smallest step size
      '    and derivatives were not up to date (%redo)

      if %grad="yes" or !bigtry=1 or @abs(!nonlin)>!trigger or %redo="yes" then
        call mcontrol_derivs
        if %redo = "yes" then
          %redo = "no"
          endif
        endif


      '*******************************
      'hessian, gradient and direction of instrument adjustments

      if !zero_loss = 0 then
        if mcontrol_stats(!bigtry+3,6) = "yes" then 'recompute hessian only when derivs are new
          if !na_switch = 0 then
            {%hessian} = 2*{%derivs}*{%weight_mat}*@transpose({%derivs})
            else
            if !na_switch = 1 then
              call mcontrol_mshrink({%derivs},{%derivs_na},{%not_na_rows},{%not_na_rows})
              else
              call mcontrol_mshrink({%derivs},{%derivs_na},{%not_na_cols},{%not_na_rows})
              endif
            {%hessian} =  2*{%derivs_na}*{%weight_mat}*@transpose({%derivs_na})
            endif
          !rank_hess = @rank({%hessian})
          if !rank_hess <> !tinstruments then
            %errstring = "Hessian is singular at iteration " + @str(!bigtry) + ". "
            %errstring = %errstring + "This may be caused by a control variable "
            %errstring = %errstring + "in one or more periods having no effect on "
            %errstring = %errstring + "any target variable."
            @uiprompt(%errstring)
            stop
            endif
            {%hessinv} = @inverse({%hessian}) 
          endif
        if !na_switch = 0 then
          {%gradient} = 2*{%derivs}*{%weight_mat}*{%gap_vec}
          {%direction} = {%hessinv}*{%gradient}
          else
          {%gradient} = 2*{%derivs_na}*{%weight_mat}*{%gap_vec_na}
          if !na_switch = 1 then
            {%direction_na} = {%hessinv}*{%gradient}
            call mcontrol_vexpand({%direction_na},{%direction},{%not_na_rows})
            else
            {%direction} = {%hessinv}*{%gradient}
            endif
          endif
        endif

      if !zero_loss = 1 then
        if mcontrol_stats(!bigtry+3,6) = "yes" then 'recompute hessian only when derivs are new
          if !na_switch = 0 then
            {%hessian} = 2*@transpose({%derivs})
            else
            if !na_switch = 1 then
              call mcontrol_mshrink({%derivs},{%derivs_na},{%not_na_rows},{%not_na_rows})
              else
              call mcontrol_mshrink({%derivs},{%derivs_na},{%not_na_cols},{%not_na_rows})
              endif
            {%hessian} =  2*@transpose({%derivs_na})
            endif
          !rank_hess = @rank({%hessian})
          if !rank_hess <> !tinstruments then
            %errstring = "Hessian is singular at iteration " + @str(!bigtry) + ". "
            %errstring = %errstring + "This may be caused by a control variable "
            %errstring = %errstring + "in one or more periods having no effect on "
            %errstring = %errstring + "any target variable."
            @uiprompt(%errstring)
            stop
            endif
            {%hessinv} = @inverse({%hessian}) 
          endif
        if !na_switch = 0 then
          {%gradient} = 2*{%gap_vec}
          {%direction} = {%hessinv}*{%gradient}
          else
          {%gradient} = 2*{%gap_vec_na}
          if !na_switch = 1 then
            {%direction_na} = {%hessinv}*{%gradient}
            call mcontrol_vexpand({%direction_na},{%direction},{%not_na_rows})
            else
            {%direction} = {%hessinv}*{%gradient}
            endif
          endif
        endif



      '*******************************
      'compute predicted loss assuming that hessian and gradient are exact
      {%gap_vec_p} = {%gap_vec} - @transpose({%derivs}) * {%direction}
      if !na_switch = 0 then
        !nloss_p = @sum(@transpose({%gap_vec_p})*{%weight_mat}*{%gap_vec_p})
        else
        call mcontrol_vshrink({%gap_vec_p},{%gap_vec_p_na},{%not_na_rows})
        !nloss_p = @sum(@transpose({%gap_vec_p_na})*{%weight_mat}*{%gap_vec_p_na})
        endif
      mcontrol_stats(!bigtry+3,7) = !nloss_p

      '*******************************
      'solve model and compute actual loss (for step size = 1)
      !step = 1
      !step_prev = 0
      call mcontrol_solvit
      !loss_step1 = !nloss
      
      '*******************************
      '!nonlin is the ratio of the actual to predicted percentage reduction in loss, less 1.0;
      'the closer the model is to being linear, the closer !nonlin is to zero
      !ddloss = ({%loss_vec}(!bigtry)-{%loss_vec}(!bigtry+1))
      if !ddloss <> 0 then
        !nonlin = ({%loss_vec}(!bigtry+1)-!nloss_p) / !ddloss
        else
        !nonlin = 100
        endif
      mcontrol_stats(!bigtry+3,5) = !nonlin


      '*******************************
      'search for a better a step size (ie, line search) if:
      '
      '(a) the model appears to be significantly nonlinear as measured by 
      '    the ratio of actual loss reduction to predicted loss reduction,
      '    in which case the search first examines whether to increase or
      '    decrease the step size from 1.0;
      '
      '(b) or the actual loss with step size of 1.0 is higher than the loss at
      '    the previous iteration, in which case the step size is increased
      '    from a value of 0.
      '
      !line_flag = 0 
      if {%loss_vec}(!bigtry+1) > {%loss_vec}(!bigtry) then
        !line_flag = 1
        else
        if @abs(!nonlin) > !trigger then
          !line_flag = 2
          endif
        endif

      '(a) current loss is less than previous loss, but some nonlinearity is observed
      if !line_flag = 2 then
        !up = 1.25
        !down = .67
       
        'choose between increasing or reducing step size, or keeping it the same
        !up_down = 0
        !step_prev = 1.0
        !step = !up
        call mcontrol_solvit
        !loss_new = {%loss_vec}(!bigtry+1)
        if (!loss_new < !loss_step1) then
          !up_down = 1
          else
          !step_prev = !step
          !step = !down
          call mcontrol_solvit
          !loss_new = {%loss_vec}(!bigtry+1)
          if (!loss_new < !loss_step1) then
            !up_down = -1
            endif
          endif
 
        if !up_down = 0 then
          !step_prev = !step
          !step = 1.0
          call mcontrol_solvit
          endif
 
        if !up_down <> 0 then
          !ppp = (!up_down = 1)*!up + (!up_down = -1)*!down
          %exitloop = "no"
          !loss_prev = {%loss_vec}(!bigtry+1)
          !littletry = 0
          while !littletry <= !littlemax and %exitloop = "no"
            !littletry = !littletry + 1
            !step_prev = !step
            !step = !ppp^({!littletry}+1)
            call mcontrol_solvit
            !loss_new = {%loss_vec}(!bigtry+1)
            if (!loss_new > !loss_prev) then
              %exitloop = "yes"
              !optim_step =  !ppp^{!littletry}
              endif
            !loss_prev = !loss_new
            wend
          if !littletry < !littlemax then
            !step_prev = !step
            !step = !optim_step
            call mcontrol_solvit
            endif
          endif
        endif


      '(b) current loss is greater than previous loss
      '=> work up in even increments from a very small step size 
      if !line_flag = 1 then
        !step_prev = 1.0
        !step = .01
        !increment = .05
        call mcontrol_solvit
        if {%loss_vec}(!bigtry+1) <  {%loss_vec}(!bigtry) then
          !loss_prev = {%loss_vec}(!bigtry+1)
          %exitloop = "no"
          !littletry = 0
          while !littletry <= !littlemax and %exitloop = "no"
            !littletry = !littletry + 1
            !step_prev = !step
            !step = !step_prev + !increment
            call mcontrol_solvit
            !loss_new = {%loss_vec}(!bigtry+1)
            if (!loss_new > !loss_prev) then
              %exitloop = "yes"
              !optim_step =  !step_prev
              endif
            !loss_prev = !loss_new
            wend
          if !littletry < !littlemax then
            !step_prev = !step
            !step = !optim_step
            call mcontrol_solvit
            endif
          endif
        endif



      '*******************************
      'test for convergence

      if !zero_loss = 1 then

        'equal number of targets and controls, full rank derivative matrix
        ' => loss has to be less than !loss_conv
        mcontrol_stats(!bigtry+3,4) =  {%loss_vec}(!bigtry+1)
        if {%loss_vec}(!bigtry+1) < !loss_conv then
          %converge = "yes"
          endif

        else
        'percentage change in loss from previous iteration has to be less than !loss_conv
        !pchloss =  1-({%loss_vec}(!bigtry+1)/{%loss_vec}(!bigtry))
        mcontrol_stats(!bigtry+3,4) =  !pchloss
        if !pchloss < 0 then
          mcontrol_text.append At iteration {!bigtry}, loss is increasing at smallest step size
          if mcontrol_stats(!bigtry+3,6) = "yes" then
            %converge = "yes"
            mcontrol_text.append At iteration {!bigtry}, convergence assumed because derivatives are up to date
            else
            mcontrol_text.append At iteration {!bigtry}, continuing because derivatives are not up to date
            %redo = "yes"
            endif
          else
          if !pchloss < !loss_conv then
            %converge = "yes"
            mcontrol_text.append At iteration {!bigtry}, convergence
            endif
          endif
        endif
      endif

    if !bigtry = 0 and !nloss = 0 then
      %converge = "yes"
      mcontrol_text.append At iteration {!bigtry}, convergence
      endif

    if !bigtry = !bigmax then
      mcontrol_text.append At iteration {!bigtry}, no convergence in {!bigmax} iterations
      !continue = @uiprompt("Maximum number of iterations reached:  Continue execution?","YN")
         if !continue = 2 then
           stop
           endif
      endif
    !bigtry = !bigtry + 1
    wend

' ******************************************************************
' ******************************************************************
' ******************************************************************
' ******************************************************************
' (6) Final tasks

  statusline mcontrol finished

  if !show = 2 then
    close mcontrol_stats
    endif

  if !show = 1 or !show = 2 then
    if @isobject("mcontrol_spool") then
      delete mcontrol_spool
      endif
    spool mcontrol_spool
    mcontrol_spool.append mcontrol_stats
    mcontrol_spool.append mcontrol_text
    mcontrol_spool.name untitled01 mcontrol_stats
    mcontrol_spool.name untitled02 mcontrol_text
    show mcontrol_spool
    endif

  if %debug = "no" then
    for !i = 1 to @wcount(%mcontrol_work)
      %abc = @word(%mcontrol_work,!i)
      %bcd = "%" + %abc
      delete(noerr) {%bcd}
      next
    else
    mcontrol_spool.append mcontrol_work
    mcontrol_spool.name untitled03 mcontrol_work
    show mcontrol_spool
    endif

'****************************************************************
'****************************************************************
'****************************************************************
subroutine mcontrol_derivs
 

'This subroutine computes the derivatives of the target variables wrt the instruments
' (if !na_switch = 1, derivatives are skipped for an instrument in any period 
' that its corresponding target has a desired value of NA)

  mcontrol_stats(!bigtry+3,6) = "yes"

  if !bigtry > 1 then
    {%perturb_mat} = @abs(@unvec(!step*{%direction},!nqtrs)) + 1e-6
    endif

  smpl %control_start %control_end
  {%target_vec} = @vec(@convert({%opt_targets}_sols))

  '************************************
  'derivatives loop  
  statusline computing instrument derivatives at iteration !bigtry
  for !i = 1 to !ninstruments
    %instru_name = {%opt_instruments}.@seriesname(!i)
    for !j = 1 to !nqtrs
      if !na_switch = 1 and {%not_na}((!i-1)*!nqtrs+!j) = 0 then
        else
        !perturbit =  {%perturb_mat}(!j,!i)
        smpl %control_start + !j-1 %control_start + !j-1
        {%instru_name} = {%instru_name} + !perturbit
        smpl %control_start %control_end
        _this.solve
        {%target_dvec} = @vec(@convert({%opt_targets}_sols))
        matplace({%derivs},@transpose(({%target_dvec}-{%target_vec})/!perturbit),(!i-1)*!nqtrs+!j,1)
        smpl %control_start + !j-1 %control_start + !j-1
        {%instru_name} = {%instru_name} - !perturbit
        endif 
      next
    next

  smpl %control_start %control_end



endsub


'****************************************************************
'****************************************************************
'****************************************************************
subroutine mcontrol_solvit

' This subroutine first sets the instrument values, based on the current
' optimal direction and choice of step size, and then solves the model

  statusline mcontrol solution, iteration !bigtry
  smpl %control_start %control_end

  'compute instrument values based on current direction and step size
  if !bigtry > 0 then
    mcontrol_stats(!bigtry+3,3) = !step
    for !i = 1 to !ninstruments
      {%temp_adj} = @subextract({%direction},(!i-1)*!nqtrs+1,1,!i*!nqtrs,1)
      mtos({%temp_adj},{%temp_ser})
      %y1 = {%opt_instruments}.@seriesname(!i)
      {%y1} = {%y1} - (!step-!step_prev)*{%temp_ser}
      next
    endif

  'solve model
  _this.solve

  if !bigtry = 0 then
    'identify active scenario solution alias
    %endog_base = @word(_this.@endoglist,1)
    %endog_active = @word(_this.@endoglist("@active"),1)
    %sufactive = @mid(%endog_active,@len(%endog_base) + 1)
    mcontrol_text.append scenario aliasing suffix   = {%sufactive}
    %targetsols = @wcross(%targetnames,%sufactive)
    group {%opt_targets}_sols {%targetsols}
    endif

  'compute value of loss function
  {%target_vec} = @vec(@convert({%opt_targets}_sols))
  {%gap_vec} = {%target_vec} - {%desired_vec}
  if !na_switch = 0 then
    !nloss = @sum(@transpose({%gap_vec})*{%weight_mat}*{%gap_vec})
    else
    call mcontrol_vshrink({%gap_vec},{%gap_vec_na},{%not_na_rows})
    !nloss =  @sum(@transpose({%gap_vec_na})*{%weight_mat}*{%gap_vec_na})
    endif
  mcontrol_stats(!bigtry+3,1) = !bigtry
  mcontrol_stats(!bigtry+3,2) = !nloss
  {%loss_vec}(!bigtry+1) = !nloss
  
  if !show = 2 then
    show mcontrol_stats
    endif

endsub


'****************************************************************
'****************************************************************
'****************************************************************
subroutine local mcontrol_mshrink(matrix mat_in, matrix mat_out, vector row_index, vector col_index)

' Forms mat_out from the intersection of those rows and columns of mat_in 
' given by the positive, non-zero elements of row_index and col_index.  
' Rows and columns may be repeated.

  !qrows = @rows(row_index)
  !qcols = @rows(col_index)
  !zrows = @rows(mat_in)
  !zcols = @columns(mat_in)
  vector(!qrows) zero_rows = 0
  vector(!qcols) zero_cols = 0

  !xrows = @sum(@egt(row_index,zero_rows))
  !xcols = @sum(@egt(col_index,zero_cols))

  matrix(!xrows,!zcols) temp_mat

  !counter = 1
  for !ia = 1 to !qrows
    !ttt = row_index(!ia)
    if !ttt > 0 and !ttt <= !zrows then
      rowplace(temp_mat,@rowextract(mat_in,!ttt),!counter)
      !counter = !counter + 1
      else
      @uiprompt("Illegal row index in subroutine matrix_mshrink")
      stop
      endif
    next

  !counter = 1
  for !ia = 1 to !qcols
    !ttt = col_index(!ia)
    if !ttt > 0 and !ttt <= !zcols then
      colplace(mat_out,@columnextract(temp_mat,!ttt),!counter)
      !counter = !counter + 1
      else
      @uiprompt("Illegal column index in subroutine matrix_mshrink")
      stop
      endif
    next

  delete zero_rows zero_cols temp_mat

endsub


'****************************************************************
'****************************************************************
'****************************************************************
subroutine local mcontrol_vshrink(vector vec_in, vector vec_out, vector elem_index)

' Forms vec_out from the intersection of those elements of vec_in 
' given by the positive, non-zero elements of elem_index.  
' Elements may be repeated.

  !qrows = @rows(elem_index)
  !zrows = @rows(vec_in)
  vector(!qrows) zero_rows = 0

  !xrows = @sum(@egt(elem_index,zero_rows))

  vector(!xrows) vec_out

  !counter = 1
  for !ia = 1 to !qrows
    !ttt = elem_index(!ia)
    if !ttt > 0 and !ttt <= !zrows then
      vec_out(!counter) = vec_in(!ttt)
      !counter = !counter + 1
      else
      @uiprompt("Illegal element index in subroutine matrix_vshrink")
      stop
      endif
    next

  delete zero_rows

endsub


'****************************************************************
'****************************************************************
'****************************************************************
subroutine local mcontrol_vexpand(vector vec_in, vector vec_out, vector elem_index)

' Places the elements of vec_in in the locations of vec_out indexed by elem_index 
' vec_in and elem_index must be of the same length

  !qrows = @rows(elem_index)
  !zrows = @rows(vec_in)
  !xrows = @rows(vec_out)
 
  if !qrows <> !zrows then
    @uiprompt("in subroutine mcontrol_vexpand the vec_in and elem_index do not have the same length")
    stop
    endif

  !counter = 1
  for !ia = 1 to !qrows
    !ttt = elem_index(!ia)
    if !ttt > 0 and !ttt <= !xrows then
      vec_out(!ttt) = vec_in(!ia)
      !counter = !counter + 1
      else
      @uiprompt("Illegal element index in subroutine matrix_vexpand")
      stop
      endif
    next


endsub

