'-----------------------------------------------------------------------------------------------------------------------------------
'Program written by Trent Saunders and Peter Tulip
'-----------------------------------------------------------------------------------------------------------------------------------
'This is the main program for the housing model discussed in Saunders and Tulip (2019).
'This program sets up the EViews workfile and reads in the data. It then calls a succession of sub-programs.
'The program also defines the values for a number of important strings that are used in the sub-programs.
'-----------------------------------------------------------------------------------------------------------------------------------

'Set current directory to runpath
%directory = @runpath	
cd %directory				

'--------------
''Required add-ins
'--------------		
'The 'mcontrol' add-in is needed for the historical simulations in Saunders and Tulip (2019, Figures 13 and 14). These simulations are run from '9_historical_simulations.prg'. 
'The add-in might need to be re-installed if the name or location of the folder is changed after the initial install. You will also need to remove the previously installed files.
'See readme.docx for details and instructions.

%mcontrol_addin = %directory+"mcontrol_addin\mcontrol_install.prg" 	
exec %mcontrol_addin		'Uncomment this line and run the program if mcontrol is not installed. After the initial install, comment out this code. 

'--------------
' Workfile setup
'--------------

 'Name of workfile
%wfname = "housing_model"

'Run in quiet mode (this is much quicker)
mode quiet

'Specify estimation sample start/end dates (this is also last observation on most charts)
'note equations will estimate on whatever data is available.  But historical simulations will not run if %ed has missing obs.
%sd= "1983Q1" 				'Used for most equations
%sd_approvals= "1987Q1" 	'Used for approvals equations
%ed= "2018Q2" 

'Specify start and end of forecast period
%sfc = "2018Q3" 
%efc = "2025Q3"

'Read in the data 
wfclose(noerr)
wfopen(wf=%wfname, page=quarterly) "eviews_data.xlsx" "range=data_construction_activity"
import(page=quarterly, resize) "eviews_data.xlsx" range="data_housing_market"
import(page=daily) "eviews_data.xlsx" range="data_forward_rates!A11"
pageselect quarterly

'--------------
'Run historical simulations (i.e. program 9)?
'Note: Running the historical simulaitons takes a while and requires the mcontrol add-in.
'--------------
%history = "yes"
'%history = "no"

'--------------
'Include ragged edge in forecast? (i.e. make more recent observations exogenous).  Default is "no"
'Note: Forecasts will be more up-to-date with "yes", but the estimated responses/multipliers will be incorrect as the scenarios will not correspond to baseline.
'--------------
'%ragged = "yes"	'Use if you want the most up-to-date baseline projections
%ragged = "no" 	'Use if you are estimating model multipliers

'--------------
'User-specified model responses (program 6)
'--------------

'1. Variable that will be shocked
'%shock = "cash"   		'Cash rate
'%shock = "stock_no"  	'Housing stock (number of dwellings)
%shock = "rdp"   			'Dwelling prices
'%shock = "rent_cpi" 	'CPI rents
'%shock = "rinc"   		'Real income per capita
'%shock = "wap"   		'Population 
'%shock = "batotalvol"  'Total dwelling approvals. for Figure 15
'%shock = "vacancy"		'Rental vacancy rate
'%shock = "uc_appreciation"  		'Expected capital gains for Figure 16	

'2. Shock type
'%shock_type = "temp"  '4-quarter change
%shock_type = "perm"  'Permanent
'%shock_type = "ping"  '1-quarter ping, then endogenous response

'3. Size of shock (0.01 = 1% or 1bp, depending on variable)
scalar shock_size = 0.01
!temp_horizon = 4 'Length of temporary shock (in quarters)

'4. Scenario suffix
%scenario = "s"

'--------------
'Run the programs
'--------------
smpl @all

'Report progress in running programs
table(20, 1) progress
!progress_row = 0

'Data transformations
include 0_data_forward_rates			'Construct forward curve 
include 0_data_transformations			'Data transformations and adjustments

'Estimate equations and merge into a model
include 1_housing_approvals_eqns		'Estimate housing approvals equations
include 2_housing_market_eqns			'Estimate equations for housing prices, rents, rental vacancy rate, population and income
include 3_construction_mapping_eqns	'Estimate housing construction mapping equations (e.g. approvals to commencements, commencements to work done, etc)
include 4_merge_model_eqns				'Merge the different equations and identities in a model object

'Estimate projections and user-specified model multipliers 
include 5_baseline_projections			'Calculate model projections
include 6_alternative_projections		'Calculate responses to the user-specified shock and model projections

'Graph baseline projections and user-specified responses
include 7a_graph_projections			'Put together 9-panel graphs for baseline projections.
include 7b_graph_responses			'Put together 9-panel graphs for responses to user-specified shock.

'Put together graphs shown in the paper (excluding historical simulations)
include 8_graph12_cash 					'Graph 12 - Responses to percentage point reduction in interest rates
include 8_graph15_approvals			'Graph 15 - Responses to dwelling approvals
include 8_graph16_price_expectations	'Graph 16 - Responses to housing price appreciation expectations
include 8_other_graphs					'Other graphs used in the paper

'Historical simulations
include 9_historical_simulations		'Estimate historical simulations and put together graphs

'Results and documentation
'include save_graph_data					'Export graph data to Excel file (graph_data.xlsx). This takes a few minutes to run.
'include update_all_shocks				'Save responses to all shocks in workfile and 'Responses' folder
wfsave {%wfname}							'Save workfile


