'-------------------
'This program estimates the effect of the increase in population growth in the second half of the 2000s
'To assess the effects of this surge, we run a simulation in which working-age population growth continues to grow at its 2005 rate of 1.5 per cent. 
'These estimates are shown in Figure 14, Saunders and Tulip (2019)
'Program written by Trent Saunders
'-------------------

'-----------------------
'Population grows at 1.5% from 2005
'-----------------------

%scenario = "y"
%sd_scenario = "2006:1" 

'Baseline projections
'---------
'Set add-factors so that forecasts equal actual data 
smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}) {%scenario}
model.mcontrol(c=0.5) mcontrol_a mcontrol mcontrol_t
model.solve(d=d) 'Calculate the forecasts

'Set add-factors so that forecasts equal actual data 
smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}0) {%scenario}0
model.mcontrol(c=0.1) mcontrol_a mcontrol mcontrol_t
model.solve(d=d) 'Calculate the forecasts

'Set dwelling investment add-factor so that forecasts equal actual data 
'NOTE: The model fails to converge if I try to include dwelling investment in the initial solution above
smpl @all
series natdi_t = natdi

smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}1) {%scenario}1
model.control natdi_a natdi natdi_t
model.solve(d=d) 'Calculate the forecasts

'Alternative scenario
'---------

'Set population at counterfactual (Grows 1.5%)
smpl @all
series wap_t = wap
smpl %sd_scenario  %ed
series wap_t = wap_t(-1)*(1.015^0.25)

smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}2) {%scenario}2
model.control wap_a wap wap_t
model.solve(d=d) 'Calculate the forecasts

'-------------------------------------------------------------------
'Make Figure 14 - Responses to higher population
'-------------------------------------------------------------------
smpl 1990 %ed
%graph_number = "14"
!font_size = 20

'Make individual graphs
'-------------------
%n = %graph_number+"1"	'Panel 1
graph _gr_{%n}.line @pcy(wap_{%scenario}2) @pcy(wap) 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Adult population (15+) \r (year-ended growth)"

%n = %graph_number+"2"	'Panel 2
graph _gr_{%n}.line  wap_t/1000 wap/1000
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Adult population (15+)  \r (millions) "

%n = %graph_number+"3"	'Panel 3	
graph _gr_{%n}.line natdi_{%scenario}2 natdi 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling investment  \r ($ millions, chain-volume)"

%n = %graph_number+"4"	'Panel 4	
graph _gr_{%n}.line @pcy(stock_no_{%scenario}2) @pcy(stock_no) 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Number of dwellings \r (year-ended growth)"

%n = %graph_number+"5"	'Panel 5	
graph _gr_{%n}.line vacancy_{%scenario}2 vacancy 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (%)"

%n = %graph_number+"6"	'Panel 6	
graph _gr_{%n}.line  @pcy(rrent_{%scenario}2) @pcy(rrent)
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rents \r (real, year-ended growth)"

%n = %graph_number+"7"	'Panel 7	
graph _gr_{%n}.line  rrent_{%scenario}2 rrent
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rents \r (real, level)"

%n = %graph_number+"8"	'Panel 8	
graph _gr_{%n}.line  rdp_{%scenario}2/rinc_per_capita_{%scenario}2 rdp/rinc_per_capita
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling price-to-income ratio"


'Define labels and create a merge list
'------------------- 
%merge_list = ""
for !i = 1 to 8
	%n = %graph_number+@str(!i)
	_gr_{%n}.setelem(1)  legend("Simulation")  
	_gr_{%n}.setelem(2)  legend("Actual")  
	_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
	%merge_list = %merge_list+" _gr_"+%graph_number+@str(!i)
next

'Merge graphs
'------------------- 
smpl 1990  %efc
graph _gr_{%graph_number}.merge {%merge_list}
_gr_{%graph_number}.align(3,1,2.5)
_gr_{%graph_number}.draw(shade, b, gray) %sd_scenario  %ed		'Shade forecast horizon grey	
delete {%merge_list}	'Delete individual graphs
model.addinit(v=z) @all	'Re-set add factor values to zero

'Compile Graphit data
'------------------- 
group graphit_{%graph_number} date1 @pcy(wap_{%scenario}2) @pcy(wap) date2 wap_{%scenario}2/1000 wap/1000 date3 natdi_{%scenario}2/1000 natdi/1000 date4 @pcy(stock_no_{%scenario}2) @pcy(stock_no) date5 vacancy_{%scenario}2 vacancy date6 @pcy(rrent_{%scenario}2) @pcy(rrent) date7 rrent_{%scenario}2/@mean(rrent, "2005q1 2005q4")*100 rrent/@mean(rrent, "2005q1 2005q4")*100 date8  rdp_{%scenario}2/rinc_per_capita_{%scenario}2/@mean(rdp/rinc_per_capita, "2005q1 2005q4")*100 rdp/rinc_per_capita/@mean(rdp/rinc_per_capita, "2005q1 2005q4")*100 

'Re-set targets back to actuals
'------------------- 
smpl @all
for %x {%exog_variables} {%endog_variables}
	series {%x}_t = {%x}
next

'Update progress table
'------------------- 
!progress_row = !progress_row+1
progress(!progress_row,1) = "9_historical_simulations (population)"


