
'-------------------
'This program estimates the effect of the decline in interest rates from 2011 to 2018
'To do this, it runs a simulation in which interest rates and the user cost of housing are held constant from 2011Q3. 
'These estimates are shown in Figure 13, Saunders and Tulip (2019)
'Program written by Trent Saunders
'-------------------

%scenario = "x"
%sd_scenario = "2011:3" 

'Baseline projections
'---------
'Set add-factors so that forecasts equal actual data 
smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}) {%scenario}
model.mcontrol(c=0.02) mcontrol_a mcontrol mcontrol_t
model.solve(d=d) 'Calculate the forecasts

'Set dwelling investment add-factor so that forecasts equal actual data 
'NOTE: The model fails to converge if I try to include dwelling investment in the initial solution above
smpl @all
series natdi_t = natdi

smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}1) {%scenario}1
model.control natdi_a natdi natdi_t
model.solve(d=d) 'Calculate the forecasts

'Alternative scenario
'---------
'Create groups for alternative scenario
group mcontrol_a2 	
group mcontrol2 		
group mcontrol_t2

for %x cash i_10y_bond uc 
	smpl %sd_scenario  %ed
	series {%x}_t = {%x}_t(-1)	'Interest rates unchanged
	smpl @all
	'Add variables to group objects
	mcontrol_a2.add	{%x}_a
	mcontrol2.add	{%x}	
	mcontrol_t2.add	{%x}_t
next

smpl %sd_scenario  %ed
model.scenario(n,a=_{%scenario}2) {%scenario}2
model.mcontrol mcontrol_a2 mcontrol2 mcontrol_t2
model.solve(d=d) 'Calculate the forecasts

'-------------------------------------------------------------------
'Make Figure 13 - The recent fall in interest rates
'-------------------------------------------------------------------
smpl 2000 %ed
%graph_number = "13"
!font_size = 20

'Make individual graphs
'-------------------
%n = %graph_number+"1"	'Panel 1
graph _gr_{%n}.line cash_{%scenario}2 cash 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Cash rate (%)"

%n = %graph_number+"2"	'Panel 2
graph _gr_{%n}.line uc_{%scenario}2 uc 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "User cost of housing"

%n = %graph_number+"3"	'Panel 3
graph _gr_{%n}.line rdp_{%scenario}2/rinc_per_capita_{%scenario}2 rdp/rinc_per_capita 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling price-to-income ratio"

%n = %graph_number+"4"	'Panel 4
graph _gr_{%n}.line natdi_{%scenario}2 natdi
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling investment"

%n = %graph_number+"5"	'Panel 5
graph _gr_{%n}.line vacancy_{%scenario}2 vacancy 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (%)"

%n = %graph_number+"6"	'Panel 6
graph _gr_{%n}.line rrent_{%scenario}2 rrent 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real rents (%)"

'Define labels and create a merge list
'------------------- 
%merge_list = ""
for !i = 1 to 6
	%n = %graph_number+@str(!i)
	_gr_{%n}.setelem(1)  legend("Simulation")  
	_gr_{%n}.setelem(2)  legend("Actual")  
	_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)
	%merge_list = %merge_list+" _gr_"+%graph_number+@str(!i)
next

'Merge graphs
'------------------- 
graph _gr_{%graph_number}.merge {%merge_list}
_gr_{%graph_number}.align(3,1,2.5)
_gr_{%graph_number}.draw(shade, b, gray) %sd_scenario  %ed	'Shade forecast horizon grey	
delete {%merge_list}	'Delete individual graphs
model.addinit(v=z) @all	'Re-set add factors to zero

'Compile Graphit data
'------------------- 
group graphit_{%graph_number} date1 cash_{%scenario}2 cash date2 uc_{%scenario}2 uc date3 rdp_{%scenario}2/rinc_per_capita_{%scenario}2/(@mean(rdp/rinc_per_capita,"2005q1 2005q4"))*100 rdp/rinc_per_capita/(@mean(rdp/rinc_per_capita,"2005q1 2005q4"))*100 date4 natdi_{%scenario}2/1000 natdi/1000 date5 vacancy_{%scenario}2 vacancy date6  rrent_{%scenario}2/(@mean(rrent,"2005q1 2005q4"))*100  rrent/(@mean(rrent,"2005q1 2005q4"))*100 

'Re-set targets back to actuals
'------------------- 
smpl @all
for %x {%exog_variables} {%endog_variables}
	series {%x}_t = {%x}
next

'Update progress table
'------------------- 
!progress_row = !progress_row+1
progress(!progress_row,1) = "9_historical_simulations (interest rates)"


