'-------------------
'Responses to changed housing price growth expectations
'This program is used to estimate the responses in Figure 16, Saunders and Tulip (2019)
'-------------------
'IMPORTANT: Remember to turn %ragged off  in '_main_program.prg', or you will compare to the wrong baseline!
'-------------------

'Scenario settings
%shock = "uc_appreciation"   	
scalar shock_size = 0.2 - 2.637613 'Difference between new assumption (0.2) and baseline assumption (2.637613) for housing appreciation
%shock_type = "perm"	'Permanent
%scenario = "16"			'Suffix for scenario estimates
include 6_alternative_projections	'Estimate alternative scenario

'-----------------------------------------------------------------------------
'Make Figure 16 - Responses to changed price expectations
'-----------------------------------------------------------------------------

%shock_name = "User Cost and Housing Prices" 'Graph label
!font_size = 20
smpl %sfc-1 %sfc+28			'Sample for graph

'Make individual graphs
'-------------------
%n = %scenario+"1"	'Panel 1	
graph _gr_{%n}.line {%shock}_{%scenario}-{%shock}_b		'ppt shock
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Expected capital appreciation (ppt)"

%n = %scenario+"2"	'Panel 2
graph _gr_{%n}.line rdp_{%scenario}/rdp_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Housing prices (%)"

%n = %scenario+"3"	'Panel 3
graph _gr_{%n}.line @pcy(rdp_{%scenario})-@pcy(rdp_b)
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Growth in housing prices \r year-ended, ppt"

%n = %scenario+"4"	'Panel 4
graph _gr_{%n}.line batotalvol_{%scenario}/batotalvol_b*100-100 natdi_{%scenario}/natdi_b*100-100 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Approvals and investment \r constant prices, %"
_gr_{%n}.setelem(1)  legend("Dwelling approvals")  
_gr_{%n}.setelem(2)  legend("Dwelling investment")  

%n = %scenario+"5"	'Panel 5
graph _gr_{%n}.line vacancy_{%scenario}-vacancy_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (ppt)"

%n = %scenario+"6"	'Panel 6
graph _gr_{%n}.line rrent_{%scenario}/rrent_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real CPI rents (%)"

for !i = 1 to 6
	_gr_{%scenario}{!i}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)	'Set fonts
	_gr_{%scenario}{!i}.axis(left)  zeroline	'Include zero line
next

'Merge into 6-panel graph
'-------------------
graph _gr_{%scenario}.merge _gr_{%scenario}1 _gr_{%scenario}2 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6 
_gr_{%scenario}.align(3,1,2.5)	'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)
%title = "Responses to "+%shock_name+"\r Deviation from baseline level"
_gr_{%scenario}.addtext(t, font({!font_size},b), just(c))  {%title}
delete _gr_{%scenario}1 _gr_{%scenario}2 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6  'Delete individual graphs

'Compile Graphit data
'------------------- 
group graphit_{%scenario} trend1 {%shock}_{%scenario}-{%shock}_b trend2 rdp_{%scenario}/rdp_b*100-100 trend3 @pcy(rdp_{%scenario})-@pcy(rdp_b) trend4 batotalvol_{%scenario}/batotalvol_b*100-100 natdi_{%scenario}/natdi_b*100-100  trend5  vacancy_{%scenario}-vacancy_b trend6  rrent_{%scenario}/rrent_b*100-100

'Update progress table
'------------------- 
!progress_row = !progress_row+1
progress(!progress_row,1) = "8_graph15_approvals ("+ %shock +")"


