'-------------------
'Responses to percentage point reduction in interest rates 
'This program is used to estimate the responses in Figure 12, Saunders and Tulip (2019)
'-------------------
'IMPORTANT: Remember to turn %ragged off  in '_main_program.prg', or you will compare to the wrong baseline!
'-------------------

'Scenario settings
%shock = "cash"   			'Variable that will be changed
scalar shock_size = -1	'Percentage point change

'Calculate response to a permanent 100bp decline in cash rate
%shock_type = "perm"	'Permanent
%scenario = "12a"			'Suffix for scenario estimates
include 6_alternative_projections	'Estimate alternative scenario

'Calculate response to temporary 100bp decline in cash rate
%shock_type = "temp"	'Temporary
!temp_horizon = 12		'Number of quarters for temporary change
%scenario = "12b"			'Suffix for scenario estimates
include 6_alternative_projections	'Estimate alternative scenario
!temp_horizon = 4 			'Restore horizon to 4-quarter change

'-------------------------------------------------------------------
'Make Figure 12 - Response to interest rates			
'-------------------------------------------------------------------

'Create label (this is used in the graph title) and scenarios-specific sttings for shock variable 
'-------------------
%shock_name = "Cash Rate" 'Label
!font_size = 20
%scenario = "12"				'Suffix for EViews graph object
smpl %sfc-1 %sfc+28			'Sample for graph

'Make individual graphs
'-------------------
%n = %scenario+"1"	'Panel 1
graph _gr_{%n}.line {%shock}_12a-{%shock}_b	{%shock}_12b-{%shock}_b		'ppt shock
_gr_{%n}.addtext(t, font({!font_size}), just(c))  {%shock_name} (ppt)
_gr_{%n}.setelem(1)  legend("sustained")  'Put legend on first panel
_gr_{%n}.setelem(2)  legend("temporary")  
_gr_{%n}.axis(left)  zeroline	'Include zero line
_gr_{%n}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)	'Set fonts
_gr_{%n}.legend position(3,1)  -inbox

%n = %scenario+"2"	'Panel 2
graph _gr_{%n}.line uc_12a-uc_b uc_12b-uc_b 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "User cost (%)"

%n = %scenario+"3"	'Panel 3
graph _gr_{%n}.line yield_12a-yield_b  yield_12b-yield_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental yield (ppt)"

%n = %scenario+"4"	'Panel 4
graph _gr_{%n}.line rdp_12a/rdp_b*100-100 rdp_12b/rdp_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real housing prices (%)"

%n = %scenario+"5"	'Panel 5
graph _gr_{%n}.line natdi_12a/natdi_b*100-100 natdi_12b/natdi_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling investment (%)"

%n = %scenario+"6"	'Panel 6
graph _gr_{%n}.line stock_12a/stock_b*100-100 stock_12b/stock_b*100-100 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling stock - constant prices (%)"

%n = %scenario+"7"	'Panel 7
graph _gr_{%n}.line stock_no_12a/stock_no_b*100-100 stock_no_12b/stock_no_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Number of dwellings (%)"

%n = %scenario+"8"	'Panel 8
graph _gr_{%n}.line vacancy_12a-vacancy_b vacancy_12b-vacancy_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (ppt)"

%n = %scenario+"9"	'Panel 9
graph _gr_{%n}.line rrent_12a/rrent_b*100-100  rrent_12b/rrent_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real CPI rents (%)"


'Format individual graphs
'------------------- 
for !i = 2 to 9
	_gr_12{!i}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)	'Set fonts
	_gr_12{!i}.axis(left)  zeroline	'Include zero line
	_gr_12{!i}.legend -display
next

'Merge into 9-panel graph
'------------------- 

graph _gr_{%scenario}.merge _gr_121 _gr_122 _gr_123 _gr_124 _gr_125 _gr_126 _gr_127  _gr_128 _gr_129 
_gr_{%scenario}.align(3,1,2.5)	'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)
%title = "Responses to "+%shock_name+"\r Deviation from baseline level"
_gr_{%scenario}.addtext(t, font({!font_size},b), just(c))  {%title}
delete _gr_121 _gr_122 _gr_129 _gr_128 _gr_123 _gr_124 _gr_125 _gr_126 _gr_127  'Delete individual graphs

'Compile Graphit data
'------------------- 
%n = %scenario
group graphit_{%n}_1 trend1 cash_12a-cash_b	cash_12b-cash_b	
group graphit_{%n}_2 trend2 uc_12a-uc_b uc_12b-uc_b 
group graphit_{%n}_3 trend3 yield_12a-yield_b  yield_12b-yield_b
group graphit_{%n}_4 trend4 rdp_12a/rdp_b*100-100 rdp_12b/rdp_b*100-100 
group graphit_{%n}_5 trend5 natdi_12a/natdi_b*100-100  natdi_12b/natdi_b*100-100
group graphit_{%n}_6 trend6 stock_12a/stock_b*100-100  stock_12b/stock_b*100-100 
group graphit_{%n}_7 trend7 stock_no_12a/stock_no_b*100-100 stock_no_12b/stock_no_b*100-100 
group graphit_{%n}_8 trend8 vacancy_12a-vacancy_b  vacancy_12b-vacancy_b
group graphit_{%n}_9 trend9 rrent_12a/rrent_b*100-100  rrent_12b/rrent_b*100-100

group graphit_{%n} graphit_{%n}_1 graphit_{%n}_1 graphit_{%n}_2 graphit_{%n}_3 graphit_{%n}_4 graphit_{%n}_5 graphit_{%n}_6 graphit_{%n}_7 graphit_{%n}_8 graphit_{%n}_9
delete graphit_{%n}_*

'Update progress table
'------------------- 
!progress_row = !progress_row+1
progress(!progress_row,1) = "8_graph12_cash ("+ %shock +")"


