'-------------------
'Make response graphs
'Program written by Trent Saunders
'-------------------
'Remember to turn %ragged off -- or you will compare to the wrong baseline

'1. Create label (this is used in the graph title)and scenarios-specific sttings for shock variable 
'------------------- 

smpl %sfc-1 %efc

if %shock =  "cash" then 
	%shock_name = "Cash rate"
smpl %sfc-1 2025q4
endif
if %shock = "rdp" then 
	%shock_name = "Real dwelling price"
endif
if %shock = "rinc"  then 
	%shock_name = "Real income"
endif
if %shock = "wap" then 
	%shock_name = "Working-age population"
endif

if %shock = "rent_cpi" or %shock = "rrent"  then 
	%shock_name = "CPI rents"
endif

if %shock = "batotalvol" then 
	%shock_name = "Total housing approvals"
endif

if %shock = "bahousevol" then 
	%shock_name = "Detached house approvals"
endif

if %shock = "baothervol" then 
	%shock_name = "Higher-density housing approvals"
endif

if %shock = "stock_no" then 
	%shock_name = "Number of dwellings"
endif

'2.	Make individual graphs
'------------------- 

!font_size = 20'

%n = %scenario+"1"	'Graph 1
if %shock =  "cash" or %shock =  "i_10y_bond" or %shock =  "uc" or %shock =  "vmr" or %shock =  "vacancy" or %shock =  "ahs" or %shock = "uc_appreciation" then 
	graph _gr_{%n}.line {%shock}_{%scenario}-{%shock}_b		'ppt shock
	_gr_{%n}.addtext(t, font({!font_size}), just(c))  {%shock_name} (ppt)
else
	graph _gr_{%n}.line {%shock}_{%scenario}/{%shock}_b*100-100	'percent shock
	_gr_{%n}.addtext(t, font({!font_size}), just(c))  {%shock_name} (%)
endif

%n = %scenario+"2"	'Graph 2
	graph _gr_{%n}.line bahousevol_{%scenario}/bahousevol_b*100-100 baothervol_{%scenario}/baothervol_b*100-100  baaavol_{%scenario}/baaavol_b*100-100
	_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling approvals - constant prices (%)"
	_gr_{%n}.setelem(1)  legend("Detached")  
	_gr_{%n}.setelem(2)  legend("Higher-density")  
	_gr_{%n}.setelem(3)  legend("Alterations and additions") 

%n = %scenario+"3"	'Graph 3
graph _gr_{%n}.line(x) natdi_{%scenario}/natdi_b*100-100
' (natdi_{%scenario}/rinc_{%scenario} - natdi_b/rinc_b) 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling investment (%)"

%n = %scenario+"4"	'Graph 4
graph _gr_{%n}.line stock_{%scenario}/stock_b*100-100 
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling stock - constant prices (%)"

%n = %scenario+"5"	'Graph 5
graph _gr_{%n}.line stock_no_{%scenario}/stock_no_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Number of dwellings (%)"

%n = %scenario+"6"	'Graph 6
graph _gr_{%n}.line vacancy_{%scenario}-vacancy_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (ppt)"

%n = %scenario+"7"	'Graph 7
graph _gr_{%n}.line rrent_{%scenario}/rrent_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real CPI rents (%)"

%n = %scenario+"8"	'Graph 8
graph _gr_{%n}.line rdp_{%scenario}/rdp_b*100-100
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Real housing prices (%)"

%n = %scenario+"9"	'Graph 9
graph _gr_{%n}.line yield_{%scenario}-yield_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Rental yield (ppt)"

%n = %scenario+"10"	'Graph 10
graph _gr_{%n}.line uc_{%scenario}-uc_b i_10y_bond_{%scenario}-i_10y_bond_b  rvmr_{%scenario}-rvmr_b
_gr_{%n}.addtext(t, font({!font_size}), just(c))  "Interest rates and user cost (%)"
_gr_{%n}.setelem(1)  legend("User cost of housing")  
_gr_{%n}.setelem(2)  legend("10-year Government bond yield")  
_gr_{%n}.setelem(3)  legend("Real variable mortgage rate")  
_gr_{%n}.legend position(1,0.2)  -inbox


'Format individual graphs
for !i = 1 to 10
	_gr_{%scenario}{!i}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)	'Set fonts
	_gr_{%scenario}{!i}.axis(left)  zeroline	'Include zero line
next

'2.	Merge into 9-panel graph
'------------------- 
'Slightly different order for figure 12
if %shock =  "cash" then 
	graph _gr_responses_{%scenario}.merge _gr_{%scenario}1 _gr_{%scenario}10 _gr_{%scenario}9 _gr_{%scenario}8 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6 _gr_{%scenario}7  
else
	graph _gr_responses_{%scenario}.merge _gr_{%scenario}1 _gr_{%scenario}2 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6 _gr_{%scenario}7 _gr_{%scenario}8 _gr_{%scenario}9
endif

_gr_responses_{%scenario}.align(3,1,2.5)	'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)

%title = "Responses to "+%shock_name+"\r Deviation from baseline level"
_gr_responses_{%scenario}.addtext(t, font({!font_size},b), just(c))  {%title}

'Delete individual graphs
delete _gr_{%scenario}1 _gr_{%scenario}2 _gr_{%scenario}3 _gr_{%scenario}4 _gr_{%scenario}5 _gr_{%scenario}6 _gr_{%scenario}7 _gr_{%scenario}8 _gr_{%scenario}9 _gr_{%scenario}10

'Update progress table
'--------------
if !progress_row < 10 then
	!progress_row = !progress_row+1
	progress(!progress_row,1) = "7b_graph_responses ("+ %shock +")"
endif


