
'-------------------
'Make 9-panel projection graph
'Program written by Trent Saunders
'-------------------

'1.	Make individual graphs
'------------------- 

smpl 1990 %efc
!font_size = 20

%n = "1"	'Panel 

smpl %ed+1 %efc
series sv1f_total_lr = sv1f_total_lr(-1)

smpl 1990 %efc
 graph _gr_b{%n}.line  batotalvol_b/rinc_b/100 sv1f_total_lr/100 
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Ratio of approvals to income"
_gr_b{%n}.setelem(1)  legend("Total approvals") 
_gr_b{%n}.setelem(2)  legend("1-sided trend") 
_gr_b{%n}.setelem(3)  legend("2-sided trend") 


%n = "2"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line  d(stock_no_b) d(wap_b)/(@movav(wap_b/stock_no_b,20)) 
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Excess Completions"
_gr_b{%n}.setelem(1)  legend("Net additions to the dwelling stock ('000)")  
_gr_b{%n}.setelem(2)  legend("'Underlying' household formation ('000)")  
_gr_b{%n}.axis(l) units(k) label

%n = "3"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line @pcy(natdi_b)
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Dwelling investment \r (year-ended growth)"

%n = "4"	'Panel 
smpl @all
series vac_natural = vacancy_natural*100
series vac_mean = @mean(vacancy)

smpl 1990 %efc
graph _gr_b{%n}.line vacancy_b vac_natural/100
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Rental vacancy rate (%)"
_gr_b{%n}.setelem(1) legend("Rental vacancy rate") 
_gr_b{%n}.setelem(2)  legend("Benchmark") 

%n = "5"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line @pcy(rrent_b)
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Real CPI rents \r (year-ended growth)"

%n = "6"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line cash_b i_10y_bond_b 
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Nominal interest rates (%)"
_gr_b{%n}.setelem(1)  legend("Cash rate") 
_gr_b{%n}.setelem(2)  legend("10-year government bond yield") 

%n = "7"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line  uc_b	yield_b
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "User cost and rental yield (%)"
_gr_b{%n}.setelem(1)  legend("User cost")  
_gr_b{%n}.setelem(2)  legend("Rental yield")

%n = "8"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line @pcy(rdp_b)
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Real housing prices \r (year-ended growth)"

%n = "9"	'Panel 
smpl 1990 %efc
graph _gr_b{%n}.line rdp_b
_gr_b{%n}.addtext(t, font({!font_size}), just(c))  "Real housing prices \r (level)"

'Format individual graphs
for !i = 1 to 9
	_gr_b{!i}.setfont legend(Arial,16,-b,-i,-u,-s) obs(Arial,16,-b,-i,-u,-s) axis(Arial,16,-b,-i,-u,-s)	'Set fonts
	_gr_b{!i}.axis(left)  zeroline	'Include zero line
next

'2.	Merge into 9-panel graph
'------------------- 
graph _gr_projections_b.merge _gr_b1 _gr_b2 _gr_b3 _gr_b4 _gr_b5 _gr_b6 _gr_b7 _gr_b8 _gr_b9
_gr_projections_b.align(3,1,2.5)	'OPTIONS: (number of columns, horizontal distance between graphs, vertical distance between graphs)
%title = "Baseline Projections starting in " + %sfc
_gr_projections_b.addtext(t, font({!font_size},b), just(c))   %title
_gr_projections_b.draw(shade, b, gray) %sfc %efc	'Shade forecast horizon grey	

'Delete individual graphs
delete _gr_b1 _gr_b2 _gr_b3 _gr_b4 _gr_b5 _gr_b6 _gr_b7 _gr_b8 _gr_b9

'3. Save data for Graphit
'------------------- 
group graphit_projections date1 batotalvol_b/rinc_b/100 sv1f_total_lr/100 date2 d(stock_no_b)/1000 d(wap_b)/(@movav(wap_b/stock_no_b,20))/1000 date3 @pcy(natdi_b) date4 vacancy_b vac_natural/100 date5 @pcy(rrent_b) date6  cash_b i_10y_bond_b date7 uc_b   yield_b date8 @pcy(rdp_b) date9 rdp_b


'Update progress table
!progress_row = !progress_row+1
progress(!progress_row,1) = "7a_graph_projections"

