'----------------------------------
'Estimate projections and responses for alternative scenarions
'Program written by Trent Saunders
'----------------------------------
' This is called by main program to do user-specified shocks and by 8_other_graphs.prg to do:
' -	real housing price response for figure 4b and figure 7,
' -	cash rate response for figure 6b and figure 12
'----------------------------------

'Step 1: Save temporary series with actual values 
'--------------
smpl @all
series {%shock}_temp = {%shock}
series {%shock} = {%shock}_b

if %shock = "cash" then	
	series cash_exp_temp = cash_exp 	'Save temporary series with expected cash rate variable
endif

if %shock = "batotalvol" then	
	for %v bahousevol baothervol baaavol
		series {%v}_temp  = {%v} 
		series {%v}  = {%v}_b
	next
endif

'Step 2: Adjust sample period for different shock types
'--------------
if %shock_type = "temp" then		'4-quarter shock after which shocked variable is endogenous
	smpl %sfc  %sfc + !temp_horizon - 1
	%exclude = %sfc+" "+%efc	'Use predfined path for entire forecast horizon
else
if %shock_type = "perm" then		'Permanent shock 
	smpl %sfc %last					
	%exclude = %sfc+" "+%efc 	'Use predefined path for entire forecast horizon
else
if %shock_type = "ping" then		'1-quarter ping, then endogenous response 
	smpl %sfc  %sfc
	%exclude = %sfc+" "+%sfc 	'Use predfined path for 1-quarter, then solve endogenously
endif
endif
endif

'Step 3: Define alternative scenario
'e.g. set shocked variable to alternative path then exogenise
'--------------

model.scenario(n,a=_{%scenario}) {%scenario}

if %shock = "cash" then			'Cash rate shock
	series cash_exp = cash_exp_temp + shock_size 		'Adjust expected cash rate ('cash_exp') so that there is a response of long-term rates
	model.exclude {%excludevars} 'We exclude rinc in Figure 6B
else
if %shock = "batotalvol" then		'Total housing approvals shock		
	for %v bahousevol baothervol baaavol
		series {%v}  = {%v}_b * (1 + shock_size)
	next
	model.exclude bahousevol({%exclude}) baothervol({%exclude}) baaavol({%exclude}) 	'Exclude series from model solution 
else
if %shock = "uc_appreciation" or %shock = "uc" then			'uc_appreciation is used for responses to changed price expectations, Figure 16 in Saunders and Tulip (2019)
	series {%shock}  = {%shock}_b + shock_size
	model.exclude {%shock}({%exclude})	'Exclude series from model solution
else
	series {%shock}  = {%shock}_b * (1 + shock_size )		'All other shocks 
	model.exclude {%shock}({%exclude})	'Exclude series from model solution
endif
endif
endif

'Step 4: Solve model
'--------------
smpl %sfc %efc
model.solve(d=d) 

'Step 5: Restore original series
'--------------
smpl @all
series {%shock} = {%shock}_temp	

if %shock = "cash" then		'Cash rate shock
	series cash_exp = cash_exp_temp 'Restore original series
endif

if %shock = "batotalvol" then		'Total housing approvals shock
	for %v bahousevol baothervol baaavol 'Restore original series
		series {%v}  = {%v}_temp  
	next
endif

'Update progress table
'--------------
if !progress_row < 10 then
	!progress_row = !progress_row+1
	progress(!progress_row,1) = "6_alternative_projections ("+ %shock +")"
endif


