'--------------------------------------
'Merge different equations/identies into a model object
'Program written by Trent Saunders
'--------------------------------------
smpl @all

'Create model object called 'model'
model model

'Merge equations
model.merge eq_bahousevol	'Detached house approvals
model.merge eq_baothervol		'Higher-density housing approvals
model.merge eq_baaavol			'Alterations and additions approvals
model.merge eq_vac 				'Rental vacancy rate
model.merge eq_rrent				'Real rents
model.merge eq_prices 			'Real housing prices
model.merge eq_wap				'Adult population
model.merge eq_inc				'Real income per capita

'---------------
'Interest rates and prices
'---------------

'Cash rate
series cash_exp = forward_current
model.append cash = cash_exp

'Variable mortgage rate
model.append vmr = vmr(-1) + d(cash)
model.append rvmr = vmr - ((tcpi/tcpi(-12))^(1/3)-1)*100

'10-year government bond yield
'bond yields move 1:1 with changes in the cash rate path expected over the next 10 years
smpl @all
series cash_exp_av = exp(@movav(log(cash_exp(40)),40))	'Geometric average of expected cash rate over next 10 years
model.append cash_exp_av = exp(@movav(log(cash_exp(40)),40))
model.append i_10y_bond	= i_10y_bond(-1) +	d(cash_exp_av)
'If the database has been updated, this should be equivalent to the following command
'model.append i_10y_bond	= exp(@movav(log(cash_exp(40)),40))

'User cost
model.append uc	= rvmr_exp + uc_running_cost + uc_transaction_cost + uc_depreciation - uc_appreciation
smpl @all
series average_spread= (@mean(i_10y_bond, "2004q02 2030m01") - @mean(cash, "2004q02 2030m01"))
smpl @all
model.append vmr_exp = vmr + (i_10y_bond - cash) - average_spread
model.append inf_exp = 0.9*inf_exp(-1) + 0.1*(((tcpi/tcpi(-4))^(1/1)-1)*100)			
model.append rvmr_exp =  (1+vmr_exp/100)/(1+inf_exp/100)*100-100
model.append uc_appreciation = uc_appreciation(-1)
model.append uc_depreciation = uc_depreciation(-1)
model.append uc_transaction_cost = uc_transaction_cost(-1)
model.append uc_running_cost = uc_running_cost(-1) 	

'CPI inflation (trimmed-mean)
model.append dlog(tcpi) = 0.30*dlog(tcpi(-1)) + 0.25*dlog(tcpi(-2)) + 0.20*dlog(tcpi(-3)) + 0.15*dlog(tcpi(-4)) + 0.1*0.025/4	
model.append inf_3y = (log(tcpi) - log(tcpi(-12))) / 12	'3-year average

'Rents
model.append rrent = rent_cpi / tcpi	'Real rents			
model.append yield =  rrent / rdp * yield_adj * 100	'Scaled to average of Corelogic and REIA's rental yield data

'---------------
'Construction mapping equations and identities
'---------------

'Dwelling stock
model.append comptotalno = comphouseno+compotherno

'Dwelling stock
model.append stock_no = stock_no(-1) + comptotalno * (1 - demolition_rate)
model.append stock = stock(-1)*(1 - depreciation_rate) + natdi
model.append demolition_rate =  @movav(demolition_rate(-1),20) 
model.append depreciation_rate = @movav(depreciation_rate(-1),4)
model.append replacement_rate =  depreciation_rate*stock/natdi

'Average volume and number of approvals	--Detached houses
%x = @str(8)			' x-quarter average of average volume-to-income ratio
%sample = %ed+"-"+%x+" "+%ed
model.append dlog(bahouseavol)  = lambda_house*(log(bahouseavol(-1)/(rinc(-1)/wap(-1))) - @mean(log(bahouseavol(-1)/(rinc(-1)/wap(-1))),%sample)) + lr_inc_per_wap
model.append bahouseno  = bahousevol  / bahouseavol  * 1000
smpl @all

'Average volume and number of approvals	-- Higher-density housing
%x = @str(8)			' x-quarter average of average volume-to-income ratio
%sample = %ed+"-"+%x+" "+%ed
model.append dlog(baotheravol)  = lambda_other*(log(baotheravol(-1)/(rinc(-1)/wap(-1))) - @mean(log(baotheravol(-1)/(rinc(-1)/wap(-1))),%sample)) + lr_inc_per_wap
model.append baotherno  = baothervol  / baotheravol  * 1000
smpl @all

'Loop over different components 
for %x house other aa
	model.append sv1s_{%x} = sv1s_{%x}(-1) 'Time-varying intercept - Smoothed (2-sided)	
	model.append sv1f_{%x} = sv1f_{%x}(-1) 'Time-varying intercept - Filtered (1-sided)
	model.merge eq_c{%x}vol						'Approvals to commencements (chain volume, private and public)
	model.merge eq_c{%x}vol_public 			'Public commencements
	model.append c{%x}vol_private = c{%x}vol - c{%x}vol_public	'Private commencements
	model.merge eq_wd{%x}vol						'Commencements to work done (private)
	model.append dlog(na{%x}vol)	= dlog(wd{%x}vol)					'Work done to investment (private)
next

'Loop over different components (excluding alts and adds)
for %x house other
	model.merge eq_c{%x}no						'Approvals to commencements (number, private and public)
	model.merge eq_comp{%x}no 				'Commencements to completions (total, number)
next

'Total dwelling approvals
model.append batotalvol = baaavol + bahousevol + baothervol
model.append batotalno = bahouseno + baotherno

'Dwelling investment 
model.append nanewvol = nahousevol + naothervol	'New (excludes alts and adds)
model.append natdi = nanewvol + naaavol		'Total (includes alts and adds)
model.merge eq_ipd_natdi							'Investment deflator
model.append natdival = natdi*ipd_natdi/100 	'Nominal dwelling investment
model.append inv_to_income = natdi/rinc		'Investment to income ratio

'---------------
'Other identities/assumptions
'---------------
model.append rinc = rinc_per_capita*wap		'Real income per capita
model.append ahs = wap/stock_no*1000		'Adults per dwelling
model.append excess_comp = (d(stock_no)-d(wap)/(@movav(wap/stock_no,4*5)))/stock_no	'Net dwelling completions
model.append d(ur) = -0.5*(dlog(rinc)-lr_inc)*100		'Unemployment rate

'Update progress table
!progress_row = !progress_row+1
progress(!progress_row,1) = "4_merge_model_eqns"


