'-----------------------------------------------------
'Specify other housing related equations
'Program written by Trent Saunders
'-----------------------------------------------------

'Population
'------------------	
smpl %sd %ed
equation eq_wap.ls(cov=white) dlog(wap) c dlog(wap(-1)) dlog(wap(-2)) 
scalar lr_wap = c(1) / (1-c(2)-c(3))

'Real income per capita
'------------------	
'equation eq_inc.ls dlog(rinc_per_capita) c dlog(rinc_per_capita(-1)) dlog(rinc_per_capita(-2)) dlog(rinc_per_capita(-3)) dlog(rinc_per_capita(-4)) gst(-1)  'Excludes effect of interest rates on income
equation eq_inc.ls(cov=white) dlog(rinc_per_capita) = c(1) + c(2)*dlog(rinc_per_capita(-1)) + c(3)*dlog(rinc_per_capita(-2)) + c(4)*dlog(rinc_per_capita(-3)) + c(5)*dlog(rinc_per_capita(-4)) + c(6)*gst(-1) - 0.0016*((rvmr(-1)-rvmr(-41))) 'Includes effect of interest rates on income (default)
scalar lr_inc_per_wap = c(1) / (1-c(2) -c(3)-c(4)-c(5)) 
scalar lr_inc = lr_wap + lr_inc_per_wap

'Vacancy rate
'------------------	
smpl %sd %ed
equation eq_vac.ls(cov=white) vacancy/100 = excess_comp + c(1)*(vacancy(-1) - c(2))/100 + vacancy(-1)/100 + c(3)*d(ur(-1)/100)
scalar vacancy_natural = c(2)
scalar benchmark_exc = -c(1)*(@mean(vacancy) - c(2))

'Rents
'------------------	
smpl %sd %ed
equation eq_rrent.ls(cov=white) dlog(rent_cpi)-inf_3y = c(1)/400 + c(2)*(vacancy(-5) - vacancy_natural )/100 + c(3)*d(vacancy(-1)/100) + c(4)*d(vacancy(-2)/100) + c(5)*d(vacancy(-3)/100) + c(6)*d(vacancy(-4)/100) + c(7)*(dlog(rent_cpi(-1))-inf_3y(-1)-c(1)/400) + c(8)*(dlog(rent_cpi(-2))-inf_3y(-2)-c(1)/400) + c(9)*((dlog(rinc)+dlog(rinc(-1)))/2-lr_inc) + c(10)*(dlog(rinc(-2))-lr_inc)

smpl @all
series lr_rrent_growth =  c(1)

''Test sum of d(vacancy) coefficients
freeze(wald_rrent_dvac) eq_rrent.wald c(3)+c(4)+c(5)+c(6)=0

'Test significance of all vacancy terms
freeze(wald_rrent_vac) eq_rrent.wald c(2)=c(3)=c(4)=c(5)=c(6)=0

''Test sum of coefficients on lagged rents
freeze(wald_rrent_lags) eq_rrent.wald c(7)+c(8)=0

''Test sum of coefficients on rinc
freeze(wald_rrent_rinc) eq_rrent.wald c(9)+c(10)=0


'Real housing prices
'------------------	
smpl %sd %ed
equation eq_prices.ls(cov=white) dlog(rdp*tcpi)-inf_3y c log(rrent(-1)/rdp(-1))-log(uc(-1)) dlog(rdp(-1)*tcpi(-1))-inf_3y(-1) d(rvmr(-1)) d(rvmr(-2)) 

'Test sum of coefficients on real mortgage rate (rvmr)
freeze(wald_prices_rvmr) eq_prices.wald c(4)+c(5)=0

'Update progress table
!progress_row = !progress_row+1
progress(!progress_row,1) = "2_housing_market_eqns"


