'------------------------------
'Baseline equations for dwelling approvals
'Program written by Trent Saunders and Peter Tulip
'------------------------------

'--------------------
'Inputs/setup
'--------------------

'State starting values
smpl 1986 1986

scalar prior_house = @mean(log(bahousevol)-log(rinc))*0.1
scalar prior_other = @mean(log(baothervol)-log(rinc))*0.2
scalar prior_aa = @mean(log(baaavol)-log(rinc))*0.2

'Setup state-space objects 
for %x house other aa
	sspace ss_{%x}
	
	'Define error terms
	ss_{%x}.append @ename e1
	ss_{%x}.append @ename e2
	
	'Define error variances and covariances
	ss_{%x}.append @evar 		var(e1) = c(111)^2
	ss_{%x}.append @evar 		var(e2) = c(112)^2
	
	'Specify initial state
	vector(1) mprior_{%x}
	mprior_{%x}(1) = prior_{%x}
	
	'Specify initial variance
	sym(1) vprior_{%x}
	vprior_{%x}(1) = @abs(prior_{%x}/10)
next

'--------------------
'Specify and estimate equations
'--------------------
'[Note: I have setup the equation specifications as a string as these specifications are also used later in the program]

smpl %sd_approvals %ed
'Detached houses (ss1)
%eqn_house = "dlog(bahousevol)-@mean(dlog(bahousevol)) =  c(1)*(log(bahousevol(-1)/rinc(-1))) + c(3)*(dlog(bahousevol(-1))-@mean(dlog(bahousevol(-1))))  + c(4)*(dlog(rdp(-1))-@mean(dlog(rdp(-1)))) + c(6)*gst +c(7)*gst(-1) +c(8)*gst(-2)   + c(9)*(d(rvmr(-1))) + c(10)*(d(rvmr(-2))) + c(11)*(d(rvmr(-3)))"
ss_house.append @signal 	{%eqn_house} + sv1 + e1
ss_house.append @state   	sv1 = sv1(-1) + e2
ss_house.append @mprior  	mprior_house
ss_house.append @vprior  	vprior_house
ss_house.append @param c(1) -0.118141 c(3) 0.217441 c(4) 1 c(5) 0.33649 c(6) -0.293692 c(7) -0.336874     c(7) 0.236874      c(9) -0.028552 c(10) -0.021939  c(11) -0.021939  c(111) -0.039305 c(112) 0.008325
ss_house.ml
scalar lambda_house = c(1) 'Save speed of adjustment as scalar (this is used in the bahouseavol equation in program 4)

'Higher-density (ss2)
%eqn_other = "dlog(baothervol)-@mean(dlog(baothervol)) = c(1)*(log(baothervol(-1)/rinc(-1))) + c(3)*(dlog(baothervol(-1))-@mean(dlog(baothervol(-1)))) + c(4)*(dlog(baothervol(-2))-@mean(dlog(baothervol(-2)))) + c(5)*gst(-1) + c(6)*gst  + c(7)*(dlog(rdp(-1))-@mean(dlog(rdp(-1)))) + c(8)*(dlog(rdp(-2))-@mean(dlog(rdp(-2))))  + c(11)*d(rvmr(-4)) + c(12)*d(rvmr(-5)) + c(13)*d(rvmr(-6))"
ss_other.append @signal 	{%eqn_other} + sv1 + e1
ss_other.append @state   	sv1 = sv1(-1) + e2
ss_other.append @mprior mprior_other
ss_other.append @vprior  vprior_other
ss_other.append @param C(1) -0.25975 C(3) -0.272525 C(4) -0.191435 C(5) -0.322412 C(6) 0  C(7) 2 C(8) 1.5 C(9) 0.5 C(10) -0.033012  C(11) -0.070647 C(12) -0.034273 C(111) -0.131149 C(112) 0.010750
smpl %sd_approvals %ed
ss_other.ml
scalar lambda_other = c(1) 'Save speed of adjustment as scalar (this is used in the baotheravol equation in program 4)

' Alts and adds (ss3)
%eqn_aa = "dlog((baaavol))-@mean(dlog((baaavol))) =  c(1)*(log((baaavol(-1))/rinc(-1))) + c(2)*(dlog((baaavol(-1)))-@mean(dlog((baaavol(-1))))) + c(4)*(dlog(rdp(-1))-@mean(dlog(rdp(-1)))) + c(5)*(dlog(rdp(-2))-@mean(dlog(rdp(-2)))) + c(6)*gst +c(7)*gst(-1)   + c(8)*d(rvmr(-1))+ c(9)*d(rvmr(-2)) + c(10)*d(rvmr(-3))"
ss_aa.append @signal 	{%eqn_aa} + sv1 + e1
ss_aa.append @state   	sv1 = sv1(-1) + e2
ss_aa.append @mprior mprior_aa
ss_aa.append @vprior  vprior_aa
ss_aa.append @param c(1) -0.25218 c(2) -0.382857 c(3) -0.161701 c(4) 0.897113 c(5) 0.209084  c(6) -0.081849 c(7) -0.301105 c(8) -0.010692  c(9) -0.011795 c(111) -0.043175 c(112) 0.006503
ss_aa.ml
scalar lambda_aa = c(1)

'-------------------------------------
'-------------------------------------
'Post-estimation evaluation 
'-------------------------------------
'-------------------------------------

'---------------
'Check convergence of estimated equations and make graphs 
'The data constructed here is used in Graph 5 in the RDP
'---------------

for %x house other aa

	'Check convergence
	scalar sconv = ss_{%x}.@stderrs(1)
	%ssname = ss_{%x}.@displayname
	if sconv = na then
		@uiprompt(%ssname+" state space model did not converge to a solution. Adjust code and try again?", "O")
		return
	endif
	delete sconv
	
	'Save time-varying intercepts
	smpl @all 
	'ss_{%x}.makestates(t=filt) sv1f_{%x} 		'Time-varying intercept (filtered)
	ss_{%x}.makestates sv1f_{%x} 		'Time-varying intercept (1-step ahead)
	ss_{%x}.makestates(t=smooth) sv1s_{%x} 'Time-varying intercept (2-sided)
	'Note: f* represents predicted state, which will differ (by one quarter) from filtered state

	'Estimate using OLS so that the equations can be appended to a model
	smpl %sd_approvals %ed
	equation eq_ba{%x}vol.ls {%eqn_{%x}} + sv1s_{%x}		'Uses 2-sided filter (this results in same coefficients as state-space equation)
	
	smpl @all
	'Scale and graph time-varying intercepts for graphs
	series sv1f_{%x}_lr = exp(sv1f_{%x}/-lambda_{%x})
	series sv1s_{%x}_lr = exp(sv1s_{%x}/-lambda_{%x})

	'Extend over forecast horizon
	smpl %sfc @last
	series sv1f_{%x}_lr = sv1f_{%x}_lr(-1)
next

'Aggregate time-varying intercept'
smpl @all
series sv1f_total_lr = sv1f_house_lr + sv1f_other_lr + sv1f_aa_lr
series sv1s_total_lr = sv1s_house_lr + sv1s_other_lr + sv1s_aa_lr

'---------------
'Put together tables with coefficient sums and Wald tests
'This is used for for Table 1 in the RDP
'---------------

'Detached houses
freeze(wald_house_rmvr) ss_house.wald c(9)+c(10)+c(11)=0
wald_house_rmvr(1,2) = "Sum of RVMR coefficients on detached"
freeze(wald_house_gst) ss_house.wald c(6)+c(7)+c(8)=0
wald_house_GST(1,2) = "Sum of GST coefficients on detached"

'Higher-density housing
freeze(wald_other_lag) ss_other.wald c(3)+c(4)=0
wald_other_lag(1,2) = "Sum of lag coefficients on high-density"
freeze(wald_other_GST ) ss_other.wald c(5)+c(6)=0
wald_other_GST (1,2) = "Sum of GST coefficients on high-density"
freeze(wald_other_rdp) ss_other.wald c(7)+c(8)=0
wald_other_rdp(1,2) = "Sum of RDP coefficients on high-density"
freeze(wald_other_rmvr) ss_other.wald c(11)+c(12)+c(13)=0
wald_other_rmvr(1,2) = "Sum of RVMR coefficients on high-density"

'Alterations and additions
freeze(wald_aa_rdp) ss_aa.wald c(4)+c(5)=0
wald_aa_rdp(1,2) = "Sum of RDP coefficients on aa"
freeze(wald_aa_GST ) ss_aa.wald c(6)+c(7)=0
wald_aa_GST (1,2) = "Sum of GST coefficients on high-density"
freeze(wald_aa_rmvr) ss_aa.wald c(8)+c(9)+c(10)=0
wald_aa_rmvr(1,2) = "Sum of RVMR coefficients on aa"

'--------------
'Construct Table 1 in RDP
'--------------
table(39,4) _table_1
_table_1(1,2) = "Detached houses"
_table_1(1,3) = "Higher density"
_table_1(1,4) = "Alts and Adds"
!row = 2

_table_1(!row,1) = "Lagged Dependent variable"
!row = !row+1

_table_1(!row,1) = "Coefficient Sum"
_table_1(!row,2) = ss_house.@coefs(2)
_table_1(!row,3) = wald_other_lag(14,3)
_table_1(!row,4) = ss_aa.@coefs(2)
!row = !row+1

_table_1(!row,1) = "stderror"
_table_1(!row,2) = ss_house.@stderrs(2)
_table_1(!row,3) = @val( wald_other_lag(14,4))
_table_1(!row,4) = ss_aa.@stderrs(2)
!row = !row+1


_table_1(!row,1) = "t-stat"
_table_1(!row,2) = ss_house.@tstats(2)
_table_1(!row,3) = @val(wald_other_lag(14,3))/@val( wald_other_lag(14,4))
_table_1(!row,4) = ss_aa.@tstats(2)
!row = !row+2

_table_1(!row,1) = "RVMR"

!row = !row+1

_table_1(!row,1) = "Coefficient Sum"
_table_1(!row,2) = wald_house_rmvr(14,3)
_table_1(!row,3) = wald_other_rmvr(14,3)
_table_1(!row,4) = wald_aa_rmvr(14,3)
!row = !row+1


_table_1(!row,1) = "std error"
_table_1(!row,2) = @val( wald_house_rmvr(14,4))
_table_1(!row,3) = @val( wald_other_rmvr(14,4))
_table_1(!row,4) = @val( wald_aa_rmvr(14,4))
!row = !row+1


_table_1(!row,1) = "t-stat"
_table_1(!row,2) = @val(wald_house_rmvr(14,3))/@val( wald_house_rmvr(14,4))
_table_1(!row,3) = @val(wald_other_rmvr(14,3))/@val( wald_other_rmvr(14,4))
_table_1(!row,4) = @val(wald_aa_rmvr(14,3))/@val( wald_aa_rmvr(14,4))
!row = !row+2

_table_1(!row,1) = "Dwelling Prices"
!row = !row+1

_table_1(!row,1) = "Coefficient Sum"
_table_1(!row,2) = ss_house.@coefs(3)
_table_1(!row,3) = wald_other_rdp(14,3)
_table_1(!row,4) = wald_aa_rdp(14,3)
!row = !row+1

_table_1(!row,1) = "stderror"
_table_1(!row,2) = ss_house.@stderrs(3)
_table_1(!row,3) = @val( wald_other_rdp(14,4))
_table_1(!row,4) = @val( wald_aa_rdp(14,4))
!row = !row+1

_table_1(!row,1) = "t-stat"
_table_1(!row,2) = ss_house.@tstats(3)
_table_1(!row,3) = @val(wald_other_rdp(14,3))/@val( wald_other_rdp(14,4))
_table_1(!row,4) = @val(wald_aa_rdp(14,3))/@val( wald_aa_rdp(14,4))
!row = !row+2

_table_1(!row,1) = "GST"
!row = !row+1

_table_1(!row,1) = "Coefficient Sum"
_table_1(!row,2) = wald_house_GST(14,3)
_table_1(!row,3) = wald_other_GST(14,3)
_table_1(!row,4) = wald_aa_GST(14,3)
!row = !row+1

_table_1(!row,1) = "stderror"
_table_1(!row,2) = wald_house_GST(14,4)
_table_1(!row,3) = @val( wald_other_GST(14,4))
_table_1(!row,4) = @val( wald_aa_GST(14,4))
!row = !row+1

_table_1(!row,1) = "t-stat"
_table_1(!row,2) = @val(wald_house_GST(14,3))/@val( wald_house_gst(14,4))
_table_1(!row,3) = @val(wald_other_GST(14,3))/@val( wald_other_gst(14,4))
_table_1(!row,4) = @val(wald_aa_GST(14,3))/@val( wald_aa_gst(14,4))
!row = !row+1

'--------------
'Stability tests on OLS versions of the equations (Quandt-Andrews)
'These results are referred to in section 4.1 of the RDP
'--------------

'Detached houses
'--------------

'Re-estmate equation so that we can easily call the coefficient values for this equation
smpl %sd_approvals %ed	
ss_house.ml

'Constrain GST dummies to full-sample effect by adusting the LHS variable. Otherwise we can't run the Quandt-Andrews test.
smpl @all			
series dlhouseadj = dlog(bahousevol) - (c(6)*gst +c(7)*gst(-1) +c(8)*gst(-2))

 'Estimate by OLS with adjusted variable  
smpl %sd_approvals %ed
equation eqn_house_ols.ls dlhouseadj  c log(bahousevol(-1)/rinc(-1)) dlog(bahousevol(-1)) dlog(rdp(-1)) d(rvmr(-1)) d(rvmr(-2)) d(rvmr(-3)) 

'Run Quandt-Andrews test 
'[NOTE: To run the test, comment out the code below. For some reason EViews will not allow you to do a test on the intercept only without using the 'prompt' command, so it's easier to leave this commented out most of the time]
'freeze(_stability_house) eqn_house_ols.ubreak(prompt) 15 @ c

'Higher-density housing
'--------------

'Re-estmate equation so that we can easily call the coefficient values for this equation
smpl %sd_approvals %ed	
ss_other.ml

'Constrain GST dummies to full-sample effect by adusting the LHS variable. Otherwise we can't run the Quandt-Andrews test.
smpl @all
series dlotheradj = dlog(baothervol) - (c(5)*gst(-1) + c(6)*gst ) 

'Estimate by OLS
smpl %sd_approvals %ed
equation eqn_other_ols.ls dlotheradj log(baothervol(-1)/rinc(-1)) dlog(baothervol(-1)) dlog(baothervol(-2)) dlog(rdp(-1)) dlog(rdp(-2)) d(rvmr(-4)) d(rvmr(-5)) d(rvmr(-6)) c
'Run Quandt-Andrews test 
'[NOTE: To run the test, comment out the code below. For some reason EViews will not allow you to do a test on the intercept only without using the 'prompt' command, so it's easier to leave this commented out most of the time]
'freeze(_stability_other) eqn_other_ols.ubreak(prompt) 15 @ c

'Alterations and additions
'--------------

'Re-estmate equation so that we can easily call the coefficient values for this equation
smpl %sd_approvals %ed	
ss_other.ml

'Constrain GST dummies to full-sample effect by adusting the LHS variable. Otherwise we can't run the Quandt-Andrews test.
smpl @all
series dlaaadj = dlog(baaavol) - (c(6)*gst(-1) + c(7)*gst ) 

'Estimate by OLS
smpl %sd_approvals %ed
equation eqn_aa_ols.ls dlaaadj log(baaavol(-1)/rinc(-1)) dlog(baaavol(-1))  dlog(rdp(-1)) dlog(rdp(-2)) d(rvmr(-1)) d(rvmr(-2)) d(rvmr(-3)) c
'Run Quandt-Andrews test 
'[NOTE: To run the test, comment out the code below. For some reason EViews will not allow you to do a test on the intercept only without using the 'prompt' command, so it's easier to leave this commented out most of the time]
'freeze(_stability_aa) eqn_aa_ols.ubreak(prompt) 15 @ c

'Update progress table
!progress_row = !progress_row+1
progress(!progress_row,1) = "1_housing_approvals_eqns"


