'-------------------
'Program written by Trent Saunders

'This program:
'	1. Create quarterly forward rates data and extend workfile
'	2. Constructs current forward curve
'	3. Constructs projections of 10-year government bond yield as geometric average of zero-coupon forward curve
'-------------------

'---------
'1.	Create quarterly forward rates data and extend workfile
'---------

group _group_forward
for !i = 0 to 40
	copy(c=a) daily\FORWARD{!i} *
	_group_forward.add FORWARD{!i}
next

'Extend the end date of workfile to be at least 20 years after start of forecast period
'This is necessary to calculate long-term interest rates for the model project
'---------
if @dtoo(%ed)+140 > @dtoo(%efc) then
 %last = @otod(@dtoo(%ed)+140)
else
 %last = %efc
endif

pagestruct(end=%last) 

'---------
'2.	Construct current forward curve
'---------
smpl %sfc %sfc+40
scalar sh = @recode(@obssmpl < 40, @obssmpl, 40)

for !i = 0 to sh
	smpl %sfc+!i %sfc+!i
	series forward_current = forward{!i}(-!i)
next

smpl %sd %sfc-1
series forward_current = @recode(forward_current=na,cash,forward_current)
smpl %sfc %last
series forward_current = @recode(forward_current=na,forward_current(-1),forward_current)

'------------------
'3.	Construct projections of 10-year government bond yield as geometric average of zero-coupon forward curve
'------------------

smpl %sfc %sfc+40
series i_10y_bond_targ = exp(@movav(log(forward_current(40)),40))  'Calculate the geometric average of 10-year forward curve

if @dtoo(%sfc)+40 < @dtoo(%efc) then
	smpl %sfc+40 %efc
	series i_10y_bond_targ = i_10y_bond_targ(-1)
endif

'Update progress table
!progress_row = !progress_row+1
progress(1,1) = "0_data_forward_rates"
show progress


