/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  
    April 2016.                                 
***************************************************************/

clear all

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\euewt90"

* open file of matched jobs with their assigned sample weights
use euewt90, clear

format asco4 anzsco occupatn occupatn06 cpsi ppsi cresp presp cesti pesti stateest %10.0g 

egen  id = group(unitid)
sort  id surveyq

xtset id surveyq


* Identify cases of imputed wage movements
tab surveyq cesti
tab surveyq pesti
tab surveyq cresp
tab surveyq presp 

gen imputed = 1 if cresp!=1 | presp!=1

/**************************************************************
 Percentage change in wages
 
 Two methods to compute:
 a1. not accounting for splicing
		- just use the 4-qtr-ended percentage change in the p1 variable
 a2. accounting for splicing 
		- use information on the previous quarter p1 to backcast
		  before calculating the 4-qtr-ended percentage change
 
p1: base ordinary time excluding bonuses 
p2: base ordinary time including bonuses 
p3: base total hours excluding bonuses 
p4: base total hours including bonuses 
 **************************************************************/

* quarterly change in log wage, including all splices and imputations 
gen wage_spl1_dln = ln(p1) - ln(p1_p)

* quarterly change in log wage, excluding all splices 
gen wage_spl2_dln = ln(p1) - ln(L1.p1)

keep unitid surveyq p1 p1_p wage_spl1_dln wage_spl2_dln

* Give all job-level variables an j_ prefix
foreach var of varlist _all {
rename `var' w_`var'
}
*
rename w_surveyq  surveyq
rename w_unitid   merge_id
 
save euewt90_master, replace

* end of do file
