/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  
    April 2016. 
    It appends the quarterly euewt90 files, seperately for   
    each survey quarter                                     
***************************************************************/

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\euewt90"

  use Mar15dta, clear
  quietly compress
  gen survey =  "Mar15"
  save euewt90_Mar, replace
  clear
  *erase Mar15dta.dta 

* 
  foreach x in 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 {
    use Mar`x'dta, clear
    quietly compress
    append using euewt90_Mar
	replace survey = "Mar`x'" if survey==""
    save euewt90_Mar, replace
    clear
	*erase Mar`x'dta.dta
}
*

foreach q in Jun Sep Dec {

  use `q'15dta, clear
  quietly compress
  gen survey =  "`q'15"
  save euewt90_`q', replace
  clear
  *erase `q'15dta.dta

  * 
  foreach x in 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 98 {
    use `q'`x'dta, clear
    quietly compress
    append using euewt90_`q'
	replace survey = "`q'`x'" if survey==""
    save euewt90_`q', replace
    clear
	*erase `q'`x'dta.dta
}
}
*

use euewt90_Mar, clear
append using euewt90_Jun
append using euewt90_Sep
append using euewt90_Dec

gen quarter = substr(survey,1,3)
gen year    = substr(survey,4,2)
drop survey

destring year, replace
replace  year=year+1900 if year>=96 & year<=99
replace  year=year+2000 if year >=0 & year<=20

replace  quarter="1" if quarter=="Mar"
replace  quarter="2" if quarter=="Jun"
replace  quarter="3" if quarter=="Sep"
replace  quarter="4" if quarter=="Dec"
destring quarter, replace

gen surveyq = yq(year, quarter)
format surveyq %tq


sort unitid surveyq

save euewt90, replace

* end of do file
