/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  
    April 2016. 
    It appends the quarterly job files, seperately for   
    each survey quarter                                     
***************************************************************/

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\jobdata"

* append quarterly files together

  use Mar16dta, clear
  quietly compress
  gen survey =  "Mar16"
  save jobdata_Mar, replace
  clear
  erase Mar16dta.dta

  foreach x in 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 {
    use Mar`x'dta, clear
    quietly compress
    append using jobdata_Mar
	replace survey = "Mar`x'" if survey==""
    save jobdata_Mar, replace
    clear
	erase Mar`x'dta.dta
}
*

foreach q in Jun Sep {

  use `q'16dta, clear
  quietly compress
  gen survey =  "`q'16"
  save jobdata_`q', replace
  clear
  erase `q'16dta.dta

  foreach x in 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 98 {
    use `q'`x'dta, clear
    quietly compress
    append using jobdata_`q'
	replace survey = "`q'`x'" if survey==""
    save jobdata_`q', replace
    clear
	erase `q'`x'dta.dta
}
}
*

foreach q in Dec {

  use `q'15dta, clear
  quietly compress
  gen survey =  "`q'15"
  save jobdata_`q', replace
  clear
  erase `q'15dta.dta

  foreach x in 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 98 {
    use `q'`x'dta, clear
    quietly compress
    append using jobdata_`q'
	replace survey = "`q'`x'" if survey==""
    save jobdata_`q', replace
    clear
	erase `q'`x'dta.dta
}
}
*

* end of do file
