/**************************************************************/
/*  Program created by James Bishop during RBA inposting in  
    April 2016. 
    It appends the quarterly job files, seperately for   
    each survey quarter                                     
***************************************************************/

set more off

cd "\\sasnasprd\SASData\W386\RBA\dta_files\mujaa90"

  use Mar15dta, clear
  quietly compress
  gen survey =  "Mar15"
  save mujaa90_Mar, replace
  clear
  *erase Mar15dta.dta 


  foreach x in 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 {
    use Mar`x'dta, clear
    quietly compress
    append using mujaa90_Mar
	replace survey = "Mar`x'" if survey==""
    save mujaa90_Mar, replace
    clear
	*erase Mar`x'dta.dta
}
*

foreach q in Jun Sep Dec {

  use `q'15dta, clear
  quietly compress
  gen survey =  "`q'15"
  save mujaa90_`q', replace
  clear
  *erase `q'15dta.dta

  foreach x in 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00 99 98 {
    use `q'`x'dta, clear
    quietly compress
    append using mujaa90_`q'
	replace survey = "`q'`x'" if survey==""
    save mujaa90_`q', replace
    clear
	*erase `q'`x'dta.dta
}
}
*

* end of do file
