***** This code gives outlines how a number of the variables in 'Main_data_file' were constructed
***** A number of series have been imported from elsewhere. Details on them are in the labels
***** File is not interded to be run to cosntrcut the series, but just to give details on theiir constrcution

***** For Hambur and La Cava (2018) ******


* Set up panel
egen asxnum = group(asxcode)
xtset asxnum year

************ Make Delist series


* Delist variables
gen list_year=year(List_date)
gen delist_year=year(Delist_date)

gen delist1=0
replace delist1=1 if delist_year-year==1 | delist_year-year==0

gen delist2=0
replace delist2=1 if delist_year-year==2 | delist_year-year==1 | delist_year-year==0


************ Age size and riskiness variables
gen age = year-list_year
gen age_sq = age^2
gen age_ln= log(age)

gen lk_all=log(k_all)
gen lk_ppe=log(k_ppe)

* Percentiles for aasets each year
sort year
by year:egen assetsp25=pctile(assets),p(25)
by year:egen assetsmedian=median(assets)
by year:egen assetsp75=pctile(assets), p(75)
by year:egen assetsp90=pctile(assets), p(90)

by year:egen D2D25=pctile(D2D),p(25)



gen small=0
replace small=1 if assets<assetsmedian

gen medium=0
replace medium=1 if assets<assetsp75&assets>=assetsmedian

gen large=0
replace large=1 if assets>=assetsp75

gen vlarge=0
replace vlarge=1 if assets>=assetsp90

* Generate risky
gen risky = 0
replace risky = 1 if D2D<D2D25

xtset asxnum year




************ Make adjusted interest rate series

* Log of main interest rate variable
gen lir=log(irliabtot)

* Cost of debt measures
gen lir_r=log(irliabtot*.7-infl)
gen cod=irliabtot*.7-infl

* Implied measures (interest expense/debt) 
replace Imp_ir=-Imp_ir
replace Imp_ir_avg=-Imp_ir_avg
 
gen lir_imp=log(Imp_ir)
gen lir_imp_avg=log(Imp_ir_avg)

*Splice 2 measures
gen lir_splice= log(ir_splice)
gen lir_splice_avg= log(ir_splice_avg)

*******************Make individual cost of equity series

*Splice both firm-level beta measures
gen beta_splice = Beta_adj
replace beta_splice=Beta_non if beta_splice==0
gen beta_splice_adj=beta_splice
replace beta_splice_adj = . if beta_splice_adj<-.5
replace beta_splice_adj = . if beta_splice_adj>3

*Firm-level cost of equity
gen coe=rf+beta_splice*(e_yield-rf)
gen coe_adj=rf+beta_splice_adj*(e_yield-rf)


*Make weighting series
gen neg_eq=0 
replace neg_eq=1 if equity<0
replace equity=0 if equity<0
replace debt = 0 if debt==.

gen debt_weight = debt/(debt+equity)
gen equity_weight = equity/(debt+equity)

*Make indicator for last observation so no issue using other firm's cost of debt

egen last_obs=max(date), by(asxnum)
gen is_last_obs=0
replace is_last_obs=1 if date==last_obs
drop last_obs

*** Make cost of finance series
*Weigthed cost of equity
gen w_coe = equity_weight*coe

gen w_coe_adj = equity_weight*coe_adj

gen w_coe_sec = equity_weight*coe_sec

* Weighted cost of debt
gen w_cod_ir = debt_weight * (irliabtot[_n-1]*.7-infl[_n-1])
replace w_cod_ir = . if is_last_obs[_n-1]==1
replace w_cod_ir = 0 if debt==0

gen w_cod_splice = debt_weight*ir_splice*.7
replace w_cod_splice = 0 if debt==0

gen w_cod_splice_avg = debt_weight*ir_splice_avg*.7
replace w_cod_splice_avg = 0 if debt==0

*Firm cost of finance
gen cof_ir = w_coe+w_cod_ir
gen lcof_ir=log(cof_ir)
gen cof_adj_ir = w_coe_adj+w_cod_ir
gen lcof_adj_ir=log(cof_adj_ir)

gen cof_splice = w_coe+w_cod_splice
gen lcof_splice = log(cof_splice)
gen cof_adj_splice = w_coe_adj+w_cod_splice
gen lcof_adj_splice = log(cof_adj_splice)

gen cof_splice_avg = w_coe+w_cod_splice_avg
gen lcof_splice_avg = log(cof_splice_avg)
gen cof_adj_splice_avg = w_coe_adj+w_cod_splice_avg
gen lcof_adj_splice_avg = log(cof_adj_splice_avg)

*Sectoral cost of finance
gen cof_ir_sec = w_coe_sec+w_cod_ir
gen lcof_ir_sec=log(cof_ir_sec)

gen cof_splice_sec = w_coe_sec+w_cod_splice
gen lcof_splice_sec = log(cof_splice_sec)

gen cof_splice_avg_sec = w_coe_sec+w_cod_splice_avg
gen lcof_splice_avg_sec = log(cof_splice_avg_sec)

*Make log deflator series
gen ldefl_ppe=log(defl_ppe)

************Make trimming series 
sort year

by year: egen Inv_all_cash_k_p1= pctile(Inv_all_cash_k),p(1)
by year: egen Inv_all_cash_k_p5= pctile(Inv_all_cash_k),p(5)
by year: egen Inv_all_cash_k_p99= pctile(Inv_all_cash_k),p(99)
by year: egen Inv_all_cash_k_p95= pctile(Inv_all_cash_k),p(95)

by year: egen Inv_ppe_cash_k_p1= pctile(Inv_ppe_cash_k),p(1)
by year: egen Inv_ppe_cash_k_p5= pctile(Inv_ppe_cash_k),p(5)
by year: egen Inv_ppe_cash_k_p99= pctile(Inv_ppe_cash_k),p(99)
by year: egen Inv_ppe_cash_k_p95= pctile(Inv_ppe_cash_k),p(95)

by year: egen Inv_all_cash_al_p1= pctile(Inv_all_cash_al),p(1)
by year: egen Inv_all_cash_al_p5= pctile(Inv_all_cash_al),p(5)
by year: egen Inv_all_cash_al_p99= pctile(Inv_all_cash_al),p(99)
by year: egen Inv_all_cash_al_p95= pctile(Inv_all_cash_al),p(95)

by year: egen Inv_ppe_cash_al_p1= pctile(Inv_ppe_cash_al),p(1)
by year: egen Inv_ppe_cash_al_p5= pctile(Inv_ppe_cash_al),p(5)
by year: egen Inv_ppe_cash_al_p99= pctile(Inv_ppe_cash_al),p(99)
by year: egen Inv_ppe_cash_al_p95= pctile(Inv_ppe_cash_al),p(95)

by year: egen Inv_all_cash_a_p1= pctile(Inv_all_cash_a),p(1)
by year: egen Inv_all_cash_a_p5= pctile(Inv_all_cash_a),p(5)
by year: egen Inv_all_cash_a_p99= pctile(Inv_all_cash_a),p(99)
by year: egen Inv_all_cash_a_p95= pctile(Inv_all_cash_a),p(95)

by year: egen Inv_ppe_cash_a_p1= pctile(Inv_ppe_cash_a),p(1)
by year: egen Inv_ppe_cash_a_p5= pctile(Inv_ppe_cash_a),p(5)
by year: egen Inv_ppe_cash_a_p99= pctile(Inv_ppe_cash_a),p(99)
by year: egen Inv_ppe_cash_a_p95= pctile(Inv_ppe_cash_a),p(95)

by year: egen Inv_all_ncash_k_p1= pctile(Inv_all_ncash_k),p(1)
by year: egen Inv_all_ncash_k_p5= pctile(Inv_all_ncash_k),p(5)
by year: egen Inv_all_ncash_k_p99= pctile(Inv_all_ncash_k),p(99)
by year: egen Inv_all_ncash_k_p95= pctile(Inv_all_ncash_k),p(95)

by year: egen Inv_ppe_ncash_k_p1= pctile(Inv_ppe_ncash_k),p(1)
by year: egen Inv_ppe_ncash_k_p5= pctile(Inv_ppe_ncash_k),p(5)
by year: egen Inv_ppe_ncash_k_p99= pctile(Inv_ppe_ncash_k),p(99)
by year: egen Inv_ppe_ncash_k_p95= pctile(Inv_ppe_ncash_k),p(95)

by year: egen Inv_all_ncash_al_p1= pctile(Inv_all_ncash_al),p(1)
by year: egen Inv_all_ncash_al_p5= pctile(Inv_all_ncash_al),p(5)
by year: egen Inv_all_ncash_al_p99= pctile(Inv_all_ncash_al),p(99)
by year: egen Inv_all_ncash_al_p95= pctile(Inv_all_ncash_al),p(95)

by year: egen Inv_ppe_ncash_al_p1= pctile(Inv_ppe_ncash_al),p(1)
by year: egen Inv_ppe_ncash_al_p5= pctile(Inv_ppe_ncash_al),p(5)
by year: egen Inv_ppe_ncash_al_p99= pctile(Inv_ppe_ncash_al),p(99)
by year: egen Inv_ppe_ncash_al_p95= pctile(Inv_ppe_ncash_al),p(95)


by year: egen Inv_all_st_k_p1= pctile(Inv_all_st_k),p(1)
by year: egen Inv_all_st_k_p5= pctile(Inv_all_st_k),p(5)
by year: egen Inv_all_st_k_p99= pctile(Inv_all_st_k),p(99)
by year: egen Inv_all_st_k_p95= pctile(Inv_all_st_k),p(95)

by year: egen Inv_ppe_st_k_p1= pctile(Inv_ppe_st_k),p(1)
by year: egen Inv_ppe_st_k_p5= pctile(Inv_ppe_st_k),p(5)
by year: egen Inv_ppe_st_k_p99= pctile(Inv_ppe_st_k),p(99)
by year: egen Inv_ppe_st_k_p95= pctile(Inv_ppe_st_k),p(95)

by year: egen Inv_all_st_al_p1= pctile(Inv_all_st_al),p(1)
by year: egen Inv_all_st_al_p5= pctile(Inv_all_st_al),p(5)
by year: egen Inv_all_st_al_p99= pctile(Inv_all_st_al),p(99)
by year: egen Inv_all_st_al_p95= pctile(Inv_all_st_al),p(95)

by year: egen Inv_ppe_st_al_p1= pctile(Inv_ppe_st_al),p(1)
by year: egen Inv_ppe_st_al_p5= pctile(Inv_ppe_st_al),p(5)
by year: egen Inv_ppe_st_al_p99= pctile(Inv_ppe_st_al),p(99)
by year: egen Inv_ppe_st_al_p95= pctile(Inv_ppe_st_al),p(95)

by year: egen Q1= pctile(Q),p(1)
by year: egen Q5= pctile(Q),p(5)
by year: egen Q99= pctile(Q),p(99)
by year: egen Q95= pctile(Q),p(95)

******* Make cash flow Senstivity series - not used in this paper

xtset asxnum year

*Make distressed indicators
gen LM=0
replace LM=1 if annual_ebitda<0

*** Net floating assets based measures
gen nfa=(assetsfloating-liabfloating)/1000
gen nfa_1yr=(assetsfloating+assetsfixedless1year-liabfloating-liabfixedless1year)/1000


* Change in cash due change in OIS based NFA
gen cf_ois1=(ois_1-ois_1[_n-1])*nfa[_n-1]/100
replace cf_ois1 = . if is_last_obs[_n-1]==1

gen cf_ois6=(ois_6-ois_6[_n-1])*nfa[_n-1]/100
replace cf_ois6 = . if is_last_obs[_n-1]==1

gen cf_ois1_1yr=(ois_1-ois_1[_n-1])*nfa_1yr[_n-1]/100
replace cf_ois1_1yr = . if is_last_obs[_n-1]==1

gen cf_ois6_1yr=(ois_6-ois_6[_n-1])*nfa_1yr[_n-1]/100
replace cf_ois6_1yr = . if is_last_obs[_n-1]==1

gen cf_ois1_k=cf_ois1/k_ppe[_n-1]
gen cf_ois6_k=cf_ois6/k_ppe[_n-1]
gen cf_ois1_k_lm=cf_ois1_k*LM
gen cf_ois6_k_lm= cf_ois6_k*LM


gen cf_ois1_1yr_k=cf_ois1_1yr/k_ppe[_n-1]
gen cf_ois6_1yr_k=cf_ois6_1yr/k_ppe[_n-1]
gen cf_ois1_1yr_k_lm=cf_ois1_1yr_k*LM
gen cf_ois6_1yr_k_lm= cf_ois6_1yr_k*LM

gen cf_ois1_a=cf_ois1/assets[_n-1]
gen cf_ois6_a=cf_ois6/assets[_n-1]
gen cf_ois1_a_lm=cf_ois1_k*LM
gen cf_ois6_alm= cf_ois6_k*LM


gen cf_ois1_1yr_a=cf_ois1_1yr/assets[_n-1]
gen cf_ois6_1yr_a=cf_ois6_1yr/assets[_n-1]
gen cf_ois1_1yr_a_lm=cf_ois1_1yr_a*LM
gen cf_ois6_1yr_a_lm= cf_ois6_1yr_a*LM

*** Make self assess series

xtset asxnum year


gen cf_self=(cashflowsensitivityBPincrease*100/BP)/1000


* Change in cash due change in OIS based NFA
gen cf_self_ois1=(ois_1-ois_1[_n-1])*cf_self
replace cf_self_ois1 = . if is_last_obs[_n-1]==1

gen cf_self_ois6=(ois_6-ois_6[_n-1])*cf_self[_n-1]
replace cf_self_ois6 = . if is_last_obs[_n-1]==1


gen cf_self_ois1_k=cf_self_ois1/k_ppe[_n-1]
gen cf_self_ois6_k=cf_self_ois6/k_ppe[_n-1]
gen cf_self_ois1_k_lm=cf_self_ois1_k*LM
gen cf_self_ois6_k_lm= cf_self_ois6_k*LM


**** Cash flow sensitivity indicatorss
gen dois1 = (ois_1-ois_1[_n-1])
replace dois1=. if is_last_obs[_n-1]==1

gen dois6 = (ois_6-ois_6[_n-1])
replace dois6=. if is_last_obs[_n-1]==1

gen dir = (irliabtot-irliabtot[_n-1])
replace dir=. if is_last_obs[_n-1]==1

gen nfa_pos=0
replace nfa_pos=1 if nfa>0
gen nfa_pos_1yr=0
replace nfa_pos_1yr=1 if nfa_1yr>0

gen nfa_neg=0
replace nfa_neg=1 if nfa<0
gen nfa_neg_1yr=0
replace nfa_neg_1yr=1 if nfa_1yr<0

gen dois1_pos=dois1*nfa_pos[_n-1]
gen dois1_neg=dois1*nfa_neg[_n-1]
gen dois1_pos_1yr=dois1*nfa_pos_1yr[_n-1]
gen dois1_neg_1yr=dois1*nfa_neg_1yr[_n-1]

gen dois1_pos_lm=dois1_pos*LM
gen dois1_neg_lm=dois1_neg*LM
gen dois1_pos_1yr_lm=dois1_pos_1yr*LM
gen dois1_neg_1yr_lm=dois1_neg_1yr*LM

gen dois6_pos=dois6*nfa_pos[_n-1]
gen dois6_neg=dois6*nfa_neg[_n-1]
gen dois6_pos_1yr=dois6*nfa_pos_1yr[_n-1]
gen dois6_neg_1yr=dois6*nfa_neg_1yr[_n-1]

gen dois6_pos_lm=dois6_pos*LM
gen dois6_neg_lm=dois6_neg*LM
gen dois6_pos_1yr_lm=dois6_pos_1yr*LM
gen dois6_neg_1yr_lm=dois6_neg_1yr*LM

* Drop 2005 so can best see later year dummies
char year[omit] 2005
