%This is the log-likeihood function for the  long-run inflation surveys for 
%  RDP Hambur and Finlay (2018)
% Forecasts are average over 5-years, starting at some point in the future

function [llk, s_infl_std] = llk_fun_infl_LR(yields, W, K1P_cP, K0P_cP, rho0_cP_r, rho1_cP_r, dt, s_infl, s_infl_hor, s_infl_std)

% INPUTS:
% W       : N*J,  weights for the yield portfolios measured without error
% yields  : T*J,  annualized zero coupon yields
% mats    : 1*J,  maturities, in years 
% dt      : scalar, time in years for each period
% K0P_cP     : N*1,      P-dynamics
% K1P_cP     : N*N,      P-dynamics
% s_infl     : T*F       Surveys
% s_infl_hor : 1*F       Survey horizons
% s_infl_std : scalar    Claibrated eorror variance (optional)
%

%   pi(t) = rho0_cP_r + rho1_cP_r'*cPt - one period inflation rate

[t, ~] = size(yields);
[~, F] = size(s_infl);

N=size(W,1);

cP = yields*W'; % Observed factors.

s_infl_hor_p = round(s_infl_hor/dt); % horizons in months

max_for = s_infl_hor_p(F)+61; %Maximum implied inflation forecasts required

months = 1:max_for; %Matrix with all the months we need fo making forecast equivalents to surveys

%Use calibbrates or not?
if isempty(s_infl_std)
    calibrate=0;
else
    calibrate=1;
end

%% Calcualte forecast real and nominal short rates and implied inflation

yrf_r= fit_short(cP,rho0_cP_r, rho1_cP_r,K0P_cP,K1P_cP, months, N,t);

infl_m_ann=yrf_r; % monthly annualised inflation

infl_m = infl_m_ann/12; %Non-annualised inflation

%% Log-liklihood function for inflation

%Calculate fitted PC and errors

inflfit=zeros(t,F); % Matrix to store fitted values
inflerr=zeros(t,F); % Matrix to store errors

inflsum=zeros(1,F); %matrix to sum errors
inflcount=zeros(1,F);  % matrix to sum number of observations for llk

% For each period, iterate over the forecast horizons, calculating the
% inflation forecast over the relevant period
for i=1:t
    for j=1:F;
        if s_infl(i,j)==0
        else
            inflfit(i,j)=sum(infl_m(i,s_infl_hor_p(j)+2:s_infl_hor_p(j)+61))/5;
            inflerr(i,j)=log(s_infl(i,j)+1)-inflfit(i,j); % Calculate error - accounts for fact forecast in for 1+x, buy model in terms exp()
            if calibrate==1
                inflsum(1,j)=inflsum(1,j)+(inflerr(i,j)).^2/(s_infl_std(j)^2);
            end
            inflcount(1,j)= inflcount(1,j)+1;
        end
    end
end

% Calculate llk either using calibrated, or calculated variance
if calibrate==1
    llk=0.5*sum(inflsum');
else
     inflerrsq=inflerr.^2;
     s_infl_std=sqrt(sum(inflerrsq(:))/sum(inflcount(:)));
     llk=sum(0.5*sum(inflerrsq.')/s_infl_std^2)+sum(inflcount(:))*.5*((log(2*pi)+log(s_infl_std^2)));
end