%LL function used in the KF optimisation for Hambur and Finlay (2018)
% Adapted from JSZ)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Likelihoood function.  Very extreme parameters may have numerical
% problems since some intermediate matrices may be nearly non-singular.  In
% this case set the likelihood to a "bad" default value.

function [llk] = LLK_KF0(yields_o, yields_n, yields_r, W, K1Q_X, kinfQ, cholSigma_cP, rho0_X_r, rho1_X_r, mats, mats_r, dt, K0P_cP, K1P_cP, sigma_e_n, sigma_e_r, s_infl, s_infl_hor, s_infl_std, s_inflQ, s_inflQ_hor, s_inflQ_std,s_inflLR, s_inflLR_hor, s_inflLR_std, s_cash, s_cash_hor,s_cash_std,min_r)

N=size(W,1);
inds = find(tril(ones(N)));
L(inds) = cholSigma_cP;
L = reshape(L, [N,N]);
Sigma_cP = L*L';

default_llk = 1000;
try
    llk = sum(jszLLK_KF_r_start(yields_o, yields_n, yields_r, W, K1Q_X, kinfQ, Sigma_cP, rho0_X_r, rho1_X_r, mats, mats_r, dt, K0P_cP, K1P_cP, sigma_e_n, sigma_e_r, s_infl, s_infl_hor, s_infl_std, s_inflQ, s_inflQ_hor, s_inflQ_std,s_inflLR, s_inflLR_hor, s_inflLR_std, s_cash, s_cash_hor,s_cash_std,min_r));
    if isnan(llk) || ~isreal(llk) || ~isfinite(llk)
        llk = default_llk;
    end
catch
	llk = default_llk;
end
% 
% if llk<-100
%     [llks, AcP, BcP, AX, BX, K0Q_cP, K1Q_cP, rho0_cP, rho1_cP, cP, yields_filtered, cP_filtered] = ...
%     jszLLK_KF(yields, W, K1Q_X_I, kinfQ_I, Sigma_cP_I, mats, dt, K0P_cP_I, K1P_cP_I, sigma_e_I);
% %     keyboard
% end