function [By, Ay] = gaussianDiscreteYieldLoadingsRecurrence_real(maturities, K0d, K1d, H0d, rho0d_r, rho1d_r, rho0d, rho1d, timestep)

% This program is adapated from the noominal version from JSZ. It calculates the A and
% B loadings on the factors to get the fitted yields.
% The recursion is similair to the nominal one. For details see Appendix to Hambur and Finlay (2018)

M = length(maturities);
N = length(K0d);
Atemp = 0;
Btemp = zeros(N,1);
A = nan(1,M);
B = nan(N,M);

curr_mat = 1;
for i=1:maturities(M)
    Atemp = Atemp + K0d'*(Btemp+rho1d_r) +.5*(Btemp+rho1d_r)'*H0d*(Btemp+rho1d_r) + rho0d_r-rho0d;
    Btemp = (Btemp+rho1d_r) + K1d'*(Btemp+rho1d_r) - rho1d;
    
    if i==maturities(curr_mat)
        Ay(1,curr_mat) = -Atemp/maturities(curr_mat);
        By(:,curr_mat) = -Btemp/maturities(curr_mat);
        curr_mat = curr_mat + 1;
    end
end
    
if nargin==7
    Ay = Ay/timestep;
    By = By/timestep;
end
