%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Likelihoood function.  Very extreme parameters may have numerical
% problems since some intermediate matrices may be nearly non-singular.  In
% this case set the likelihood to a "bad" default value.

function [llk, K1Q_X, Sigma_cP,rho1_X_r,rho0_X_r, K0P_cP,K1P_cP] = llk_fun0_getstart(yields_all,yields_std,yields_non, W, dlamQ, cholSigma_cP, rho0_X_r, rho1_X_r, Gamma_hat,  alpha_hat, mats, mats_r, dt,s_infl, s_infl_hor, s_infl_std, s_inflq, s_infl_q_hor, s_infl_q_std,s_inflLR, s_infl_LR_hor, s_infl_LR_std, s_cash, s_cash_hor,s_cash_std, s_10year, s_10year_hor, N_n, N_r)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Extract the vector parameters:
N = length(dlamQ);
K1Q_X = diag(cumsum(dlamQ));
inds = find(tril(ones(N)));
L(inds) = cholSigma_cP;
L = reshape(L, [N,N]);
Sigma_cP = L*L';
K0P_cP=alpha_hat;
K1P_cP=reshape(Gamma_hat,[N,N]);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


default_llk = 1e20;
try
    llk = jszLLK_kinf_conc_r_sur1(yields_all,yields_std,yields_non, W, K1Q_X, Sigma_cP, rho0_X_r, rho1_X_r,K1P_cP,K0P_cP, mats, mats_r, dt, s_infl, s_infl_hor, s_infl_std, s_inflq, s_infl_q_hor, s_infl_q_std,s_inflLR, s_infl_LR_hor, s_infl_LR_std, s_cash, s_cash_hor, s_cash_std, s_10year, s_10year_hor, N_n, N_r);
    if isnan(llk) || ~isreal(llk) || ~isfinite(llk)
        llk = default_llk;
    end
catch
	llk = default_llk;
end