function [llk, AcP, BcP, AX, BX, kinf, K0P_cP, K1P_cP, sigma_e_n, sigma_e_r, K0Q_cP, K1Q_cP, rho0_cP, rho1_cP, rho0_cP_r, rho1_cP_r, cP, llkP, llkQ, K0Q_X, K1Q_X, rho0_X, rho1_X] = ...
    jszLLK_kinf_conc_r_sur1(yields_all,yields_std, yields_non, W, K1Q_X, Sigma_cP, rho0_X_r, rho1_X_r,  Gamma_hat, alpha_hat, mats, mats_r, dt,s_infl, s_infl_hor, s_infl_std, s_inflq, s_inflq_hor, s_inflq_std,s_inflLR, s_infl_LR_hor, s_infl_LR_std, s_cash, s_cash_hor,s_cash_std, s_10year, s_10year_hor, N_n, N_r, K0P_cP, K1P_cP, sigma_e, sigma_e_n, sigma_e_r, rankRP)

%
% This function computes the likelihood for a Gaussian term structure.
% See "A New Perspective on Gaussian Dynamic Term Structure Models" by Joslin, Singleton and Zhu
% Adapted to incorporate yeilds on inflation indexed bonds, and to
% incorporate surveys for RDP Hambur and Finlay (2018)
%
% INPUTS:
% yields_all   : (T+1)*J,  matrix of observed yields (first row are t=0
% observations, which likelihood conditions on). std and non version are
% nominal and real only.
% mats       : 1*J,      maturities in years. mats_r is for real
% dt         : scalar,   length of period in years
%
% W          : N*J,      vector of portfolio weights to fit without error.
% K1Q_X      : N*N,      normalized latent-model matrix (does not have to be diagonal, see form below)
% Sigma_cP   : N*N,      positive definite matrix that is the covariance of innovations to cP
% rho0(1)_X_r            inflation=rho0_X_r+rho1_X_r'*Xt are the parameters
% linking inflation to the normalised states
%
% OPTIONAL INPUTS:
% K0P_cP     : N*1,      OPTIONAL (supply [] to omit)
% K1P_cP     : N*N,      OPTIONAL (supply [] to omit)
% sigma_e(_r)    : scalar,   standard error of yield observation errors
%
%
% Compute likelihood conditioned 
%
% llk        : T*1        -log likelihoods 
% AcP        : 1*J       yt = AcP' + BcP'*Xt  (yt is J*1 vector)
% BcP        : N*J       AcP, BcP satisfy internal consistency condition that AcP*W' = 0, BcP*W' = I_N
% AX         : 1*J       yt = AX' + BX'*Xt  
% BX         : N*J       Xt is the 'jordan-normalized' latent state
%
%
% The model takes the form:
%   r(t) = rho0_cP + rho1_cP'*cPt
%        = rinfQ + 1'*Xt  (Xt is the 'jordan-normalized' state
%        = 1 period discount rate (annualized)
%
%   pi(t) = rho0_cP_r + rho1_cP_r'*cPt
%        = rho0_X_r + rho1_X_r'*Xt  (Xt is the 'jordan-normalized' state
%
% Under Q:
%   X(t+1) - X(t)   = K0Q_X  + K1Q_X*X(t)  + eps_X(t+1),   cov(eps_X(t+1)) = Sigma_X
%   cP(t+1) - cP(t) = K0Q_cP + K1Q_cP*cP(t) + eps_cP(t+1),  cov(eps_cP(t+1)) = Sigma_cP
%   where Sigma_X is chosen to match Sigma_cP 
% and K0Q_X(m1) = kinfQ where m1 is the multiplicity of the highest eigenvalue (typically 1)
%
% Under P:
%   cP(t+1) - cP(t) = K0P_cP + K1P_cP*cP(t) + eps_cP(t+1),  cov(eps_cP(t+1)) = Sigma_cP
%
% Model yields are given by:
%   yt^m = AcP' + BcP'*cPt  (J*1)
% And observed yields are given by:
%  yt^o = yt^m + epsilon_e(t)
% where V*epsilon_e~N(0,sigma_e^2 I_(J-N))
% and V is an (J-N)*J matrix which projects onto the span orthogonal to the
% row span of W.  This means errors are orthogonal to cPt and cPt^o = cPt^m.
%
    
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Setup 
[T,J] = size(yields_all(2:end,:));
[T_n,J_n] = size(yields_std(2:end,:));
[T_r,J_r] = size(yields_non(2:end,:));

N = size(W,1);
cP = yields_all*W'; % (T+1)*N, cP stands for math caligraphic P.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Setup whether to include surveys, and estiamtes of other parameters:
concentrateSigmaE = true; %include calibrated yield noise - need have inputs for nominal and real
concentrateAlpha = true; %calculate K0P_cP or implied by average and K1P_cP
concentrateSurveyinfl = false; %include inflation forecasts?
concentrateSurveyinflq = false;
concentrateSurveyinflLR = false;
concentrateSurveycash = false;
concentrateSurvey10 = false;
if exist('s_infl', 'var') && ~isempty(s_infl), concentrateSurveyinfl = true; end
if exist('s_inflq', 'var') && ~isempty(s_inflq), concentrateSurveyinflq = true; end
if exist('s_inflLR', 'var') && ~isempty(s_inflLR), concentrateSurveyinflLR = true; end
if exist('s_cash', 'var') && ~isempty(s_cash), concentrateSurveycash = true; end
if exist('s_10year', 'var') && ~isempty(s_10year), concentrateSurvey10 = true; end
if exist('sigma_e','var') && ~isempty(sigma_e), concentrateSigmaE = false; end
if exist('alpha_hat','var') && ~isempty(alpha_hat), concentrateAlpha = false; end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% COMPUTE THE Q-LIKELIHOOD:
% First find the loadings for the model:
% yt = AcP' + BcP'*cPt, AcP is 1*J, BcP is N*J
% AcP = alpha0_cP*kinf + alpha1_cP

rho0_cP = 0;
% AcP0, AX0 will be the loadings with rho0_cP = 0, which won't be correct,
% but the alphas will be correct, so can solve for kinf (see
% jszLoadings_rho0cP_r1 program for more details)
[BcP, AcP0, K0Q_cP, K1Q_cP, rho0_cP, rho1_cP, K0Q_X, K1Q_X, AX0, BX, Sigma_X, alpha0_cP, alpha1_cP, alpha0_X, alpha1_X, m1] = jszLoadings_rho0cP_r1(W, K1Q_X, rho0_cP, Sigma_cP,rho0_X_r, rho1_X_r, mats, mats_r, dt);
V = null(W)'; %orthonormal basis of the weighting matrix. 
%We use this so we can solve 
% ybar=AcP+BcP*Pbar (as E(e)=0 -  sample means instead of expectation)
%      =alpha1_cP+alpha0_cp*kinf+BcP*Pbar
kinf = ((mean(yields_all)' - alpha1_cP' - BcP'*mean(cP).')'*(V'*V*alpha0_cP')) / (alpha0_cP*V'*V*alpha0_cP');

% Now get correct A loadings and KQ matrices
AX = alpha0_X*kinf + alpha1_X;
AcP = alpha0_cP*kinf + alpha1_cP;
K0Q_X = zeros(N,1);
K0Q_X(m1) = kinf;

% Use the nroalmlised coeffcients to rotate back to standard representation
rho0_X = 0;
rho1_X = ones(N,1);
[K0Q_cP, K1Q_cP, rho0_cP, rho1_cP,rho0_cP_r, rho1_cP_r] = jszRotation_r(W, K1Q_X, K0Q_X, rho1_X, rho0_X, rho1_X_r, rho0_X_r, BX, AX);

% Calalcute yield fitting errors
yields_m =  ones(T+1,1)*AcP + cP*BcP; % (T+1)*J, model-implied yields
yield_errors = yields_all - yields_m; % T*J

square_orthogonal_yield_errors = (yield_errors).^2; % T*J, but N-dimensional projection onto W is always 0, so effectively (J-N) dimensional
square_orthogonal_yield_errors_n=square_orthogonal_yield_errors(:,1:J_n);
square_orthogonal_yield_errors_r=square_orthogonal_yield_errors(:,J_n+1:end);

% Compute optimal sigma_e_n(_r) if it is not supplied 
if concentrateSigmaE
    sigma_e = sqrt( sum(square_orthogonal_yield_errors(:))/((T+1)*(J-N)) );
    sigma_e_n = sqrt( sum(square_orthogonal_yield_errors_n(:))/((T+1)*(J_n-N_n)) );
    sigma_e_r = sqrt( sum(square_orthogonal_yield_errors_r(:))/((T+1)*(J_r-N_r)) );
end

% Likleihhod for yields
llkQ = sum(.5*sum(square_orthogonal_yield_errors_n.')/sigma_e_n^2 + (J_n-N_n)*.5*log(2*pi) + .5*(J_n-N_n)*log(sigma_e_n^2))+ ... 
    sum(.5*sum(square_orthogonal_yield_errors_r.')/sigma_e_r^2 + (J_r-N_r)*.5*log(2*pi) + .5*(J_r-N_r)*log(sigma_e_r^2)); 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% COMPUTE THE P-LIKELIHOOD for factors and surveys:

%Set up llks
llkP=0;
llkinfl=0;
llkinflq=0;
llkinflLR=0;
llkcash=0;
llk10=0;

%LLK for the factors
K1P_cP=Gamma_hat;
if concentrateAlpha==true
    K0P_cP=mean(cP)'-(K1P_cP+eye(N))*mean(cP)';
    innovations = cP(2:end,:).' - (K0P_cP*ones(1,T) + (eye(N)+K1P_cP)*cP(1:end-1,:).'); % N*T
    
else 
    K0P_cP=alpha_hat;
    innovations = cP(2:end,:).' - (K0P_cP*ones(1,T) + (eye(N)+K1P_cP)*cP(1:end-1,:).'); % N*T
end

llkP = sum(.5*N*log(2*pi) + .5*log(det(Sigma_cP)) + .5*sum(innovations.*(Sigma_cP\innovations),1)); % 1*T

Omega_hat=1/(T-1)*(innovations*innovations'); %Sample covariance matrix for the factors

%LLK for each of the surveys, if they are available
if concentrateSurveyinfl 
    llkinfl = llk_fun_infl_direct(yields_all, W, K1P_cP, K0P_cP, rho0_cP_r, rho1_cP_r, dt, s_infl, s_infl_hor, s_infl_std);
end

if concentrateSurveyinflLR 
    llkinflLR = llk_fun_infl_LR(yields_all, W, K1P_cP, K0P_cP, rho0_cP_r, rho1_cP_r, dt, s_inflLR, s_infl_LR_hor, s_infl_LR_std);
end

if concentrateSurveyinflq 
    llkinflq = llk_fun_infl_q(yields_all, W, K1P_cP, K0P_cP, rho0_cP_r, rho1_cP_r, dt, s_inflq, s_inflq_hor, s_inflq_std);
end

if concentrateSurveycash
    llkcash= llk_fun_cash(yields_all, W, K1P_cP, K0P_cP, rho0_cP, rho1_cP, dt, s_cash, s_cash_hor,s_cash_std);
end

% Not used, but could theoretically be incorporated
if concentrateSurvey10
     llk10=llk_fun_10year(yields_all, W, AcP(1:j_N), BcP(:,1:j_N), K1P_cP, K0P_cP, mats, dt, s_10year, s_10year_hor);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% Total likelihood
llk = (llkQ + llkP+llkinfl+llkinflq+llkcash+llk10+llkinflLR).'; % T*1 series
if abs(imag(llk))>0
    llk=1e21;
end

