%% Plot_figure_9

% Extract density-based estimator core/periphery splits from CPvecGlob
split = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));
for t = 1:size(banks_status_mtx,1)
    split(:,t) = CPvecGlob{3,t}';
end

% Determine graph vertical ordering (based on number of quarters in the
% core)
order = zeros(size(banks_status_mtx,2),2);
order(:,1) = (1:1:size(banks_status_mtx,2))';
order(:,2) = sum(split,2);
order = sortrows(order,2,'descend');

% Construct matrix for use in plot
graphmat = zeros(sum(order(:,2)>0),size(banks_status_mtx,1));
for i = 1:sum(order(:,2)>0)
    graphmat(i,:) = split(order(i,1),:).*i;
end

% For use in horizontal axis of plot
if Flag == 1
    time = datetime(unique(loans_aggreg(:,1)),'ConvertFrom','datenum','Format','MMM-yy');
else
    time = (1:1:size(coreSize_min,1))';
end

% Plot
figure('Color',[1 1 1])
hold all
if Flag == 1
    for i = 1:sum(order(:,2)>0)
        % Information on the major banks and foreign banks comes from
        % ID.mat (loaded as part of RUN_data.m).
        if sum(find(maj==1)==order(i,1))>0
            pm = plot(time,graphmat(i,:),'ok','MarkerFaceColor','k');
        elseif sum(find(foreign==1)==order(i,1))>0
            pf = plot(time,graphmat(i,:),'om','MarkerFaceColor','m');
        else
            po = plot(time,graphmat(i,:),'or','MarkerFaceColor','r');
        end
    end
    legend([pm pf po],'Major banks','Foreign-owned banks','Other Australian-owned banks','Location','best')
    xlim(datetime([2005 2016],[1 12],[1 31]))
    xtickformat('MMM-yy')
else
    for i = 1:1:sum(order(:,2)>0)
        plot(time,graphmat(i,:),'ok','MarkerFaceColor','k');
    end
end    
title('Core Composition')
grid off
ylim([1 sum(order(:,2)>0)])
yticks([])
hold off

clear time pm pf po split order graphmat i t 